/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.argumentselectiondefects;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.argumentselectiondefects.AutoValue_Parameter;
import com.google.errorprone.names.NamingConventions;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.Name;
import java.util.List;
import java.util.Optional;

@AutoValue
abstract class Parameter {
    private static final ImmutableSet<String> METHODNAME_PREFIXES_TO_REMOVE = ImmutableSet.of((Object)"get", (Object)"set", (Object)"is");
    @VisibleForTesting
    static final String NAME_NULL = "*NULL*";
    @VisibleForTesting
    static final String NAME_NOT_PRESENT = "*NOT_PRESENT*";

    Parameter() {
    }

    abstract String name();

    abstract Type type();

    abstract int index();

    abstract String text();

    abstract Tree.Kind kind();

    abstract boolean constant();

    static ImmutableList<Parameter> createListFromVarSymbols(List<Symbol.VarSymbol> varSymbols) {
        return (ImmutableList)Streams.mapWithIndex(varSymbols.stream(), (s, i) -> new AutoValue_Parameter(((Name)s.getSimpleName()).toString(), (Type)s.asType(), (int)i, ((Name)s.getSimpleName()).toString(), Tree.Kind.IDENTIFIER, false)).collect(ImmutableList.toImmutableList());
    }

    static ImmutableList<Parameter> createListFromExpressionTrees(List<? extends ExpressionTree> trees) {
        return (ImmutableList)Streams.mapWithIndex(trees.stream(), (t, i) -> new AutoValue_Parameter(Parameter.getArgumentName(t), Optional.ofNullable(ASTHelpers.getResultType((ExpressionTree)t)).orElse(Type.noType), (int)i, t.toString(), t.getKind(), ASTHelpers.constValue((Tree)t) != null)).collect(ImmutableList.toImmutableList());
    }

    static ImmutableList<Parameter> createListFromVariableTrees(List<? extends VariableTree> trees) {
        return Parameter.createListFromVarSymbols((List)trees.stream().map(ASTHelpers::getSymbol).collect(ImmutableList.toImmutableList()));
    }

    boolean isAssignableTo(Parameter target, VisitorState state) {
        if (state.getTypes().isSameType(this.type(), Type.noType) || state.getTypes().isSameType(target.type(), Type.noType)) {
            return false;
        }
        try {
            return state.getTypes().isAssignable(this.type(), target.type());
        }
        catch (Symbol.CompletionFailure e) {
            Check.instance(state.context).completionError((JCDiagnostic.DiagnosticPosition)((Object)state.getPath().getLeaf()), e);
            return false;
        }
    }

    boolean isNullLiteral() {
        return this.name().equals(NAME_NULL);
    }

    boolean isUnknownName() {
        return this.name().equals(NAME_NOT_PRESENT);
    }

    private static String getClassName(Symbol.ClassSymbol s) {
        if (s.isAnonymous()) {
            return ((Name)s.getSuperclass().tsym.getSimpleName()).toString();
        }
        return s.getSimpleName().toString();
    }

    @VisibleForTesting
    static String getArgumentName(ExpressionTree expressionTree) {
        switch (expressionTree.getKind()) {
            case MEMBER_SELECT: {
                return ((MemberSelectTree)expressionTree).getIdentifier().toString();
            }
            case NULL_LITERAL: {
                return NAME_NULL;
            }
            case IDENTIFIER: {
                IdentifierTree idTree = (IdentifierTree)expressionTree;
                if (idTree.getName().contentEquals("this")) {
                    Symbol sym = ASTHelpers.getSymbol((Tree)idTree);
                    return sym != null ? Parameter.getClassName(ASTHelpers.enclosingClass((Symbol)sym)) : NAME_NOT_PRESENT;
                }
                return idTree.getName().toString();
            }
            case METHOD_INVOCATION: {
                MethodInvocationTree methodInvocationTree = (MethodInvocationTree)expressionTree;
                Symbol.MethodSymbol methodSym = ASTHelpers.getSymbol((MethodInvocationTree)methodInvocationTree);
                String name = ((Name)methodSym.getSimpleName()).toString();
                ImmutableList terms = NamingConventions.splitToLowercaseTerms((String)name);
                String firstTerm = (String)Iterables.getFirst((Iterable)terms, null);
                if (METHODNAME_PREFIXES_TO_REMOVE.contains((Object)firstTerm)) {
                    if (terms.size() == 1) {
                        ExpressionTree receiver = ASTHelpers.getReceiver((ExpressionTree)methodInvocationTree);
                        if (receiver == null) {
                            return Parameter.getClassName(ASTHelpers.enclosingClass((Symbol)methodSym));
                        }
                        return Parameter.getArgumentName(receiver);
                    }
                    return name.substring(firstTerm.length());
                }
                return name;
            }
            case NEW_CLASS: {
                Symbol.MethodSymbol constructorSym = ASTHelpers.getSymbol((NewClassTree)((NewClassTree)expressionTree));
                return constructorSym.owner != null ? Parameter.getClassName((Symbol.ClassSymbol)constructorSym.owner) : NAME_NOT_PRESENT;
            }
        }
        return NAME_NOT_PRESENT;
    }
}

