/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.binder;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.turbine.binder.Resolve;
import com.google.turbine.binder.bound.EnumConstantValue;
import com.google.turbine.binder.bound.TurbineAnnotationValue;
import com.google.turbine.binder.bound.TurbineClassValue;
import com.google.turbine.binder.bound.TypeBoundClass;
import com.google.turbine.binder.env.CompoundEnv;
import com.google.turbine.binder.env.Env;
import com.google.turbine.binder.lookup.LookupKey;
import com.google.turbine.binder.lookup.LookupResult;
import com.google.turbine.binder.lookup.MemberImportIndex;
import com.google.turbine.binder.lookup.Scope;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.binder.sym.FieldSymbol;
import com.google.turbine.binder.sym.Symbol;
import com.google.turbine.diag.SourceFile;
import com.google.turbine.diag.TurbineDiagnostic;
import com.google.turbine.diag.TurbineError;
import com.google.turbine.diag.TurbineLog;
import com.google.turbine.model.Const;
import com.google.turbine.model.TurbineConstantTypeKind;
import com.google.turbine.model.TurbineTyKind;
import com.google.turbine.tree.Tree;
import com.google.turbine.tree.TurbineOperatorKind;
import com.google.turbine.type.AnnoInfo;
import com.google.turbine.type.Type;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Objects;
import org.jspecify.nullness.Nullable;

public strictfp class ConstEvaluator {
    private final @Nullable ClassSymbol origin;
    private final @Nullable ClassSymbol owner;
    private final MemberImportIndex memberImports;
    private final SourceFile source;
    private final Env<FieldSymbol, Const.Value> values;
    private final CompoundEnv<ClassSymbol, TypeBoundClass> env;
    private final Scope scope;
    private final TurbineLog.TurbineLogWithSource log;
    private static final int INT_SHIFT_MASK = 31;
    private static final int LONG_SHIFT_MASK = 63;

    public ConstEvaluator(@Nullable ClassSymbol origin, @Nullable ClassSymbol owner, MemberImportIndex memberImports, SourceFile source, Scope scope, Env<FieldSymbol, Const.Value> values, CompoundEnv<ClassSymbol, TypeBoundClass> env, TurbineLog.TurbineLogWithSource log) {
        this.origin = origin;
        this.owner = owner;
        this.memberImports = memberImports;
        this.source = source;
        this.values = values;
        this.env = env;
        this.scope = scope;
        this.log = log;
    }

    public @Nullable Const eval(Tree t) {
        switch (t.kind()) {
            case LITERAL: {
                Const.Value a = (Const.Value)((Tree.Literal)t).value();
                if (a == null) {
                    return null;
                }
                switch (a.constantTypeKind()) {
                    case CHAR: 
                    case INT: 
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: 
                    case BOOLEAN: 
                    case STRING: {
                        return a;
                    }
                }
                throw new AssertionError((Object)a.constantTypeKind());
            }
            case VOID_TY: {
                throw new AssertionError((Object)t.kind());
            }
            case CONST_VAR_NAME: {
                return this.evalConstVar((Tree.ConstVarName)t);
            }
            case CLASS_LITERAL: {
                return this.evalClassLiteral((Tree.ClassLiteral)t);
            }
            case BINARY: {
                return this.evalBinary((Tree.Binary)t);
            }
            case PAREN: {
                return this.eval(((Tree.Paren)t).expr());
            }
            case TYPE_CAST: {
                return this.evalCast((Tree.TypeCast)t);
            }
            case UNARY: {
                return this.evalUnary((Tree.Unary)t);
            }
            case CONDITIONAL: {
                return this.evalConditional((Tree.Conditional)t);
            }
            case ARRAY_INIT: {
                return this.evalArrayInit((Tree.ArrayInit)t);
            }
            case ANNO_EXPR: {
                return this.evalAnno(((Tree.AnnoExpr)t).value());
            }
        }
        throw this.error(t.position(), TurbineError.ErrorKind.EXPRESSION_ERROR, new Object[0]);
    }

    Const evalClassLiteral(Tree.ClassLiteral t) {
        return new TurbineClassValue(this.evalClassLiteralType(t.type()));
    }

    private Type evalClassLiteralType(Tree.Type type) {
        switch (type.kind()) {
            case PRIM_TY: {
                return Type.PrimTy.create(((Tree.PrimTy)type).tykind(), (ImmutableList<AnnoInfo>)ImmutableList.of());
            }
            case VOID_TY: {
                return Type.VOID;
            }
            case CLASS_TY: {
                return this.resolveClass((Tree.ClassTy)type);
            }
            case ARR_TY: {
                return Type.ArrayTy.create(this.evalClassLiteralType(((Tree.ArrTy)type).elem()), (ImmutableList<AnnoInfo>)ImmutableList.of());
            }
        }
        throw new AssertionError((Object)type.kind());
    }

    private Type resolveClass(Tree.ClassTy classTy) {
        ArrayDeque<Tree.Ident> flat = new ArrayDeque<Tree.Ident>();
        Tree.ClassTy curr = classTy;
        while (curr != null) {
            flat.addFirst(curr.name());
            curr = curr.base().orElse(null);
        }
        LookupResult result = this.scope.lookup(new LookupKey((ImmutableList<Tree.Ident>)ImmutableList.copyOf(flat)));
        if (result == null) {
            this.log.error(classTy.position(), TurbineError.ErrorKind.CANNOT_RESOLVE, flat.getFirst());
            return Type.ErrorTy.create(flat);
        }
        if (result.sym().symKind() != Symbol.Kind.CLASS) {
            throw this.error(classTy.position(), TurbineError.ErrorKind.UNEXPECTED_TYPE_PARAMETER, flat.getFirst());
        }
        ClassSymbol classSym = (ClassSymbol)result.sym();
        for (Tree.Ident bit : result.remaining()) {
            classSym = this.resolveNext(classTy.position(), classSym, bit);
        }
        return Type.ClassTy.asNonParametricClassTy(classSym);
    }

    private ClassSymbol resolveNext(int position, ClassSymbol sym, Tree.Ident bit) {
        ClassSymbol next = Resolve.resolve(this.env, this.origin, sym, bit);
        if (next == null) {
            throw this.error(position, TurbineError.ErrorKind.SYMBOL_NOT_FOUND, new ClassSymbol(sym.binaryName() + '$' + bit));
        }
        return next;
    }

    @Nullable Const evalConstVar(Tree.ConstVarName t) {
        TypeBoundClass.FieldInfo field = this.resolveField(t);
        if (field == null) {
            return null;
        }
        if ((field.access() & 0x4000) == 16384) {
            return new EnumConstantValue(field.sym());
        }
        if (field.value() != null) {
            return field.value();
        }
        return this.values.get(field.sym());
    }

    TypeBoundClass.FieldInfo resolveField(Tree.ConstVarName t) {
        Tree.Ident simpleName = (Tree.Ident)t.name().get(0);
        TypeBoundClass.FieldInfo field = this.lexicalField(this.env, this.owner, simpleName);
        if (field != null) {
            return field;
        }
        field = this.resolveQualifiedField(t);
        if (field != null) {
            return field;
        }
        ClassSymbol classSymbol = this.memberImports.singleMemberImport(simpleName.value());
        if (classSymbol != null && (field = Resolve.resolveField(this.env, this.origin, classSymbol, simpleName)) != null) {
            return field;
        }
        Iterator<ClassSymbol> it = this.memberImports.onDemandImports();
        while (it.hasNext()) {
            field = Resolve.resolveField(this.env, this.origin, it.next(), simpleName);
            if (field == null || (field.access() & 2) == 2) continue;
            return field;
        }
        throw this.error(t.position(), TurbineError.ErrorKind.CANNOT_RESOLVE, String.format("field %s", Iterables.getLast(t.name())));
    }

    private @Nullable TypeBoundClass.FieldInfo resolveQualifiedField(Tree.ConstVarName t) {
        if (t.name().size() <= 1) {
            return null;
        }
        LookupResult result = this.scope.lookup(new LookupKey(t.name()));
        if (result == null) {
            return null;
        }
        if (result.remaining().isEmpty()) {
            return null;
        }
        ClassSymbol sym = (ClassSymbol)result.sym();
        for (int i = 0; i < result.remaining().size() - 1; ++i) {
            if ((sym = Resolve.resolve(this.env, sym, sym, (Tree.Ident)result.remaining().get(i))) != null) continue;
            return null;
        }
        return Resolve.resolveField(this.env, this.origin, sym, (Tree.Ident)Iterables.getLast(result.remaining()));
    }

    private @Nullable TypeBoundClass.FieldInfo lexicalField(Env<ClassSymbol, TypeBoundClass> env, @Nullable ClassSymbol sym, Tree.Ident name) {
        while (sym != null) {
            TypeBoundClass info = env.getNonNull(sym);
            TypeBoundClass.FieldInfo field = Resolve.resolveField(env, this.origin, sym, name);
            if (field != null) {
                return field;
            }
            sym = info.owner();
        }
        return null;
    }

    private Const cast(int position, Type ty, Const value) {
        Preconditions.checkNotNull((Object)value);
        switch (ty.tyKind()) {
            case CLASS_TY: 
            case TY_VAR: {
                return value;
            }
            case PRIM_TY: {
                if (!value.kind().equals((Object)Const.Kind.PRIMITIVE)) {
                    throw this.error(position, TurbineError.ErrorKind.EXPRESSION_ERROR, new Object[0]);
                }
                return this.coerce(position, (Const.Value)value, ((Type.PrimTy)ty).primkind());
            }
        }
        throw new AssertionError((Object)ty.tyKind());
    }

    Const.Value coerce(int position, Const.Value value, TurbineConstantTypeKind kind) {
        switch (kind) {
            case BYTE: {
                return this.asByte(position, value);
            }
            case SHORT: {
                return this.asShort(position, value);
            }
            case INT: {
                return this.asInt(position, value);
            }
            case LONG: {
                return this.asLong(position, value);
            }
            case FLOAT: {
                return this.asFloat(position, value);
            }
            case DOUBLE: {
                return this.asDouble(position, value);
            }
            case CHAR: {
                return this.asChar(position, value);
            }
            case BOOLEAN: 
            case STRING: 
            case NULL: {
                if (!value.constantTypeKind().equals((Object)kind)) {
                    throw this.typeError(position, value, kind);
                }
                return value;
            }
        }
        throw new AssertionError((Object)kind);
    }

    private Const.BooleanValue asBoolean(int position, Const.Value value) {
        if (!value.constantTypeKind().equals((Object)TurbineConstantTypeKind.BOOLEAN)) {
            throw this.typeError(position, value, TurbineConstantTypeKind.BOOLEAN);
        }
        return (Const.BooleanValue)value;
    }

    private Const.StringValue asString(int position, Const.Value value) {
        if (!value.constantTypeKind().equals((Object)TurbineConstantTypeKind.STRING)) {
            throw this.typeError(position, value, TurbineConstantTypeKind.STRING);
        }
        return (Const.StringValue)value;
    }

    private Const.StringValue toString(int position, Const.Value value) {
        String result;
        switch (value.constantTypeKind()) {
            case CHAR: {
                result = String.valueOf(((Const.CharValue)value).value());
                break;
            }
            case SHORT: {
                result = String.valueOf(((Const.ShortValue)value).value());
                break;
            }
            case INT: {
                result = String.valueOf(((Const.IntValue)value).value());
                break;
            }
            case LONG: {
                result = String.valueOf(((Const.LongValue)value).value());
                break;
            }
            case FLOAT: {
                result = String.valueOf(((Const.FloatValue)value).value());
                break;
            }
            case DOUBLE: {
                result = String.valueOf(((Const.DoubleValue)value).value());
                break;
            }
            case BOOLEAN: {
                result = String.valueOf(((Const.BooleanValue)value).value());
                break;
            }
            case BYTE: {
                result = String.valueOf(((Const.ByteValue)value).value());
                break;
            }
            case STRING: {
                return (Const.StringValue)value;
            }
            default: {
                throw this.typeError(position, value, TurbineConstantTypeKind.STRING);
            }
        }
        return new Const.StringValue(result);
    }

    private Const.CharValue asChar(int position, Const.Value value) {
        char result;
        switch (value.constantTypeKind()) {
            case CHAR: {
                return (Const.CharValue)value;
            }
            case BYTE: {
                result = (char)((Const.ByteValue)value).value();
                break;
            }
            case SHORT: {
                result = (char)((Const.ShortValue)value).value();
                break;
            }
            case INT: {
                result = (char)((Const.IntValue)value).value();
                break;
            }
            case LONG: {
                result = (char)((Const.LongValue)value).value();
                break;
            }
            case FLOAT: {
                result = (char)((Const.FloatValue)value).value();
                break;
            }
            case DOUBLE: {
                result = (char)((Const.DoubleValue)value).value();
                break;
            }
            default: {
                throw this.typeError(position, value, TurbineConstantTypeKind.CHAR);
            }
        }
        return new Const.CharValue(result);
    }

    private Const.ByteValue asByte(int position, Const.Value value) {
        byte result;
        switch (value.constantTypeKind()) {
            case CHAR: {
                result = (byte)((Const.CharValue)value).value();
                break;
            }
            case BYTE: {
                return (Const.ByteValue)value;
            }
            case SHORT: {
                result = (byte)((Const.ShortValue)value).value();
                break;
            }
            case INT: {
                result = (byte)((Const.IntValue)value).value();
                break;
            }
            case LONG: {
                result = (byte)((Const.LongValue)value).value();
                break;
            }
            case FLOAT: {
                result = (byte)((Const.FloatValue)value).value();
                break;
            }
            case DOUBLE: {
                result = (byte)((Const.DoubleValue)value).value();
                break;
            }
            default: {
                throw this.typeError(position, value, TurbineConstantTypeKind.BYTE);
            }
        }
        return new Const.ByteValue(result);
    }

    private Const.ShortValue asShort(int position, Const.Value value) {
        short result;
        switch (value.constantTypeKind()) {
            case CHAR: {
                result = (short)((Const.CharValue)value).value();
                break;
            }
            case BYTE: {
                result = ((Const.ByteValue)value).value();
                break;
            }
            case SHORT: {
                return (Const.ShortValue)value;
            }
            case INT: {
                result = (short)((Const.IntValue)value).value();
                break;
            }
            case LONG: {
                result = (short)((Const.LongValue)value).value();
                break;
            }
            case FLOAT: {
                result = (short)((Const.FloatValue)value).value();
                break;
            }
            case DOUBLE: {
                result = (short)((Const.DoubleValue)value).value();
                break;
            }
            default: {
                throw this.typeError(position, value, TurbineConstantTypeKind.SHORT);
            }
        }
        return new Const.ShortValue(result);
    }

    private Const.IntValue asInt(int position, Const.Value value) {
        int result;
        switch (value.constantTypeKind()) {
            case CHAR: {
                result = ((Const.CharValue)value).value();
                break;
            }
            case BYTE: {
                result = ((Const.ByteValue)value).value();
                break;
            }
            case SHORT: {
                result = ((Const.ShortValue)value).value();
                break;
            }
            case INT: {
                return (Const.IntValue)value;
            }
            case LONG: {
                result = (int)((Const.LongValue)value).value();
                break;
            }
            case FLOAT: {
                result = (int)((Const.FloatValue)value).value();
                break;
            }
            case DOUBLE: {
                result = (int)((Const.DoubleValue)value).value();
                break;
            }
            default: {
                throw this.typeError(position, value, TurbineConstantTypeKind.INT);
            }
        }
        return new Const.IntValue(result);
    }

    private Const.LongValue asLong(int position, Const.Value value) {
        long result;
        switch (value.constantTypeKind()) {
            case CHAR: {
                result = ((Const.CharValue)value).value();
                break;
            }
            case BYTE: {
                result = ((Const.ByteValue)value).value();
                break;
            }
            case SHORT: {
                result = ((Const.ShortValue)value).value();
                break;
            }
            case INT: {
                result = ((Const.IntValue)value).value();
                break;
            }
            case LONG: {
                return (Const.LongValue)value;
            }
            case FLOAT: {
                result = (long)((Const.FloatValue)value).value();
                break;
            }
            case DOUBLE: {
                result = (long)((Const.DoubleValue)value).value();
                break;
            }
            default: {
                throw this.typeError(position, value, TurbineConstantTypeKind.LONG);
            }
        }
        return new Const.LongValue(result);
    }

    private Const.FloatValue asFloat(int position, Const.Value value) {
        float result;
        switch (value.constantTypeKind()) {
            case CHAR: {
                result = ((Const.CharValue)value).value();
                break;
            }
            case BYTE: {
                result = ((Const.ByteValue)value).value();
                break;
            }
            case SHORT: {
                result = ((Const.ShortValue)value).value();
                break;
            }
            case INT: {
                result = ((Const.IntValue)value).value();
                break;
            }
            case LONG: {
                result = ((Const.LongValue)value).value();
                break;
            }
            case FLOAT: {
                return (Const.FloatValue)value;
            }
            case DOUBLE: {
                result = (float)((Const.DoubleValue)value).value();
                break;
            }
            default: {
                throw this.typeError(position, value, TurbineConstantTypeKind.FLOAT);
            }
        }
        return new Const.FloatValue(result);
    }

    private Const.DoubleValue asDouble(int position, Const.Value value) {
        double result;
        switch (value.constantTypeKind()) {
            case CHAR: {
                result = ((Const.CharValue)value).value();
                break;
            }
            case BYTE: {
                result = ((Const.ByteValue)value).value();
                break;
            }
            case SHORT: {
                result = ((Const.ShortValue)value).value();
                break;
            }
            case INT: {
                result = ((Const.IntValue)value).value();
                break;
            }
            case LONG: {
                result = ((Const.LongValue)value).value();
                break;
            }
            case FLOAT: {
                result = ((Const.FloatValue)value).value();
                break;
            }
            case DOUBLE: {
                return (Const.DoubleValue)value;
            }
            default: {
                throw this.typeError(position, value, TurbineConstantTypeKind.DOUBLE);
            }
        }
        return new Const.DoubleValue(result);
    }

    private @Nullable Const.Value evalValue(Tree.Expression tree) {
        Const result = this.eval(tree);
        return result instanceof Const.Value ? (Const.Value)result : null;
    }

    private @Nullable Const.Value evalConditional(Tree.Conditional t) {
        Const.Value condition = this.evalValue(t.cond());
        if (condition == null) {
            return null;
        }
        return this.asBoolean(t.position(), condition).value() ? this.evalValue(t.iftrue()) : this.evalValue(t.iffalse());
    }

    private @Nullable Const.Value evalUnary(Tree.Unary t) {
        Const.Value expr = this.evalValue(t.expr());
        if (expr == null) {
            return null;
        }
        switch (t.op()) {
            case NOT: {
                return this.unaryNegate(t.position(), expr);
            }
            case BITWISE_COMP: {
                return this.bitwiseComp(t.position(), expr);
            }
            case UNARY_PLUS: {
                return this.unaryPlus(t.position(), expr);
            }
            case NEG: {
                return this.unaryMinus(t.position(), expr);
            }
        }
        throw new AssertionError((Object)t.op());
    }

    private @Nullable Const.Value unaryNegate(int position, Const.Value expr) {
        switch (expr.constantTypeKind()) {
            case BOOLEAN: {
                return new Const.BooleanValue(!this.asBoolean(position, expr).value());
            }
        }
        throw this.error(position, TurbineError.ErrorKind.OPERAND_TYPE, new Object[]{expr.constantTypeKind()});
    }

    private @Nullable Const.Value bitwiseComp(int position, Const.Value expr) {
        expr = this.promoteUnary(position, expr);
        switch (expr.constantTypeKind()) {
            case INT: {
                return new Const.IntValue(~this.asInt(position, expr).value());
            }
            case LONG: {
                return new Const.LongValue(this.asLong(position, expr).value() ^ 0xFFFFFFFFFFFFFFFFL);
            }
        }
        throw this.error(position, TurbineError.ErrorKind.OPERAND_TYPE, new Object[]{expr.constantTypeKind()});
    }

    private @Nullable Const.Value unaryPlus(int position, Const.Value expr) {
        expr = this.promoteUnary(position, expr);
        switch (expr.constantTypeKind()) {
            case INT: {
                return new Const.IntValue(this.asInt(position, expr).value());
            }
            case LONG: {
                return new Const.LongValue(this.asLong(position, expr).value());
            }
            case FLOAT: {
                return new Const.FloatValue(this.asFloat(position, expr).value());
            }
            case DOUBLE: {
                return new Const.DoubleValue(this.asDouble(position, expr).value());
            }
        }
        throw this.error(position, TurbineError.ErrorKind.OPERAND_TYPE, new Object[]{expr.constantTypeKind()});
    }

    private @Nullable Const.Value unaryMinus(int position, Const.Value expr) {
        expr = this.promoteUnary(position, expr);
        switch (expr.constantTypeKind()) {
            case INT: {
                return new Const.IntValue(-this.asInt(position, expr).value());
            }
            case LONG: {
                return new Const.LongValue(-this.asLong(position, expr).value());
            }
            case FLOAT: {
                return new Const.FloatValue(-this.asFloat(position, expr).value());
            }
            case DOUBLE: {
                return new Const.DoubleValue(-this.asDouble(position, expr).value());
            }
        }
        throw this.error(position, TurbineError.ErrorKind.OPERAND_TYPE, new Object[]{expr.constantTypeKind()});
    }

    private @Nullable Const.Value evalCast(Tree.TypeCast t) {
        Const.Value expr = this.evalValue(t.expr());
        if (expr == null) {
            return null;
        }
        switch (t.ty().kind()) {
            case PRIM_TY: {
                return this.coerce(t.expr().position(), expr, ((Tree.PrimTy)t.ty()).tykind());
            }
            case CLASS_TY: {
                Tree.ClassTy classTy = (Tree.ClassTy)t.ty();
                if (!classTy.name().value().equals("String")) {
                    return null;
                }
                return this.toString(t.expr().position(), expr);
            }
        }
        throw new AssertionError((Object)t.ty().kind());
    }

    private @Nullable Const.Value add(int position, Const.Value a, Const.Value b) {
        if (a.constantTypeKind() == TurbineConstantTypeKind.STRING || b.constantTypeKind() == TurbineConstantTypeKind.STRING) {
            return new Const.StringValue(this.toString(position, a).value() + this.toString(position, b).value());
        }
        TurbineConstantTypeKind type = this.promoteBinary(position, a, b);
        a = this.coerce(position, a, type);
        b = this.coerce(position, b, type);
        switch (type) {
            case INT: {
                return new Const.IntValue(this.asInt(position, a).value() + this.asInt(position, b).value());
            }
            case LONG: {
                return new Const.LongValue(this.asLong(position, a).value() + this.asLong(position, b).value());
            }
            case FLOAT: {
                return new Const.FloatValue(this.asFloat(position, a).value() + this.asFloat(position, b).value());
            }
            case DOUBLE: {
                return new Const.DoubleValue(this.asDouble(position, a).value() + this.asDouble(position, b).value());
            }
        }
        throw this.error(position, TurbineError.ErrorKind.OPERAND_TYPE, new Object[]{type});
    }

    private @Nullable Const.Value subtract(int position, Const.Value a, Const.Value b) {
        TurbineConstantTypeKind type = this.promoteBinary(position, a, b);
        a = this.coerce(position, a, type);
        b = this.coerce(position, b, type);
        switch (type) {
            case INT: {
                return new Const.IntValue(this.asInt(position, a).value() - this.asInt(position, b).value());
            }
            case LONG: {
                return new Const.LongValue(this.asLong(position, a).value() - this.asLong(position, b).value());
            }
            case FLOAT: {
                return new Const.FloatValue(this.asFloat(position, a).value() - this.asFloat(position, b).value());
            }
            case DOUBLE: {
                return new Const.DoubleValue(this.asDouble(position, a).value() - this.asDouble(position, b).value());
            }
        }
        throw this.error(position, TurbineError.ErrorKind.OPERAND_TYPE, new Object[]{type});
    }

    private @Nullable Const.Value mult(int position, Const.Value a, Const.Value b) {
        TurbineConstantTypeKind type = this.promoteBinary(position, a, b);
        a = this.coerce(position, a, type);
        b = this.coerce(position, b, type);
        switch (type) {
            case INT: {
                return new Const.IntValue(this.asInt(position, a).value() * this.asInt(position, b).value());
            }
            case LONG: {
                return new Const.LongValue(this.asLong(position, a).value() * this.asLong(position, b).value());
            }
            case FLOAT: {
                return new Const.FloatValue(this.asFloat(position, a).value() * this.asFloat(position, b).value());
            }
            case DOUBLE: {
                return new Const.DoubleValue(this.asDouble(position, a).value() * this.asDouble(position, b).value());
            }
        }
        throw this.error(position, TurbineError.ErrorKind.OPERAND_TYPE, new Object[]{type});
    }

    private @Nullable Const.Value divide(int position, Const.Value a, Const.Value b) {
        TurbineConstantTypeKind type = this.promoteBinary(position, a, b);
        a = this.coerce(position, a, type);
        b = this.coerce(position, b, type);
        switch (type) {
            case INT: {
                return new Const.IntValue(this.asInt(position, a).value() / this.asInt(position, b).value());
            }
            case LONG: {
                return new Const.LongValue(this.asLong(position, a).value() / this.asLong(position, b).value());
            }
            case FLOAT: {
                return new Const.FloatValue(this.asFloat(position, a).value() / this.asFloat(position, b).value());
            }
            case DOUBLE: {
                return new Const.DoubleValue(this.asDouble(position, a).value() / this.asDouble(position, b).value());
            }
        }
        throw this.error(position, TurbineError.ErrorKind.OPERAND_TYPE, new Object[]{type});
    }

    private @Nullable Const.Value mod(int position, Const.Value a, Const.Value b) {
        TurbineConstantTypeKind type = this.promoteBinary(position, a, b);
        a = this.coerce(position, a, type);
        b = this.coerce(position, b, type);
        switch (type) {
            case INT: {
                return new Const.IntValue(this.asInt(position, a).value() % this.asInt(position, b).value());
            }
            case LONG: {
                return new Const.LongValue(this.asLong(position, a).value() % this.asLong(position, b).value());
            }
            case FLOAT: {
                return new Const.FloatValue(this.asFloat(position, a).value() % this.asFloat(position, b).value());
            }
            case DOUBLE: {
                return new Const.DoubleValue(this.asDouble(position, a).value() % this.asDouble(position, b).value());
            }
        }
        throw this.error(position, TurbineError.ErrorKind.OPERAND_TYPE, new Object[]{type});
    }

    private @Nullable Const.Value shiftLeft(int position, Const.Value a, Const.Value b) {
        a = this.promoteUnary(position, a);
        b = this.promoteUnary(position, b);
        switch (a.constantTypeKind()) {
            case INT: {
                return new Const.IntValue(this.asInt(position, a).value() << (this.asInt(position, b).value() & 0x1F));
            }
            case LONG: {
                return new Const.LongValue(this.asLong(position, a).value() << (this.asInt(position, b).value() & 0x3F));
            }
        }
        throw this.error(position, TurbineError.ErrorKind.OPERAND_TYPE, new Object[]{a.constantTypeKind()});
    }

    private @Nullable Const.Value shiftRight(int position, Const.Value a, Const.Value b) {
        a = this.promoteUnary(position, a);
        b = this.promoteUnary(position, b);
        switch (a.constantTypeKind()) {
            case INT: {
                return new Const.IntValue(this.asInt(position, a).value() >> (this.asInt(position, b).value() & 0x1F));
            }
            case LONG: {
                return new Const.LongValue(this.asLong(position, a).value() >> (this.asInt(position, b).value() & 0x3F));
            }
        }
        throw this.error(position, TurbineError.ErrorKind.OPERAND_TYPE, new Object[]{a.constantTypeKind()});
    }

    private @Nullable Const.Value unsignedShiftRight(int position, Const.Value a, Const.Value b) {
        a = this.promoteUnary(position, a);
        b = this.promoteUnary(position, b);
        switch (a.constantTypeKind()) {
            case INT: {
                return new Const.IntValue(this.asInt(position, a).value() >>> (this.asInt(position, b).value() & 0x1F));
            }
            case LONG: {
                return new Const.LongValue(this.asLong(position, a).value() >>> (this.asInt(position, b).value() & 0x3F));
            }
        }
        throw this.error(position, TurbineError.ErrorKind.OPERAND_TYPE, new Object[]{a.constantTypeKind()});
    }

    private @Nullable Const.Value lessThan(int position, Const.Value a, Const.Value b) {
        TurbineConstantTypeKind type = this.promoteBinary(position, a, b);
        a = this.coerce(position, a, type);
        b = this.coerce(position, b, type);
        switch (type) {
            case INT: {
                return new Const.BooleanValue(this.asInt(position, a).value() < this.asInt(position, b).value());
            }
            case LONG: {
                return new Const.BooleanValue(this.asLong(position, a).value() < this.asLong(position, b).value());
            }
            case FLOAT: {
                return new Const.BooleanValue(this.asFloat(position, a).value() < this.asFloat(position, b).value());
            }
            case DOUBLE: {
                return new Const.BooleanValue(this.asDouble(position, a).value() < this.asDouble(position, b).value());
            }
        }
        throw this.error(position, TurbineError.ErrorKind.OPERAND_TYPE, new Object[]{type});
    }

    private @Nullable Const.Value lessThanEqual(int position, Const.Value a, Const.Value b) {
        TurbineConstantTypeKind type = this.promoteBinary(position, a, b);
        a = this.coerce(position, a, type);
        b = this.coerce(position, b, type);
        switch (type) {
            case INT: {
                return new Const.BooleanValue(this.asInt(position, a).value() <= this.asInt(position, b).value());
            }
            case LONG: {
                return new Const.BooleanValue(this.asLong(position, a).value() <= this.asLong(position, b).value());
            }
            case FLOAT: {
                return new Const.BooleanValue(this.asFloat(position, a).value() <= this.asFloat(position, b).value());
            }
            case DOUBLE: {
                return new Const.BooleanValue(this.asDouble(position, a).value() <= this.asDouble(position, b).value());
            }
        }
        throw this.error(position, TurbineError.ErrorKind.OPERAND_TYPE, new Object[]{type});
    }

    private @Nullable Const.Value greaterThan(int position, Const.Value a, Const.Value b) {
        TurbineConstantTypeKind type = this.promoteBinary(position, a, b);
        a = this.coerce(position, a, type);
        b = this.coerce(position, b, type);
        switch (type) {
            case INT: {
                return new Const.BooleanValue(this.asInt(position, a).value() > this.asInt(position, b).value());
            }
            case LONG: {
                return new Const.BooleanValue(this.asLong(position, a).value() > this.asLong(position, b).value());
            }
            case FLOAT: {
                return new Const.BooleanValue(this.asFloat(position, a).value() > this.asFloat(position, b).value());
            }
            case DOUBLE: {
                return new Const.BooleanValue(this.asDouble(position, a).value() > this.asDouble(position, b).value());
            }
        }
        throw this.error(position, TurbineError.ErrorKind.OPERAND_TYPE, new Object[]{type});
    }

    private @Nullable Const.Value greaterThanEqual(int position, Const.Value a, Const.Value b) {
        TurbineConstantTypeKind type = this.promoteBinary(position, a, b);
        a = this.coerce(position, a, type);
        b = this.coerce(position, b, type);
        switch (type) {
            case INT: {
                return new Const.BooleanValue(this.asInt(position, a).value() >= this.asInt(position, b).value());
            }
            case LONG: {
                return new Const.BooleanValue(this.asLong(position, a).value() >= this.asLong(position, b).value());
            }
            case FLOAT: {
                return new Const.BooleanValue(this.asFloat(position, a).value() >= this.asFloat(position, b).value());
            }
            case DOUBLE: {
                return new Const.BooleanValue(this.asDouble(position, a).value() >= this.asDouble(position, b).value());
            }
        }
        throw this.error(position, TurbineError.ErrorKind.OPERAND_TYPE, new Object[]{type});
    }

    private @Nullable Const.Value equal(int position, Const.Value a, Const.Value b) {
        switch (a.constantTypeKind()) {
            case STRING: {
                return new Const.BooleanValue(this.asString(position, a).value().equals(this.asString(position, b).value()));
            }
            case BOOLEAN: {
                return new Const.BooleanValue(this.asBoolean(position, a).value() == this.asBoolean(position, b).value());
            }
        }
        TurbineConstantTypeKind type = this.promoteBinary(position, a, b);
        a = this.coerce(position, a, type);
        b = this.coerce(position, b, type);
        switch (type) {
            case INT: {
                return new Const.BooleanValue(this.asInt(position, a).value() == this.asInt(position, b).value());
            }
            case LONG: {
                return new Const.BooleanValue(this.asLong(position, a).value() == this.asLong(position, b).value());
            }
            case FLOAT: {
                return new Const.BooleanValue(this.asFloat(position, a).value() == this.asFloat(position, b).value());
            }
            case DOUBLE: {
                return new Const.BooleanValue(this.asDouble(position, a).value() == this.asDouble(position, b).value());
            }
        }
        throw this.error(position, TurbineError.ErrorKind.OPERAND_TYPE, new Object[]{type});
    }

    private @Nullable Const.Value notEqual(int position, Const.Value a, Const.Value b) {
        switch (a.constantTypeKind()) {
            case STRING: {
                return new Const.BooleanValue(!this.asString(position, a).value().equals(this.asString(position, b).value()));
            }
            case BOOLEAN: {
                return new Const.BooleanValue(this.asBoolean(position, a).value() != this.asBoolean(position, b).value());
            }
        }
        TurbineConstantTypeKind type = this.promoteBinary(position, a, b);
        a = this.coerce(position, a, type);
        b = this.coerce(position, b, type);
        switch (type) {
            case INT: {
                return new Const.BooleanValue(this.asInt(position, a).value() != this.asInt(position, b).value());
            }
            case LONG: {
                return new Const.BooleanValue(this.asLong(position, a).value() != this.asLong(position, b).value());
            }
            case FLOAT: {
                return new Const.BooleanValue(this.asFloat(position, a).value() != this.asFloat(position, b).value());
            }
            case DOUBLE: {
                return new Const.BooleanValue(this.asDouble(position, a).value() != this.asDouble(position, b).value());
            }
        }
        throw this.error(position, TurbineError.ErrorKind.OPERAND_TYPE, new Object[]{type});
    }

    private Const.Value bitwiseAnd(int position, Const.Value a, Const.Value b) {
        switch (a.constantTypeKind()) {
            case BOOLEAN: {
                return new Const.BooleanValue(this.asBoolean(position, a).value() & this.asBoolean(position, b).value());
            }
        }
        TurbineConstantTypeKind type = this.promoteBinary(position, a, b);
        a = this.coerce(position, a, type);
        b = this.coerce(position, b, type);
        switch (type) {
            case INT: {
                return new Const.IntValue(this.asInt(position, a).value() & this.asInt(position, b).value());
            }
            case LONG: {
                return new Const.LongValue(this.asLong(position, a).value() & this.asLong(position, b).value());
            }
        }
        throw this.error(position, TurbineError.ErrorKind.OPERAND_TYPE, new Object[]{type});
    }

    private Const.Value bitwiseOr(int position, Const.Value a, Const.Value b) {
        switch (a.constantTypeKind()) {
            case BOOLEAN: {
                return new Const.BooleanValue(this.asBoolean(position, a).value() | this.asBoolean(position, b).value());
            }
        }
        TurbineConstantTypeKind type = this.promoteBinary(position, a, b);
        a = this.coerce(position, a, type);
        b = this.coerce(position, b, type);
        switch (type) {
            case INT: {
                return new Const.IntValue(this.asInt(position, a).value() | this.asInt(position, b).value());
            }
            case LONG: {
                return new Const.LongValue(this.asLong(position, a).value() | this.asLong(position, b).value());
            }
        }
        throw this.error(position, TurbineError.ErrorKind.OPERAND_TYPE, new Object[]{type});
    }

    private @Nullable Const.Value bitwiseXor(int position, Const.Value a, Const.Value b) {
        switch (a.constantTypeKind()) {
            case BOOLEAN: {
                return new Const.BooleanValue(this.asBoolean(position, a).value() ^ this.asBoolean(position, b).value());
            }
        }
        TurbineConstantTypeKind type = this.promoteBinary(position, a, b);
        a = this.coerce(position, a, type);
        b = this.coerce(position, b, type);
        switch (type) {
            case INT: {
                return new Const.IntValue(this.asInt(position, a).value() ^ this.asInt(position, b).value());
            }
            case LONG: {
                return new Const.LongValue(this.asLong(position, a).value() ^ this.asLong(position, b).value());
            }
        }
        throw this.error(position, TurbineError.ErrorKind.OPERAND_TYPE, new Object[]{type});
    }

    private @Nullable Const.Value evalBinary(Tree.Binary t) {
        Const.Value result = null;
        boolean first = true;
        for (Tree.Expression child : t.children()) {
            Const.Value value = this.evalValue(child);
            if (value == null) {
                return null;
            }
            result = first ? value : this.evalBinary(child.position(), t.op(), Objects.requireNonNull(result), value);
            first = false;
        }
        return result;
    }

    private @Nullable Const.Value evalBinary(int position, TurbineOperatorKind op, Const.Value lhs, Const.Value rhs) {
        switch (op) {
            case PLUS: {
                return this.add(position, lhs, rhs);
            }
            case MINUS: {
                return this.subtract(position, lhs, rhs);
            }
            case MULT: {
                return this.mult(position, lhs, rhs);
            }
            case DIVIDE: {
                return this.divide(position, lhs, rhs);
            }
            case MODULO: {
                return this.mod(position, lhs, rhs);
            }
            case SHIFT_LEFT: {
                return this.shiftLeft(position, lhs, rhs);
            }
            case SHIFT_RIGHT: {
                return this.shiftRight(position, lhs, rhs);
            }
            case UNSIGNED_SHIFT_RIGHT: {
                return this.unsignedShiftRight(position, lhs, rhs);
            }
            case LESS_THAN: {
                return this.lessThan(position, lhs, rhs);
            }
            case GREATER_THAN: {
                return this.greaterThan(position, lhs, rhs);
            }
            case LESS_THAN_EQ: {
                return this.lessThanEqual(position, lhs, rhs);
            }
            case GREATER_THAN_EQ: {
                return this.greaterThanEqual(position, lhs, rhs);
            }
            case EQUAL: {
                return this.equal(position, lhs, rhs);
            }
            case NOT_EQUAL: {
                return this.notEqual(position, lhs, rhs);
            }
            case AND: {
                return new Const.BooleanValue(this.asBoolean(position, lhs).value() && this.asBoolean(position, rhs).value());
            }
            case OR: {
                return new Const.BooleanValue(this.asBoolean(position, lhs).value() || this.asBoolean(position, rhs).value());
            }
            case BITWISE_AND: {
                return this.bitwiseAnd(position, lhs, rhs);
            }
            case BITWISE_XOR: {
                return this.bitwiseXor(position, lhs, rhs);
            }
            case BITWISE_OR: {
                return this.bitwiseOr(position, lhs, rhs);
            }
        }
        throw new AssertionError((Object)op);
    }

    private Const.Value promoteUnary(int position, Const.Value v) {
        switch (v.constantTypeKind()) {
            case CHAR: 
            case SHORT: 
            case BYTE: {
                return this.asInt(position, v);
            }
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                return v;
            }
        }
        throw this.error(position, TurbineError.ErrorKind.OPERAND_TYPE, new Object[]{v.constantTypeKind()});
    }

    private TurbineConstantTypeKind promoteBinary(int position, Const.Value a, Const.Value b) {
        a = this.promoteUnary(position, a);
        b = this.promoteUnary(position, b);
        switch (a.constantTypeKind()) {
            case INT: {
                switch (b.constantTypeKind()) {
                    case INT: 
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: {
                        return b.constantTypeKind();
                    }
                }
                throw this.error(position, TurbineError.ErrorKind.OPERAND_TYPE, new Object[]{b.constantTypeKind()});
            }
            case LONG: {
                switch (b.constantTypeKind()) {
                    case INT: {
                        return TurbineConstantTypeKind.LONG;
                    }
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: {
                        return b.constantTypeKind();
                    }
                }
                throw this.error(position, TurbineError.ErrorKind.OPERAND_TYPE, new Object[]{b.constantTypeKind()});
            }
            case FLOAT: {
                switch (b.constantTypeKind()) {
                    case INT: 
                    case LONG: 
                    case FLOAT: {
                        return TurbineConstantTypeKind.FLOAT;
                    }
                    case DOUBLE: {
                        return TurbineConstantTypeKind.DOUBLE;
                    }
                }
                throw this.error(position, TurbineError.ErrorKind.OPERAND_TYPE, new Object[]{b.constantTypeKind()});
            }
            case DOUBLE: {
                switch (b.constantTypeKind()) {
                    case INT: 
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: {
                        return TurbineConstantTypeKind.DOUBLE;
                    }
                }
                throw this.error(position, TurbineError.ErrorKind.OPERAND_TYPE, new Object[]{b.constantTypeKind()});
            }
        }
        throw this.error(position, TurbineError.ErrorKind.OPERAND_TYPE, new Object[]{a.constantTypeKind()});
    }

    ImmutableList<AnnoInfo> evaluateAnnotations(ImmutableList<AnnoInfo> annotations) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (AnnoInfo annotation : annotations) {
            result.add((Object)this.evaluateAnnotation(annotation));
        }
        return result.build();
    }

    AnnoInfo evaluateAnnotation(AnnoInfo info) {
        if (info.sym() == null) {
            return info;
        }
        TypeBoundClass annoClass = (TypeBoundClass)this.env.getNonNull(info.sym());
        if (annoClass.kind() != TurbineTyKind.ANNOTATION) {
            return info;
        }
        LinkedHashMap<String, TypeBoundClass.MethodInfo> template = new LinkedHashMap<String, TypeBoundClass.MethodInfo>();
        if (annoClass != null) {
            for (TypeBoundClass.MethodInfo method : annoClass.methods()) {
                template.put(method.name(), method);
            }
        }
        LinkedHashMap<String, Const> values = new LinkedHashMap<String, Const>();
        for (Tree.Expression arg : info.args()) {
            Tree.Expression expr;
            String key;
            if (arg.kind() == Tree.Kind.ASSIGN) {
                Tree.Assign assign = (Tree.Assign)arg;
                key = assign.name().value();
                expr = assign.expr();
            } else {
                if (info.args().size() != 1) {
                    throw this.error(arg.position(), TurbineError.ErrorKind.ANNOTATION_VALUE_NAME, new Object[0]);
                }
                key = "value";
                expr = arg;
            }
            TypeBoundClass.MethodInfo methodInfo = (TypeBoundClass.MethodInfo)template.remove(key);
            if (methodInfo == null) {
                this.log.error(arg.position(), TurbineError.ErrorKind.CANNOT_RESOLVE, String.format("element %s() in %s", key, info.sym()));
                continue;
            }
            Const value = this.evalAnnotationValue(expr, methodInfo.returnType());
            if (value == null) {
                this.log.error(expr.position(), TurbineError.ErrorKind.EXPRESSION_ERROR, new Object[0]);
                continue;
            }
            Const existing = values.put(key, value);
            if (existing == null) continue;
            this.log.error(arg.position(), TurbineError.ErrorKind.INVALID_ANNOTATION_ARGUMENT, new Object[0]);
        }
        for (TypeBoundClass.MethodInfo methodInfo : template.values()) {
            if (methodInfo.hasDefaultValue()) continue;
            throw this.error(info.tree().position(), TurbineError.ErrorKind.MISSING_ANNOTATION_ARGUMENT, methodInfo.name());
        }
        return info.withValues((ImmutableMap<String, Const>)ImmutableMap.copyOf(values));
    }

    private @Nullable TurbineAnnotationValue evalAnno(Tree.Anno t) {
        LookupResult result = this.scope.lookup(new LookupKey(t.name()));
        if (result == null) {
            this.log.error(((Tree.Ident)t.name().get(0)).position(), TurbineError.ErrorKind.CANNOT_RESOLVE, Joiner.on((String)".").join(t.name()));
            return null;
        }
        ClassSymbol sym = (ClassSymbol)result.sym();
        for (Tree.Ident name : result.remaining()) {
            if ((sym = Resolve.resolve(this.env, sym, sym, name)) != null) continue;
            throw this.error(name.position(), TurbineError.ErrorKind.CANNOT_RESOLVE, name.value());
        }
        if (sym == null) {
            return null;
        }
        if (((TypeBoundClass)this.env.getNonNull(sym)).kind() != TurbineTyKind.ANNOTATION) {
            this.log.error(t.position(), TurbineError.ErrorKind.NOT_AN_ANNOTATION, sym);
        }
        AnnoInfo annoInfo = this.evaluateAnnotation(new AnnoInfo(this.source, sym, t, (ImmutableMap<String, Const>)ImmutableMap.of()));
        return new TurbineAnnotationValue(annoInfo);
    }

    private @Nullable Const.ArrayInitValue evalArrayInit(Tree.ArrayInit t) {
        ImmutableList.Builder elements = ImmutableList.builder();
        for (Tree.Expression e : t.exprs()) {
            Const arg = this.eval(e);
            if (arg == null) {
                return null;
            }
            elements.add((Object)arg);
        }
        return new Const.ArrayInitValue((ImmutableList<Const>)elements.build());
    }

    @Nullable Const evalAnnotationValue(Tree tree, Type ty) {
        if (ty == null) {
            throw this.error(tree.position(), TurbineError.ErrorKind.EXPRESSION_ERROR, new Object[0]);
        }
        Const value = this.eval(tree);
        if (value == null) {
            this.log.error(tree.position(), TurbineError.ErrorKind.EXPRESSION_ERROR, new Object[0]);
            return null;
        }
        switch (ty.tyKind()) {
            case PRIM_TY: {
                if (!(value instanceof Const.Value)) {
                    throw this.error(tree.position(), TurbineError.ErrorKind.EXPRESSION_ERROR, new Object[0]);
                }
                return this.coerce(tree.position(), (Const.Value)value, ((Type.PrimTy)ty).primkind());
            }
            case CLASS_TY: 
            case TY_VAR: {
                return value;
            }
            case ARRAY_TY: {
                Type elementType = ((Type.ArrayTy)ty).elementType();
                ImmutableList<Const> elements = value.kind() == Const.Kind.ARRAY ? ((Const.ArrayInitValue)value).elements() : ImmutableList.of((Object)value);
                ImmutableList.Builder coerced = ImmutableList.builder();
                for (Const element : elements) {
                    coerced.add((Object)this.cast(tree.position(), elementType, element));
                }
                return new Const.ArrayInitValue((ImmutableList<Const>)coerced.build());
            }
        }
        throw new AssertionError((Object)ty.tyKind());
    }

    private TurbineError error(int position, TurbineError.ErrorKind kind, Object ... args) {
        return TurbineError.format(this.source, position, kind, args);
    }

    private TurbineError typeError(int position, Const.Value value, TurbineConstantTypeKind kind) {
        return this.error(position, TurbineError.ErrorKind.TYPE_CONVERSION, new Object[]{value, value.constantTypeKind(), kind});
    }

    public @Nullable Const.Value evalFieldInitializer(Tree.Expression expression, Type type) {
        try {
            Const value = this.eval(expression);
            if (value == null || value.kind() != Const.Kind.PRIMITIVE) {
                return null;
            }
            return (Const.Value)this.cast(expression.position(), type, value);
        }
        catch (TurbineError error) {
            for (TurbineDiagnostic diagnostic : error.diagnostics()) {
                switch (diagnostic.kind()) {
                    case CANNOT_RESOLVE: {
                        return null;
                    }
                }
            }
            throw error;
        }
        catch (Const.ConstCastError error) {
            return null;
        }
    }
}

