/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.BugPatternValidator;
import com.google.errorprone.ValidationException;
import com.google.errorprone.bugpatterns.BugChecker;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class BugCheckerInfo
implements Serializable {
    private final Class<? extends BugChecker> checker;
    private final String canonicalName;
    private final ImmutableSet<String> allNames;
    private final ImmutableSet<String> tags;
    private final String message;
    private final BugPattern.SeverityLevel defaultSeverity;
    private final String linkUrl;
    private final boolean supportsSuppressWarnings;
    private final Set<Class<? extends Annotation>> customSuppressionAnnotations;
    private final boolean disableable;

    public static BugCheckerInfo create(Class<? extends BugChecker> checker) {
        BugPattern pattern = (BugPattern)Preconditions.checkNotNull((Object)checker.getAnnotation(BugPattern.class), (Object)"BugCheckers must be annotated with @BugPattern");
        Preconditions.checkArgument((!Modifier.isAbstract(checker.getModifiers()) && !Modifier.isInterface(checker.getModifiers()) ? 1 : 0) != 0, (String)"%s must be a concrete class", checker);
        try {
            BugPatternValidator.validate((BugPattern)pattern);
        }
        catch (ValidationException e) {
            throw new IllegalStateException(e);
        }
        return new BugCheckerInfo(checker, pattern);
    }

    private BugCheckerInfo(Class<? extends BugChecker> checker, BugPattern pattern) {
        this(BugCheckerInfo.canonicalName(checker.getSimpleName(), pattern), checker, pattern);
    }

    private BugCheckerInfo(String canonicalName, Class<? extends BugChecker> checker, BugPattern pattern) {
        this(checker, canonicalName, (ImmutableSet<String>)ImmutableSet.builder().add((Object)canonicalName).add((Object[])pattern.altNames()).build(), pattern.summary(), pattern.severity(), BugCheckerInfo.createLinkUrl(canonicalName, pattern), Stream.of(pattern.suppressionAnnotations()).anyMatch(a -> BugCheckerInfo.isSuppressWarnings(a)), (Set)Stream.of(pattern.suppressionAnnotations()).filter(a -> !BugCheckerInfo.isSuppressWarnings(a)).collect(ImmutableSet.toImmutableSet()), (ImmutableSet<String>)ImmutableSet.copyOf((Object[])pattern.tags()), pattern.disableable());
    }

    private BugCheckerInfo(Class<? extends BugChecker> checker, String canonicalName, ImmutableSet<String> allNames, String message, BugPattern.SeverityLevel defaultSeverity, String linkUrl, boolean supportsSuppressWarnings, Set<Class<? extends Annotation>> customSuppressionAnnotations, ImmutableSet<String> tags, boolean disableable) {
        this.checker = checker;
        this.canonicalName = canonicalName;
        this.allNames = allNames;
        this.message = message;
        this.defaultSeverity = defaultSeverity;
        this.linkUrl = linkUrl;
        this.supportsSuppressWarnings = supportsSuppressWarnings;
        this.customSuppressionAnnotations = customSuppressionAnnotations;
        this.tags = tags;
        this.disableable = disableable;
    }

    private static boolean isSuppressWarnings(Class<? extends Annotation> annotation) {
        return annotation.getSimpleName().equals("SuppressWarnings");
    }

    public BugCheckerInfo withCustomDefaultSeverity(BugPattern.SeverityLevel defaultSeverity) {
        if (defaultSeverity == this.defaultSeverity) {
            return this;
        }
        return new BugCheckerInfo(this.checker, this.canonicalName, this.allNames, this.message, defaultSeverity, this.linkUrl, this.supportsSuppressWarnings, this.customSuppressionAnnotations, this.tags, this.disableable);
    }

    @Nullable
    private static String createLinkUrl(String canonicalName, BugPattern pattern) {
        switch (pattern.linkType()) {
            case AUTOGENERATED: {
                return String.format("https://errorprone.info/bugpattern/%s", canonicalName);
            }
            case CUSTOM: {
                if (pattern.link().isEmpty()) {
                    throw new IllegalStateException("If linkType element of @BugPattern is CUSTOM, a link element must also be provided.");
                }
                return pattern.link();
            }
            case NONE: {
                return null;
            }
        }
        throw new AssertionError((Object)("Unexpected value for linkType element of @BugPattern: " + pattern.linkType()));
    }

    public String canonicalName() {
        return this.canonicalName;
    }

    public static String canonicalName(String className, BugPattern pattern) {
        if (!pattern.name().isEmpty()) {
            return pattern.name();
        }
        return className;
    }

    public Set<String> allNames() {
        return this.allNames;
    }

    public String message() {
        return this.message;
    }

    public BugPattern.SeverityLevel defaultSeverity() {
        return this.defaultSeverity;
    }

    public BugPattern.SeverityLevel severity(Map<String, BugPattern.SeverityLevel> severities) {
        return (BugPattern.SeverityLevel)MoreObjects.firstNonNull((Object)severities.get(this.canonicalName), (Object)this.defaultSeverity);
    }

    public String linkUrl() {
        return this.linkUrl;
    }

    public boolean supportsSuppressWarnings() {
        return this.supportsSuppressWarnings;
    }

    public Set<Class<? extends Annotation>> customSuppressionAnnotations() {
        return Collections.unmodifiableSet(this.customSuppressionAnnotations);
    }

    public boolean disableable() {
        return this.disableable;
    }

    public ImmutableSet<String> getTags() {
        return this.tags;
    }

    public Class<? extends BugChecker> checkerClass() {
        return this.checker;
    }

    public int hashCode() {
        return this.checker.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof BugCheckerInfo)) {
            return false;
        }
        return this.checker.equals(((BugCheckerInfo)o).checker);
    }

    public String toString() {
        return this.canonicalName;
    }
}

