/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.util.List;

@BugPattern(summary="Java assert is used in testing code. For testing purposes, prefer using Truth-based assertions.", severity=BugPattern.SeverityLevel.ERROR)
public class UseCorrectAssertInTests
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final String STATIC_ASSERT_THAT_IMPORT = "static com.google.common.truth.Truth.assertThat";
    private static final String STATIC_ASSERT_WITH_MESSAGE_IMPORT = "static com.google.common.truth.Truth.assertWithMessage";
    private static final String IS_TRUE = "isTrue();";
    private static final String IS_FALSE = "isFalse();";
    private static final String IS_NULL = "isNull();";
    private static final String IS_NOT_NULL = "isNotNull();";
    private static final String IS_EQUAL_TO = "isEqualTo(%s);";
    private static final String IS_NOT_EQUAL_TO = "isNotEqualTo(%s);";
    private static final String IS_SAME_AS = "isSameInstanceAs(%s);";
    private static final String IS_NOT_SAME_AS = "isNotSameInstanceAs(%s);";

    public Description matchMethod(MethodTree methodTree, VisitorState state) {
        if (methodTree.getBody() == null) {
            return Description.NO_MATCH;
        }
        if (!ASTHelpers.isJUnitTestCode((VisitorState)state) && !state.errorProneOptions().isTestOnlyTarget()) {
            return Description.NO_MATCH;
        }
        ImmutableList<AssertTree> assertions = UseCorrectAssertInTests.scanAsserts(methodTree);
        if (assertions.isEmpty()) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder fix = SuggestedFix.builder();
        for (AssertTree foundAssert : assertions) {
            UseCorrectAssertInTests.replaceAssert(fix, foundAssert, state);
        }
        return this.describeMatch((Tree)assertions.get(0), (Fix)fix.build());
    }

    private static void replaceAssert(SuggestedFix.Builder fix, AssertTree foundAssert, VisitorState state) {
        ExpressionTree expr = foundAssert.getCondition();
        if ((expr = (ExpressionTree)((Object)TreeInfo.skipParens((JCTree)((Object)expr)))).getKind().equals((Object)Tree.Kind.LOGICAL_COMPLEMENT)) {
            UseCorrectAssertInTests.addFix(fix, ((JCTree.JCUnary)expr).getExpression(), foundAssert, state, IS_FALSE);
            return;
        }
        if (MethodMatchers.instanceMethod().anyClass().named("equals").matches((Tree)expr, state)) {
            JCTree.JCMethodInvocation equalsCall = (JCTree.JCMethodInvocation)expr;
            JCTree.JCExpression expr1 = ((JCTree.JCFieldAccess)((JCTree.JCMethodInvocation)expr).meth).selected;
            JCTree.JCExpression expr2 = (JCTree.JCExpression)((List)equalsCall.getArguments()).get(0);
            UseCorrectAssertInTests.addFix(fix, expr1, foundAssert, state, String.format(IS_EQUAL_TO, UseCorrectAssertInTests.normalizedSourceForExpression(expr2, state)));
            return;
        }
        if (expr.getKind().equals((Object)Tree.Kind.EQUAL_TO) || expr.getKind().equals((Object)Tree.Kind.NOT_EQUAL_TO)) {
            UseCorrectAssertInTests.suggestFixForEquality(fix, foundAssert, state, expr.getKind().equals((Object)Tree.Kind.EQUAL_TO));
            return;
        }
        UseCorrectAssertInTests.addFix(fix, (JCTree.JCExpression)expr, foundAssert, state, IS_TRUE);
    }

    private static void addFix(SuggestedFix.Builder fix, JCTree.JCExpression expr, AssertTree foundAssert, VisitorState state, String isMethod) {
        String assertToUse;
        if (foundAssert.getDetail() == null) {
            fix.addImport(STATIC_ASSERT_THAT_IMPORT);
            assertToUse = String.format("assertThat(%s).", UseCorrectAssertInTests.normalizedSourceForExpression(expr, state));
        } else {
            fix.addImport(STATIC_ASSERT_WITH_MESSAGE_IMPORT);
            assertToUse = String.format("assertWithMessage(%s).that(%s).", UseCorrectAssertInTests.convertToString(foundAssert.getDetail(), state), UseCorrectAssertInTests.normalizedSourceForExpression(expr, state));
        }
        fix.replace((Tree)foundAssert, assertToUse + isMethod);
    }

    private static void suggestFixForEquality(SuggestedFix.Builder fix, AssertTree foundAssert, VisitorState state, boolean isEqual) {
        BinaryTree equalityTree = (BinaryTree)((Object)TreeInfo.skipParens((JCTree)((Object)foundAssert.getCondition())));
        ExpressionTree expr1 = equalityTree.getLeftOperand();
        ExpressionTree expr2 = equalityTree.getRightOperand();
        if (expr1.getKind() == Tree.Kind.NULL_LITERAL) {
            UseCorrectAssertInTests.addFix(fix, (JCTree.JCExpression)expr2, foundAssert, state, isEqual ? IS_NULL : IS_NOT_NULL);
        } else if (expr2.getKind() == Tree.Kind.NULL_LITERAL) {
            UseCorrectAssertInTests.addFix(fix, (JCTree.JCExpression)expr1, foundAssert, state, isEqual ? IS_NULL : IS_NOT_NULL);
        } else if (ASTHelpers.getType((Tree)expr1).isPrimitive() || ASTHelpers.getType((Tree)expr2).isPrimitive()) {
            UseCorrectAssertInTests.addFix(fix, (JCTree.JCExpression)expr1, foundAssert, state, String.format(isEqual ? IS_EQUAL_TO : IS_NOT_EQUAL_TO, state.getSourceForNode((Tree)expr2)));
        } else {
            UseCorrectAssertInTests.addFix(fix, (JCTree.JCExpression)expr1, foundAssert, state, String.format(isEqual ? IS_SAME_AS : IS_NOT_SAME_AS, state.getSourceForNode((Tree)expr2)));
        }
    }

    private static String normalizedSourceForExpression(JCTree.JCExpression expression, VisitorState state) {
        return state.getSourceForNode((Tree)TreeInfo.skipParens(expression));
    }

    private static String convertToString(ExpressionTree detail, VisitorState state) {
        return state.getSourceForNode((Tree)detail) + (ASTHelpers.isSameType((Type)ASTHelpers.getType((Tree)detail), (Type)state.getSymtab().stringType, (VisitorState)state) ? "" : ".toString()");
    }

    private static ImmutableList<AssertTree> scanAsserts(Tree tree) {
        final ImmutableList.Builder assertTrees = ImmutableList.builder();
        tree.accept(new TreeScanner<Void, VisitorState>(){

            @Override
            public Void visitAssert(AssertTree assertTree, VisitorState visitorState) {
                assertTrees.add((Object)assertTree);
                return null;
            }
        }, null);
        return assertTrees.build();
    }
}

