/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;

@BugPattern(name="InsecureCryptoUsage", altNames={"InsecureCipherMode"}, summary="A standard cryptographic operation is used in a mode that is prone to vulnerabilities", severity=BugPattern.SeverityLevel.ERROR)
public class InsecureCipherMode
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final String MESSAGE_BASE = "Insecure usage of a crypto API: ";
    private static final Matcher<ExpressionTree> CIPHER_GETINSTANCE_MATCHER = MethodMatchers.staticMethod().onClass("javax.crypto.Cipher").named("getInstance");
    private static final Matcher<ExpressionTree> KEY_STRUCTURE_GETINSTANCE_MATCHER = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.staticMethod().onClass("java.security.KeyPairGenerator").named("getInstance"), MethodMatchers.staticMethod().onClass("java.security.KeyFactory").named("getInstance"), MethodMatchers.staticMethod().onClass("javax.crypto.KeyAgreement").named("getInstance")});

    private Description buildErrorMessage(MethodInvocationTree tree, String explanation) {
        Description.Builder description = this.buildDescription(tree);
        String message = MESSAGE_BASE + explanation + ".";
        description.setMessage(message);
        return description.build();
    }

    private Description identifyEcbVulnerability(MethodInvocationTree tree) {
        Object argument = ASTHelpers.constValue((Tree)tree.getArguments().get(0));
        if (argument == null) {
            return this.buildErrorMessage(tree, "the transformation is not a compile-time constant expression");
        }
        String transformation = (String)argument;
        if (transformation.matches("ARCFOUR.*") || transformation.matches("ARC4.*") || transformation.matches("RC4.*")) {
            return Description.NO_MATCH;
        }
        if (!transformation.matches(".*/.*/.*")) {
            return this.buildErrorMessage(tree, "the mode and padding must be explicitly specified");
        }
        if (transformation.matches(".*/ECB/.*") && !transformation.matches("RSA/.*") && !transformation.matches("AESWrap/.*")) {
            return this.buildErrorMessage(tree, "ECB mode must not be used");
        }
        if (transformation.matches("ECIES.*") || transformation.matches("DHIES.*")) {
            return this.buildErrorMessage(tree, "IES-based algorithms use ECB mode and are insecure");
        }
        return Description.NO_MATCH;
    }

    private Description identifyDiffieHellmanAndDsaVulnerabilities(MethodInvocationTree tree) {
        Object argument = ASTHelpers.constValue((Tree)tree.getArguments().get(0));
        if (argument == null) {
            return this.buildErrorMessage(tree, "the algorithm specification is not a compile-time constant expression");
        }
        String algorithm = (String)argument;
        if (algorithm.matches("DH")) {
            return this.buildErrorMessage(tree, "using Diffie-Hellman on prime fields is insecure");
        }
        if (algorithm.matches("DSA")) {
            return this.buildErrorMessage(tree, "using DSA is insecure");
        }
        return Description.NO_MATCH;
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        Description description = this.checkInvocation(tree, state);
        return description;
    }

    Description checkInvocation(MethodInvocationTree tree, VisitorState state) {
        if (CIPHER_GETINSTANCE_MATCHER.matches((Tree)tree, state)) {
            return this.identifyEcbVulnerability(tree);
        }
        if (KEY_STRUCTURE_GETINSTANCE_MATCHER.matches((Tree)tree, state)) {
            return this.identifyDiffieHellmanAndDsaVulnerabilities(tree);
        }
        return Description.NO_MATCH;
    }
}

