/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;

@BugPattern(severity=BugPattern.SeverityLevel.WARNING, summary="BugChecker constructors should be marked @Inject.")
public final class InjectOnBugCheckers
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    public Description matchMethod(MethodTree tree, VisitorState state) {
        Symbol.MethodSymbol symbol = ASTHelpers.getSymbol((MethodTree)tree);
        if (!symbol.isConstructor()) {
            return Description.NO_MATCH;
        }
        if (ASTHelpers.isGeneratedConstructor((MethodTree)tree)) {
            return Description.NO_MATCH;
        }
        if (ASTHelpers.hasDirectAnnotationWithSimpleName((Tree)tree, (String)"Inject")) {
            return Description.NO_MATCH;
        }
        if (!ASTHelpers.isSubtype((Type)symbol.owner.type, (Type)state.getTypeFromString(BugChecker.class.getCanonicalName()), (VisitorState)state) || !ASTHelpers.hasAnnotation((Symbol)symbol.owner, BugPattern.class, (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        if (tree.getParameters().isEmpty() || !tree.getParameters().stream().allMatch(p -> ASTHelpers.isSubtype((Type)ASTHelpers.getType((Tree)p), (Type)state.getTypeFromString(ErrorProneFlags.class.getCanonicalName()), (VisitorState)state))) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder fix = SuggestedFix.builder();
        return this.describeMatch(tree, (Fix)fix.prefixWith((Tree)tree, "@" + SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (String)"javax.inject.Inject") + " ").build());
    }
}

