/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.binder;

import com.google.turbine.binder.bound.BoundClass;
import com.google.turbine.binder.bound.HeaderBoundClass;
import com.google.turbine.binder.bound.TypeBoundClass;
import com.google.turbine.binder.env.CompoundEnv;
import com.google.turbine.binder.env.Env;
import com.google.turbine.binder.env.LazyEnv;
import com.google.turbine.binder.lookup.CanonicalSymbolResolver;
import com.google.turbine.binder.lookup.ImportScope;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.model.TurbineVisibility;
import com.google.turbine.tree.Tree;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.jspecify.nullness.Nullable;

public final class Resolve {
    public static @Nullable ClassSymbol resolve(Env<ClassSymbol, ? extends HeaderBoundClass> env, @Nullable ClassSymbol origin, ClassSymbol sym, Tree.Ident simpleName) {
        return Resolve.resolve(env, origin, sym, simpleName, new HashSet<ClassSymbol>());
    }

    private static @Nullable ClassSymbol resolve(Env<ClassSymbol, ? extends HeaderBoundClass> env, @Nullable ClassSymbol origin, ClassSymbol sym, Tree.Ident simpleName, Set<ClassSymbol> seen) {
        if (!seen.add(sym)) {
            return null;
        }
        HeaderBoundClass bound = env.get(sym);
        if (bound == null) {
            return null;
        }
        ClassSymbol result = (ClassSymbol)bound.children().get((Object)simpleName.value());
        if (result != null) {
            return result;
        }
        if (bound.superclass() != null && (result = Resolve.resolve(env, origin, bound.superclass(), simpleName, seen)) != null && Resolve.visible(origin, result, env.getNonNull(result))) {
            return result;
        }
        for (ClassSymbol i : bound.interfaces()) {
            result = Resolve.resolve(env, origin, i, simpleName, seen);
            if (result == null || !Resolve.visible(origin, result, env.getNonNull(result))) continue;
            return result;
        }
        return null;
    }

    public static ImportScope.ResolveFunction resolveFunction(final Env<ClassSymbol, ? extends HeaderBoundClass> env, final @Nullable ClassSymbol origin) {
        return new ImportScope.ResolveFunction(){

            @Override
            public @Nullable ClassSymbol resolveOne(ClassSymbol base, Tree.Ident name) {
                try {
                    return Resolve.resolve(env, origin, base, name);
                }
                catch (LazyEnv.LazyBindingError e) {
                    return null;
                }
            }
        };
    }

    public static @Nullable TypeBoundClass.FieldInfo resolveField(Env<ClassSymbol, TypeBoundClass> env, @Nullable ClassSymbol origin, ClassSymbol sym, Tree.Ident name) {
        return Resolve.resolveField(env, origin, sym, name, new HashSet<ClassSymbol>());
    }

    private static @Nullable TypeBoundClass.FieldInfo resolveField(Env<ClassSymbol, TypeBoundClass> env, @Nullable ClassSymbol origin, ClassSymbol sym, Tree.Ident name, Set<ClassSymbol> seen) {
        TypeBoundClass.FieldInfo field;
        if (!seen.add(sym)) {
            return null;
        }
        TypeBoundClass info = env.get(sym);
        if (info == null) {
            return null;
        }
        for (TypeBoundClass.FieldInfo f : info.fields()) {
            if (!f.name().equals(name.value())) continue;
            return f;
        }
        if (info.superclass() != null && (field = Resolve.resolveField(env, origin, info.superclass(), name, seen)) != null && Resolve.visible(origin, field)) {
            return field;
        }
        for (ClassSymbol i : info.interfaces()) {
            TypeBoundClass.FieldInfo field2 = Resolve.resolveField(env, origin, i, name, seen);
            if (field2 == null || !Resolve.visible(origin, field2)) continue;
            return field2;
        }
        return null;
    }

    private static boolean visible(@Nullable ClassSymbol origin, TypeBoundClass.FieldInfo info) {
        return Resolve.visible(origin, info.sym().owner(), info.access());
    }

    private static boolean visible(@Nullable ClassSymbol origin, ClassSymbol sym, HeaderBoundClass info) {
        return Resolve.visible(origin, sym, info.access());
    }

    private static boolean visible(@Nullable ClassSymbol origin, ClassSymbol owner, int access) {
        TurbineVisibility visibility = TurbineVisibility.fromAccess(access);
        switch (visibility) {
            case PUBLIC: 
            case PROTECTED: {
                return true;
            }
            case PACKAGE: {
                return origin != null && Objects.equals(owner.packageName(), origin.packageName());
            }
            case PRIVATE: {
                return owner.equals(origin);
            }
        }
        throw new AssertionError((Object)visibility);
    }

    private Resolve() {
    }

    static class CanonicalResolver
    implements CanonicalSymbolResolver {
        private final String packagename;
        private final CompoundEnv<ClassSymbol, BoundClass> env;

        public CanonicalResolver(String packagename, CompoundEnv<ClassSymbol, BoundClass> env) {
            this.packagename = packagename;
            this.env = env;
        }

        @Override
        public @Nullable ClassSymbol resolveOne(ClassSymbol sym, Tree.Ident bit) {
            BoundClass ci = this.env.get(sym);
            if (ci == null) {
                return null;
            }
            ClassSymbol result = (ClassSymbol)ci.children().get((Object)bit.value());
            if (result == null) {
                return null;
            }
            if (!this.visible(result)) {
                return null;
            }
            return result;
        }

        @Override
        public boolean visible(ClassSymbol sym) {
            TurbineVisibility visibility = TurbineVisibility.fromAccess(((BoundClass)this.env.getNonNull(sym)).access());
            switch (visibility) {
                case PUBLIC: {
                    return true;
                }
                case PROTECTED: 
                case PACKAGE: {
                    return Objects.equals(sym.packageName(), this.packagename);
                }
                case PRIVATE: {
                    return false;
                }
            }
            throw new AssertionError((Object)visibility);
        }
    }
}

