/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone;

import com.google.common.base.Ascii;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public final class ErrorProneFlags
implements Serializable {
    public static final String PREFIX = "-XepOpt:";
    private final ImmutableMap<String, String> flagsMap;

    public static ErrorProneFlags empty() {
        return new ErrorProneFlags((ImmutableMap<String, String>)ImmutableMap.of());
    }

    public static ErrorProneFlags fromMap(Map<String, String> flagsMap) {
        return new ErrorProneFlags((ImmutableMap<String, String>)ImmutableMap.copyOf(flagsMap));
    }

    private ErrorProneFlags(ImmutableMap<String, String> flagsMap) {
        this.flagsMap = flagsMap;
    }

    public ImmutableMap<String, String> getFlagsMap() {
        return ImmutableMap.copyOf(this.flagsMap);
    }

    public Optional<String> get(String key) {
        return Optional.ofNullable((String)this.flagsMap.get((Object)key));
    }

    public Optional<Boolean> getBoolean(String key) {
        return this.get(key).map(ErrorProneFlags::parseBoolean);
    }

    public <T extends Enum<T>> Optional<T> getEnum(String key, Class<T> clazz) {
        return this.get(key).map(value -> ErrorProneFlags.asEnumValue(key, value, clazz));
    }

    public <T extends Enum<T>> Optional<ImmutableSet<T>> getEnumSet(String key, Class<T> clazz) {
        return this.get(key).map(value -> (ImmutableSet)Streams.stream((Iterable)Splitter.on((char)',').omitEmptyStrings().split((CharSequence)value)).map(v -> ErrorProneFlags.asEnumValue(key, v, clazz)).collect(ImmutableSet.toImmutableSet()));
    }

    private static <T extends Enum<T>> T asEnumValue(String key, String value, Class<T> clazz) {
        return (T)Arrays.stream((Enum[])clazz.getEnumConstants()).filter(c -> Ascii.equalsIgnoreCase((CharSequence)c.name(), (CharSequence)value)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Error Prone flag %s=%s could not be parsed as an enum constant of %s", key, value, clazz)));
    }

    private static boolean parseBoolean(String value) {
        if ("true".equalsIgnoreCase(value)) {
            return true;
        }
        if ("false".equalsIgnoreCase(value)) {
            return false;
        }
        throw new IllegalArgumentException(String.format("Error Prone flag value %s could not be parsed as a boolean.", value));
    }

    public Optional<Integer> getInteger(String key) {
        return this.get(key).map(Integer::valueOf);
    }

    @Deprecated
    public Optional<List<String>> getList(String key) {
        return this.get(key).map(v -> ImmutableList.copyOf((Iterable)Splitter.on((char)',').split((CharSequence)v)));
    }

    public ImmutableList<String> getListOrEmpty(String key) {
        return this.getList(key).map(ImmutableList::copyOf).orElse(ImmutableList.of());
    }

    @Deprecated
    public Optional<Set<String>> getSet(String key) {
        return this.get(key).map(v -> ImmutableSet.copyOf((Iterable)Splitter.on((char)',').split((CharSequence)v)));
    }

    public ImmutableSet<String> getSetOrEmpty(String key) {
        return this.getSet(key).map(ImmutableSet::copyOf).orElse(ImmutableSet.of());
    }

    public boolean isEmpty() {
        return this.flagsMap.isEmpty();
    }

    @CheckReturnValue
    public ErrorProneFlags plus(ErrorProneFlags other) {
        HashMap<String, String> combinedMaps = new HashMap<String, String>((Map<String, String>)this.getFlagsMap());
        combinedMaps.putAll((Map<String, String>)other.getFlagsMap());
        return ErrorProneFlags.fromMap(combinedMaps);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final HashMap<String, String> flagsMap = new HashMap();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public Builder parseFlag(String flag) {
            Preconditions.checkArgument((boolean)flag.startsWith(ErrorProneFlags.PREFIX));
            String remaining = flag.substring(ErrorProneFlags.PREFIX.length());
            String[] parts = remaining.split("=", 2);
            String key = parts[0];
            String value = parts.length < 2 ? "true" : parts[1];
            this.putFlag(key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder putFlag(String key, String value) {
            this.flagsMap.put(key, value);
            return this;
        }

        public ErrorProneFlags build() {
            return ErrorProneFlags.fromMap(this.flagsMap);
        }
    }
}

