/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.errorprone.org.plumelib.util;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.errorprone.checker.calledmethods.qual.CalledMethods;
import org.checkerframework.errorprone.checker.calledmethods.qual.CalledMethodsBottom;
import org.checkerframework.errorprone.checker.formatter.qual.FormatBottom;
import org.checkerframework.errorprone.checker.formatter.qual.UnknownFormat;
import org.checkerframework.errorprone.checker.index.qual.IndexOrHigh;
import org.checkerframework.errorprone.checker.index.qual.LTEqLengthOf;
import org.checkerframework.errorprone.checker.index.qual.LessThanBottom;
import org.checkerframework.errorprone.checker.index.qual.LessThanUnknown;
import org.checkerframework.errorprone.checker.index.qual.LowerBoundBottom;
import org.checkerframework.errorprone.checker.index.qual.LowerBoundUnknown;
import org.checkerframework.errorprone.checker.index.qual.NonNegative;
import org.checkerframework.errorprone.checker.index.qual.Positive;
import org.checkerframework.errorprone.checker.index.qual.SameLen;
import org.checkerframework.errorprone.checker.index.qual.SameLenBottom;
import org.checkerframework.errorprone.checker.index.qual.SameLenUnknown;
import org.checkerframework.errorprone.checker.index.qual.SearchIndexBottom;
import org.checkerframework.errorprone.checker.index.qual.SearchIndexUnknown;
import org.checkerframework.errorprone.checker.index.qual.SubstringIndexBottom;
import org.checkerframework.errorprone.checker.index.qual.SubstringIndexUnknown;
import org.checkerframework.errorprone.checker.index.qual.UpperBoundBottom;
import org.checkerframework.errorprone.checker.index.qual.UpperBoundUnknown;
import org.checkerframework.errorprone.checker.initialization.qual.Initialized;
import org.checkerframework.errorprone.checker.interning.qual.Interned;
import org.checkerframework.errorprone.checker.interning.qual.InternedDistinct;
import org.checkerframework.errorprone.checker.interning.qual.UnknownInterned;
import org.checkerframework.errorprone.checker.lock.qual.GuardSatisfied;
import org.checkerframework.errorprone.checker.lock.qual.GuardedBy;
import org.checkerframework.errorprone.checker.lock.qual.GuardedByBottom;
import org.checkerframework.errorprone.checker.lock.qual.LockPossiblyHeld;
import org.checkerframework.errorprone.checker.mustcall.qual.MustCall;
import org.checkerframework.errorprone.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.errorprone.checker.nullness.qual.NonNull;
import org.checkerframework.errorprone.checker.nullness.qual.Nullable;
import org.checkerframework.errorprone.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.errorprone.checker.regex.qual.RegexBottom;
import org.checkerframework.errorprone.checker.regex.qual.UnknownRegex;
import org.checkerframework.errorprone.checker.signature.qual.SignatureBottom;
import org.checkerframework.errorprone.checker.signature.qual.SignatureUnknown;
import org.checkerframework.errorprone.checker.signedness.qual.Signed;
import org.checkerframework.errorprone.checker.signedness.qual.SignednessBottom;
import org.checkerframework.errorprone.common.returnsreceiver.qual.UnknownThis;
import org.checkerframework.errorprone.common.value.qual.ArrayLenRange;
import org.checkerframework.errorprone.common.value.qual.BottomVal;
import org.checkerframework.errorprone.common.value.qual.MinLen;
import org.checkerframework.errorprone.common.value.qual.UnknownVal;
import org.checkerframework.errorprone.org.plumelib.util.ArraysPlume;

public class LimitedSizeSet<@FormatBottom T>
implements Serializable,
Cloneable {
    static final @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed long serialVersionUID = 20031021L;
    protected @Nullable T @Nullable @MinLen(value=1) @UnknownFormat @SubstringIndexUnknown @ArrayLenRange(from=1, to=0x7FFFFFFF) @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed [] values;
    protected @IndexOrHigh(value={"values"}) @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @NonNegative @LTEqLengthOf(value={"this.values"}) @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed int numValues;
    private static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed boolean assertsEnabled = false;

    public LimitedSizeSet(@Positive @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed int maxValues) {
        if (assertsEnabled && maxValues <= 0) {
            throw new IllegalArgumentException("maxValues should be positive, is " + maxValues);
        }
        @Nullable Object @MinLen(value=1) [] newValuesArray = new Object[maxValues];
        this.values = newValuesArray;
        this.numValues = 0;
    }

    public void add(T elt) {
        if (this.repNulled()) {
            return;
        }
        if (this.contains(elt)) {
            return;
        }
        if (this.numValues == this.values.length) {
            this.nullRep();
            return;
        }
        this.values[this.numValues] = elt;
        ++this.numValues;
    }

    public void addAll(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed LimitedSizeSet<@FormatBottom @SubstringIndexBottom @BottomVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom @InternedDistinct @LockPossiblyHeld @GuardedByBottom @UnknownKeyFor @NonNull @Initialized @RegexBottom @UnknownThis @MustCall(value={}) @CalledMethodsBottom @SignatureBottom @SignednessBottom ? extends T> s2) {
        boolean sameObject;
        boolean bl = sameObject = this == s2;
        if (sameObject) {
            return;
        }
        if (this.repNulled()) {
            return;
        }
        if (s2.repNulled()) {
            if (s2.size() > this.values.length) {
                this.nullRep();
                return;
            }
            throw new Error("Arg is rep-nulled, so we don't know its values and can't add them to this.");
        }
        @Nullable T @SameLen(value={"s.values"}) [] svalues = s2.values;
        for (int i = 0; i < s2.size(); ++i) {
            assert (svalues[i] != null) : "@AssumeAssertion(nullness): used portion of array";
            this.add(svalues[i]);
            if (!this.repNulled()) continue;
            return;
        }
    }

    @Pure
    public @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed boolean contains(T elt) {
        if (this.repNulled()) {
            throw new UnsupportedOperationException();
        }
        for (int i = 0; i < this.numValues; ++i) {
            if (!Objects.equals(this.values[i], elt)) continue;
            return true;
        }
        return false;
    }

    @Pure
    public @IndexOrHigh(value={"this.values"}) @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @NonNegative @LTEqLengthOf(value={"this.values"}) @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed int size(@GuardSatisfied LimitedSizeSet<T> this) {
        return this.numValues;
    }

    public @Positive @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed int maxSize() {
        if (this.repNulled()) {
            return this.numValues;
        }
        return this.values.length + 1;
    }

    @EnsuresNonNullIf(result=false, expression={"values"})
    @Pure
    public @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed boolean repNulled(@GuardSatisfied LimitedSizeSet<T> this) {
        return this.values == null;
    }

    private void nullRep() {
        if (this.repNulled()) {
            return;
        }
        this.numValues = this.values.length + 1;
        this.values = null;
    }

    @SideEffectFree
    public @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed LimitedSizeSet<T> clone(@GuardSatisfied LimitedSizeSet<T> this) {
        LimitedSizeSet result;
        try {
            LimitedSizeSet resultAsLss;
            result = resultAsLss = (LimitedSizeSet)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error();
        }
        if (this.values != null) {
            result.values = (Object[])this.values.clone();
        }
        return result;
    }

    public static <T> @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed LimitedSizeSet<T> merge(@Positive @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed int maxValues, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed List<@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed LimitedSizeSet<@FormatBottom @SubstringIndexBottom @BottomVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom @InternedDistinct @LockPossiblyHeld @GuardedByBottom @UnknownKeyFor @NonNull @Initialized @RegexBottom @UnknownThis @MustCall(value={}) @CalledMethodsBottom @SignatureBottom @SignednessBottom ? extends T>> slist) {
        LimitedSizeSet<T> result = new LimitedSizeSet<T>(maxValues);
        for (LimitedSizeSet<T> limitedSizeSet : slist) {
            result.addAll(limitedSizeSet);
        }
        return result;
    }

    @SideEffectFree
    public @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed String toString(@GuardSatisfied LimitedSizeSet<T> this) {
        return "[size=" + this.size() + "; " + (this.repNulled() ? "null" : ArraysPlume.toString(this.values)) + "]";
    }

    static {
        if (!$assertionsDisabled) {
            assertsEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
    }
}

