/*
 * Decompiled with CFR 0.152.
 */
package groovy.util;

import groovy.util.NodePrinter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.runtime.InvokerHelper;

public class Node {
    private Node parent;
    private Object name;
    private Map attributes;
    private Object value;

    public Node(Node parent, Object name) {
        this(parent, name, Collections.EMPTY_MAP, Collections.EMPTY_LIST);
    }

    public Node(Node parent, Object name, Object value) {
        this(parent, name, Collections.EMPTY_MAP, value);
    }

    public Node(Node parent, Object name, Map attributes) {
        this(parent, name, attributes, Collections.EMPTY_LIST);
    }

    public Node(Node parent, Object name, Map attributes, Object value) {
        this.parent = parent;
        this.name = name;
        this.attributes = attributes;
        this.value = value;
        if (parent != null) {
            Object parentValue = parent.value();
            ArrayList<Object> parentList = null;
            if (parentValue instanceof List) {
                parentList = (ArrayList<Object>)parentValue;
            } else {
                parentList = new ArrayList<Object>();
                parentList.add(parentValue);
                parent.setValue(parentList);
            }
            parentList.add(this);
        }
    }

    public String text() {
        if (this.value instanceof String) {
            return (String)this.value;
        }
        if (this.value instanceof Collection) {
            Collection coll = (Collection)this.value;
            String previousText = null;
            StringBuffer buffer = null;
            Iterator iter = coll.iterator();
            while (iter.hasNext()) {
                Object child = iter.next();
                if (!(child instanceof String)) continue;
                String childText = (String)child;
                if (previousText == null) {
                    previousText = childText;
                    continue;
                }
                if (buffer == null) {
                    buffer = new StringBuffer();
                    buffer.append(previousText);
                }
                buffer.append(childText);
            }
            if (buffer != null) {
                return buffer.toString();
            }
            if (previousText != null) {
                return previousText;
            }
        }
        return "";
    }

    public List children() {
        if (this.value == null) {
            return Collections.EMPTY_LIST;
        }
        if (this.value instanceof List) {
            return (List)this.value;
        }
        return Collections.singletonList(this.value);
    }

    public Map attributes() {
        return this.attributes;
    }

    public Object attribute(Object key) {
        return this.attributes != null ? this.attributes.get(key) : null;
    }

    public Object name() {
        return this.name;
    }

    public Object value() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Node parent() {
        return this.parent;
    }

    public Object get(String key) {
        if (key.charAt(0) == '@') {
            String attributeName = key.substring(1);
            return this.attributes().get(attributeName);
        }
        ArrayList<Node> answer = new ArrayList<Node>();
        Iterator iter = this.children().iterator();
        while (iter.hasNext()) {
            Node childNode;
            Object child = iter.next();
            if (!(child instanceof Node) || !key.equals((childNode = (Node)child).name())) continue;
            answer.add(childNode);
        }
        return answer;
    }

    public List depthFirst() {
        ArrayList<Node> answer = new ArrayList<Node>();
        Iterator iter = InvokerHelper.asIterator(this.value);
        while (iter.hasNext()) {
            Object child = iter.next();
            if (!(child instanceof Node)) continue;
            Node childNode = (Node)child;
            List children = childNode.depthFirst();
            answer.add(childNode);
            answer.addAll(children);
        }
        return answer;
    }

    public List bredthFirst() {
        Node childNode;
        ArrayList<Node> answer = new ArrayList<Node>();
        Iterator iter = InvokerHelper.asIterator(this.value);
        while (iter.hasNext()) {
            Object child = iter.next();
            if (!(child instanceof Node)) continue;
            childNode = (Node)child;
            answer.add(childNode);
        }
        ArrayList copy = new ArrayList(answer);
        Iterator iter2 = copy.iterator();
        while (iter2.hasNext()) {
            childNode = (Node)iter2.next();
            List children = childNode.bredthFirst();
            answer.addAll(children);
        }
        return answer;
    }

    public String toString() {
        return this.name + "[attributes=" + this.attributes + "; value=" + this.value + "]";
    }

    public void print(PrintWriter out) {
        new NodePrinter(out).print(this);
    }
}

