/*
 * Decompiled with CFR 0.152.
 */
package org.intabulas.sandler.serialization;

import java.util.Date;
import java.util.Iterator;
import org.intabulas.sandler.elements.Content;
import org.intabulas.sandler.elements.Entry;
import org.intabulas.sandler.elements.Feed;
import org.intabulas.sandler.elements.Generator;
import org.intabulas.sandler.elements.Link;
import org.intabulas.sandler.elements.Person;
import org.intabulas.sandler.parser.sax.HandlerMulticaster;
import org.intabulas.sandler.serialization.AttributesImpl;
import org.intabulas.sandler.serialization.SandlerSerializer;
import org.intabulas.sandler.serialization.SerializationException;
import org.intabulas.sandler.util.SandlerUtilities;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class SAXSerializer
implements SandlerSerializer {
    public static final String ATOM_NAMESPACE = "http://purl.org/atom/ns#";
    public static final String VERSION = "version";
    public static final String ATOM_VERSION = "0.3";
    public static final String EMPTY_STRING = "";
    public static final String XML_NAMESPACE = "http://www.w3.org/XML/1998/namespace";
    public static final String LANG = "lang";
    public static final String XML_LANG = "xml:lang";
    public static final String CDATA = "CDATA";
    public static final String FEED_ELEMENT = "feed";
    public static final String TITLE_ELEMENT = "title";
    public static final String AUTHOR_ELEMENT = "author";
    public static final String CONTRIBUTOR_ELEMENT = "contributor";
    public static final String TAGLINE_ELEMENT = "tagline";
    public static final String ID_ELEMENT = "id";
    public static final String COPYRIGHT_ELEMENT = "copyright";
    public static final String INFO_ELEMENT = "info";
    public static final String MODIFIED_ELEMENT = "modified";
    public static final String URI_ELEMENT = "uri";
    public static final String GENERATOR_ELEMEMT = "generator";
    public static final String NAME_ELEMENT = "name";
    public static final String ENTRY_ELEMENT = "entry";
    public static final String ISSUED_ELEMENT = "issued";
    public static final String SUMMARY_ELEMENT = "summary";
    public static final String CREATED_ELEMENT = "created";
    public static final String CONTENT_ELEMENT = "content";
    public static final String EMAIL_ELEMENT = "email";
    public static final String URL_ELEMENT = "url";
    public static final String TYPE = "type";
    public static final String HREF = "href";
    public static final String REL = "rel";
    public static final String LINK_ELEMENT = "link";
    public static final String MODE = "mode";
    private AttributesImpl attrs = new AttributesImpl();
    private MyMulticaster handler;

    public SAXSerializer() {
        this.reset();
    }

    public void reset() {
        this.attrs.clear();
        this.handler = new MyMulticaster();
    }

    public void serialize(Feed feed) throws SerializationException {
        try {
            this.handler.startDocument();
            this.handler.startPrefixMapping(EMPTY_STRING, ATOM_NAMESPACE);
            this.attrs.clear();
            this.attrs.addAttribute(VERSION, ATOM_VERSION);
            if (feed.getLanguage() != null) {
                this.attrs.addAttribute(XML_NAMESPACE, LANG, XML_LANG, CDATA, feed.getLanguage());
            }
            this.handler.startElement(FEED_ELEMENT, this.attrs);
            if (feed.getTitle() != null) {
                this.serializeContent(TITLE_ELEMENT, feed.getTitle());
            }
            Iterator iterator = feed.getLinks().iterator();
            while (iterator.hasNext()) {
                this.serializeLink((Link)iterator.next());
            }
            if (feed.getAuthor() != null) {
                this.serializePerson(AUTHOR_ELEMENT, feed.getAuthor());
            }
            iterator = feed.getContributors().iterator();
            while (iterator.hasNext()) {
                this.serializePerson(CONTRIBUTOR_ELEMENT, (Person)iterator.next());
            }
            if (feed.getTagline() != null) {
                this.serializeContent(TAGLINE_ELEMENT, feed.getTagline());
            }
            if (feed.getId() != null) {
                this.attrs.clear();
                this.handler.startElement(ID_ELEMENT, this.attrs);
                this.handler.characters(feed.getId());
                this.handler.endElement(ID_ELEMENT);
            }
            if (feed.getGenerator() != null) {
                this.serializeGenerator(feed.getGenerator());
            }
            if (feed.getCopyright() != null) {
                this.serializeContent(COPYRIGHT_ELEMENT, feed.getCopyright());
            }
            if (feed.getInfo() != null) {
                this.serializeContent(INFO_ELEMENT, feed.getInfo());
            }
            if (feed.getModified() != null) {
                this.serializeDate(MODIFIED_ELEMENT, feed.getModified());
            }
            iterator = feed.getEntries().iterator();
            while (iterator.hasNext()) {
                this.serialize((Entry)iterator.next(), false);
            }
            this.handler.endElement(FEED_ELEMENT);
            this.handler.endPrefixMapping(EMPTY_STRING);
            this.handler.endDocument();
        }
        catch (SAXException e) {
            throw new SerializationException("SAX Error serializing feed: " + e.getMessage(), e);
        }
    }

    private void serializeGenerator(Generator generator) throws SAXException {
        this.attrs.clear();
        if (generator.getUri() != null) {
            this.attrs.addAttribute(URI_ELEMENT, generator.getUri());
        }
        if (generator.getVersion() != null) {
            this.attrs.addAttribute(VERSION, generator.getVersion());
        }
        this.handler.startElement(GENERATOR_ELEMEMT, this.attrs);
        this.handler.startElement(NAME_ELEMENT, this.attrs);
        this.handler.characters(generator.getName());
        this.handler.endElement(NAME_ELEMENT);
        this.handler.endElement(GENERATOR_ELEMEMT);
    }

    public void serialize(Entry entry) throws SerializationException {
        this.serialize(entry, true);
    }

    public void serialize(Entry entry, boolean is_doc) throws SerializationException {
        try {
            if (is_doc) {
                this.handler.startDocument();
            }
            if (is_doc) {
                this.handler.startPrefixMapping(EMPTY_STRING, ATOM_NAMESPACE);
            }
            this.attrs.clear();
            this.handler.startElement(ENTRY_ELEMENT, this.attrs);
            if (entry.getTitle() != null) {
                this.serializeContent(TITLE_ELEMENT, entry.getTitle());
            }
            Iterator iterator = entry.getLinks().iterator();
            while (iterator.hasNext()) {
                this.serializeLink((Link)iterator.next());
            }
            if (entry.getModified() != null) {
                this.serializeDate(MODIFIED_ELEMENT, entry.getModified());
            }
            if (entry.getIssued() != null) {
                this.serializeDate(ISSUED_ELEMENT, entry.getIssued());
            }
            if (entry.getCreated() != null) {
                this.serializeDate(CREATED_ELEMENT, entry.getCreated());
            }
            if (entry.getAuthor() != null) {
                this.serializePerson(AUTHOR_ELEMENT, entry.getAuthor());
            }
            iterator = entry.getContributors().iterator();
            while (iterator.hasNext()) {
                this.serializePerson(CONTRIBUTOR_ELEMENT, (Person)iterator.next());
            }
            if (entry.getSummary() != null) {
                this.serializeContent(SUMMARY_ELEMENT, entry.getSummary());
            }
            if (entry.getId() != null) {
                this.attrs.clear();
                this.handler.startElement(ID_ELEMENT, this.attrs);
                this.handler.characters(entry.getId());
                this.handler.endElement(ID_ELEMENT);
            }
            iterator = entry.getContents().iterator();
            while (iterator.hasNext()) {
                this.serializeContent(CONTENT_ELEMENT, (Content)iterator.next());
            }
            this.handler.endElement(ENTRY_ELEMENT);
            if (is_doc) {
                this.handler.endPrefixMapping(EMPTY_STRING);
            }
            if (is_doc) {
                this.handler.endDocument();
            }
        }
        catch (SAXException e) {
            throw new SerializationException(e);
        }
    }

    private void serializeDate(String name, Date date) throws SAXException {
        this.attrs.clear();
        this.handler.startElement(name, this.attrs);
        this.handler.characters(SandlerUtilities.getUTCDate(date));
        this.handler.endElement(name);
    }

    private void serializePerson(String name, Person person) throws SAXException {
        this.attrs.clear();
        this.handler.startElement(name, this.attrs);
        if (person.getName() != null) {
            this.handler.startElement(NAME_ELEMENT, this.attrs);
            this.handler.characters(person.getName());
            this.handler.endElement(NAME_ELEMENT);
        }
        if (person.getEmail() != null) {
            this.handler.startElement(EMAIL_ELEMENT, this.attrs);
            this.handler.characters(person.getEmail());
            this.handler.endElement(EMAIL_ELEMENT);
        }
        if (person.getUrl() != null) {
            this.handler.startElement(URL_ELEMENT, this.attrs);
            this.handler.characters(person.getUrl());
            this.handler.endElement(URL_ELEMENT);
        }
        this.handler.endElement(name);
    }

    private void serializeLink(Link link) throws SAXException {
        this.attrs.clear();
        if (link.getTitle() != null) {
            this.attrs.addAttribute(TITLE_ELEMENT, link.getTitle());
        }
        if (link.getRelationship() != null) {
            this.attrs.addAttribute(REL, link.getRelationship());
        }
        if (link.getType() != null) {
            this.attrs.addAttribute(TYPE, link.getType());
        }
        if (link.getHref() != null) {
            this.attrs.addAttribute(HREF, link.getHref());
        }
        this.handler.startElement(LINK_ELEMENT, this.attrs);
        this.handler.endElement(LINK_ELEMENT);
    }

    private void serializeContent(String name, Content content) throws SAXException {
        this.attrs.clear();
        if (content.getMode() != null) {
            this.attrs.addAttribute(MODE, content.getMode());
        }
        if (content.getMimeType() != null) {
            this.attrs.addAttribute(TYPE, content.getMimeType());
        }
        this.handler.startElement(name, this.attrs);
        this.handler.characters(content.getBody());
        this.handler.endElement(name);
    }

    public void addHandler(ContentHandler handler) {
        this.handler.addHandler(handler);
    }

    private class MyMulticaster
    extends HandlerMulticaster {
        private MyMulticaster() {
        }

        private void startElement(String name, Attributes attrs) throws SAXException {
            this.startElement(SAXSerializer.ATOM_NAMESPACE, name, name, attrs);
        }

        private void endElement(String name) throws SAXException {
            this.endElement(SAXSerializer.ATOM_NAMESPACE, name, name);
        }

        private void characters(String chars) throws SAXException {
            char[] ary = chars.toCharArray();
            this.characters(ary, 0, ary.length);
        }
    }
}

