/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.collections;

import com.thoughtworks.xstream.alias.ClassMapper;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.collections.AbstractCollectionConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;

public class ArrayConverter
extends AbstractCollectionConverter {
    public ArrayConverter(ClassMapper classMapper, String string) {
        super(classMapper, string);
    }

    public boolean canConvert(Class clazz) {
        return clazz.isArray();
    }

    public void marshal(Object object, HierarchicalStreamWriter hierarchicalStreamWriter, MarshallingContext marshallingContext) {
        int n = Array.getLength(object);
        for (int i = 0; i < n; ++i) {
            Object object2 = Array.get(object, i);
            this.writeItem(object2, marshallingContext, hierarchicalStreamWriter);
        }
    }

    public Object unmarshal(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext) {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (hierarchicalStreamReader.hasMoreChildren()) {
            hierarchicalStreamReader.moveDown();
            object = this.readItem(hierarchicalStreamReader, unmarshallingContext, null);
            arrayList.add(object);
            hierarchicalStreamReader.moveUp();
        }
        object = Array.newInstance(unmarshallingContext.getRequiredType().getComponentType(), arrayList.size());
        int n = 0;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Array.set(object, n, e);
            ++n;
        }
        return object;
    }
}

