/*
 * Decompiled with CFR 0.152.
 */
package ccl.swing;

import ccl.swing.CCLLineBorder;
import ccl.swing.SwingUtil;
import ccl.swing.TableScrollPane;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableModel;

public class CCLTable
extends TableScrollPane {
    private JTable _table = null;
    private int _resizeMode = -1;
    public static final int AUTO_SIZE_LAST_COLUMN_TO_FIT = 1;
    public static final int AUTO_RESIZE_ALL_COLUMNS = 5;
    public static final int AUTO_RESIZE_LAST_COLUMN = 4;
    public static final int AUTO_RESIZE_NEXT_COLUMN = 2;
    public static final int AUTO_RESIZE_OFF = 1;
    public static final int AUTO_RESIZE_SUBSEQUENT_COLUMNS = 3;

    public CCLTable(TableModel aModel, Font font) {
        super(null);
        this._table = new JTable(aModel);
        this._table.setShowGrid(false);
        SwingUtil.setCCLButtonBorderOnTableHeader(this._table, font);
        this.setViewportView(this._table);
        this.setVerticalScrollBarPolicy(22);
        this.setHorizontalScrollBarPolicy(31);
        this.getViewport().setOpaque(false);
        this._table.setOpaque(false);
        int preferredWidth = this._table.getColumnModel().getTotalColumnWidth();
        this._table.setPreferredScrollableViewportSize(new Dimension(preferredWidth, 400));
        this.setBorder(BorderFactory.createCompoundBorder(SwingUtil.createCCLBorder(), new CCLLineBorder(this.getBackground().darker(), new Insets(0, 0, 0, 1))));
    }

    public JTable getTable() {
        return this._table;
    }

    public void setAutoResizeMode(int aResizeMode) {
        this._resizeMode = aResizeMode;
        if (aResizeMode != 1) {
            this._table.setAutoResizeMode(aResizeMode - 1);
        }
    }

    public Rectangle getCellRect(int row, int column, boolean includeSpacing) {
        return this._table.getCellRect(row, column, includeSpacing);
    }

    public void addMouseListener(MouseListener listener) {
        this._table.addMouseListener(listener);
    }

    public ListSelectionModel getSelectionModel() {
        return this._table.getSelectionModel();
    }

    public void setSelectionMode(int selectionMode) {
        this._table.setSelectionMode(selectionMode);
    }

    public void scrollRectToVisible(Rectangle rectangle) {
        this._table.scrollRectToVisible(rectangle);
    }

    protected int getResizeMode() {
        return this._resizeMode;
    }
}

