/*
 * Copied from Java I/O by Elliotte
 * Rusty Harold, page 43
 */

package ccl.util;

import java.io.InputStream;
import java.io.OutputStream;

/**
 * Copied from Java I/O by Elliotte
 * Rusty Harold, page 43 [1999-07-30 Chr. Clemens Lee].
 * 
 * @author  Elliotte Rusty Harold
 * @version $Id: StreamCopier.java,v 1.6 2002/12/22 20:46:29 clemens Exp clemens $
 */
public class StreamCopier 
{
    public StreamCopier() 
    {
        super();
    }

    /**
     * Copy one stream to another.
     *
     * @return   error
     */
    public static boolean copy( InputStream pInputStream_,
                                OutputStream pOutputStream_ )
    {
        return copy( pInputStream_, pOutputStream_, 0 );
    }

    /**
     * Copy one stream to another starting at position 'offset'
     * (starting with 0).
     *
     * @return   error
     */
    public static boolean copy( InputStream pInputStream_
                                , OutputStream pOutputStream_
                                , long offset )
    {
        try 
        {
            synchronized( pInputStream_ ) 
                   {
                       synchronized( pOutputStream_ )
                              {
                                  pInputStream_.skip( offset );
                                  byte[] abBuffer = new byte[ 256 ];
                                  while( true )
                                  {
                                      int bytesRead = pInputStream_.read( abBuffer );
                                      if ( bytesRead == -1 ) 
                                      {
                                          break;
                                      }
                                      pOutputStream_.write( abBuffer, 0, bytesRead );
                                  }
                              }
                   }
        }
        catch( Exception pException ) 
        {
            Util.printlnErr( "ccl.util.StreamCopier.copy(..).pException: " + pException );
            
            return true;
        }

        return false;
    }
}
