/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.types;

import bsh.EvalError;
import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import cc.mallet.util.BshInterpreter;
import cc.mallet.util.CommandOption;
import cc.mallet.util.IoUtils;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Iterator;

public class InstanceListTUI {
    static CommandOption.String prefixCodeOption = new CommandOption.String(InstanceList.class, "prefix-code", "Java code", true, null, "Java code you want run before any other interpreted code.  Note that the text is interpretted without modification, so unlike some other options, you need to include any necessary 'new's.", null);
    static CommandOption.SpacedStrings pipeInputOption = new CommandOption.SpacedStrings(InstanceList.class, "pipe-input", "STRING...", true, null, "The String or String[] that will be passed into the Pipe, (or the PipeInputIterator, if specified.  If --pipe-input-iterator is specified, this option is not used.", null);
    static final String defaultPipeIterator = "FileIterator(pipeInput,FileIterator.STARTING_DIRECTORIES)";
    static CommandOption.String pipeInputIteratorOption = new CommandOption.String(InstanceList.class, "pipe-input-iterator", "PipeInputIterator constructor", true, "FileIterator(pipeInput,FileIterator.STARTING_DIRECTORIES)", "A constructor for a PipeInputIterator, omitting the 'new', and substiting 'pipeInput' with the String or String[] that comes from the --pipe-input option.", "By default this value is null, indicating that no iterator is to be run, and simply the single --pipe-input argument should be put directly into the pipe.");
    static final String defaultPipe = "new Input2CharSequence(),new CharSequence2TokenSequence(),new TokenSequenceLowercase(),new TokenSequenceRemoveStopwords(),new TokenSequence2FeatureSequence(),new FeatureSequence2FeatureVector(),new Target2Label()";
    static CommandOption.String pipeOption = new CommandOption.String(InstanceList.class, "pipe", "Pipe constructor", true, "new Input2CharSequence(),new CharSequence2TokenSequence(),new TokenSequenceLowercase(),new TokenSequenceRemoveStopwords(),new TokenSequence2FeatureSequence(),new FeatureSequence2FeatureVector(),new Target2Label()", "List of Java constructors for Pipe objects to be run in serial to process the pipe input, separated by semi-colons, with the 'new's omitted.", null);
    static CommandOption.File pipeFileOption = new CommandOption.File(InstanceList.class, "pipefile", "FILENAME", true, null, "Same as --pipe, except get the pipe specification from the named file instead of from the command line.  If both are set, the --pipe option takes precedence.", null);
    static CommandOption.String outputFilenameOption = new CommandOption.String(InstanceList.class, "output-file", "FILENAME", true, "instance-list.mallet", "The filename in which to write the resulting instance list.", null);
    static CommandOption.SpacedStrings textFileClassificationOption = new CommandOption.SpacedStrings(InstanceList.class, "pipe-text-file-directories", "DIR...", false, null, "Use a standard text classification pipeline run on all the files in the following directories, one directory per class name.", null);
    static final CommandOption.List commandOptions = new CommandOption.List("Options for creating, manipulating, querying and saving instance lists", new CommandOption[]{pipeInputOption, pipeInputIteratorOption, pipeOption, outputFilenameOption, textFileClassificationOption, prefixCodeOption});

    public static void main(String[] args) throws EvalError, IOException {
        commandOptions.process(args);
        BshInterpreter interpreter = new BshInterpreter(InstanceListTUI.prefixCodeOption.value);
        String pipeSpec = InstanceListTUI.pipeOption.value == defaultPipe && InstanceListTUI.pipeFileOption.value != null ? IoUtils.contentsAsString(InstanceListTUI.pipeFileOption.value) : InstanceListTUI.pipeOption.value;
        String pipeWithNew = "new SerialPipes(new Pipe[] { " + pipeSpec + " })";
        Pipe instancePipe = (Pipe)interpreter.eval(pipeWithNew);
        InstanceList ilist = new InstanceList(instancePipe);
        System.out.println("Piping...");
        if (InstanceListTUI.pipeInputIteratorOption.value != null) {
            if (InstanceListTUI.pipeInputOption.value.length > 1) {
                interpreter.set("pipeInput", InstanceListTUI.pipeInputOption.value);
            } else {
                interpreter.set("pipeInput", InstanceListTUI.pipeInputOption.value[0]);
            }
            Iterator pii = (Iterator)interpreter.eval("new " + InstanceListTUI.pipeInputIteratorOption.value);
            ilist.addThruPipe(pii);
        } else {
            Instance carrier = InstanceListTUI.pipeInputOption.value.length > 1 ? instancePipe.instanceFrom(new Instance(InstanceListTUI.pipeInputOption.value, null, null, null)) : instancePipe.instanceFrom(new Instance(InstanceListTUI.pipeInputOption.value[0], null, null, null));
            if (carrier.getData() instanceof InstanceList) {
                ilist = (InstanceList)carrier.getData();
            } else {
                ilist.add(carrier);
            }
        }
        ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(InstanceListTUI.outputFilenameOption.value));
        oos.writeObject(ilist);
        oos.close();
    }
}

