// -*- mode: c++; c-indent-level: 4; c++-member-init-indent: 8; comment-column: 35; -*-

//-----------------------------------------------------------------------------
// eoRandomRealWeightUp.h
// (c) OPAC 2007
/*
    Contact: paradiseo-help@lists.gforge.inria.fr
 */
//-----------------------------------------------------------------------------

#ifndef EORANDOMREALWEIGHTUP_H
#define EORANDOMREALWEIGHTUP_H

//-----------------------------------------------------------------------------
#include <eoWeightUpdater.h>
#include <utils/eoRNG.h>
//-----------------------------------------------------------------------------

/**
 * Update an inertia weight by assigning it an (uniform) random value.
 */
class eoRandomRealWeightUp:public eoWeightUpdater<double>
{
public:

    /**
     * Default constructor
     * @param _min - The minimum bound for the weight
     * @param _max - The maximum bound for the weight
     */
    eoRandomRealWeightUp(
        double  _min,
        double  _max
    ):min(_min),max(_max)
    {
        // consistency check
        if (min > max)
        {
            std::string s;
            s.append (" min > max in eoRandomRealWeightUp");
            throw std::runtime_error (s);
        }
    }

    /**
     * Generate an real random number in [min,max] and assign it to _weight
     * @param _weight - The assigned (real) weight
     */
    void operator() (double & _weight)
    {
        _weight=rng.uniform(max-min)+min;
    }


protected:
    double min,max;

};



#endif/*EORANDOMREALWEIGHTUP_H*/
