/*
 * Decompiled with CFR 0.152.
 */
package fan.sys;

import fan.sys.Env;
import fan.sys.FanInt;
import fan.sys.FanNum;
import fan.sys.Locale;
import fan.sys.NumDigits;
import fan.sys.NumPattern;
import fan.sys.ParseErr;
import fan.sys.Sys;
import fan.sys.Type;
import fanx.serial.ObjEncoder;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;

public final class FanFloat {
    public static final double posInf = Double.POSITIVE_INFINITY;
    public static final double negInf = Double.NEGATIVE_INFINITY;
    public static final double nan = Double.NaN;
    public static final double e = Math.E;
    public static final double pi = Math.PI;
    public static final double defVal = 0.0;
    public static final String PosInfStr = "INF";
    public static final String NegInfStr = "-INF";
    public static final String NaNStr = "NaN";

    public static Double fromStr(String string) {
        return FanFloat.fromStr(string, true);
    }

    public static Double fromStr(String string, boolean bl) {
        try {
            if (string.equals(NaNStr)) {
                return Double.NaN;
            }
            if (string.equals(PosInfStr)) {
                return Double.POSITIVE_INFINITY;
            }
            if (string.equals(NegInfStr)) {
                return Double.NEGATIVE_INFINITY;
            }
            return Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (!bl) {
                return null;
            }
            throw ParseErr.make("Float", string);
        }
    }

    public static double makeBits(long l) {
        return Double.longBitsToDouble(l);
    }

    public static double makeBits32(long l) {
        return Float.intBitsToFloat((int)l);
    }

    public static double random() {
        return FanInt.random.nextDouble();
    }

    public static boolean equals(double d, Object object) {
        if (object instanceof Double) {
            double d2 = (Double)object;
            return d == d2;
        }
        return false;
    }

    public static boolean approx(double d, double d2) {
        return FanFloat.approx(d, d2, null);
    }

    public static boolean approx(double d, double d2, Double d3) {
        if (FanFloat.compare(d, d2) == 0L) {
            return true;
        }
        double d4 = d3 == null ? Math.min(Math.abs(d / 1000000.0), Math.abs(d2 / 1000000.0)) : d3;
        return Math.abs(d - d2) <= d4;
    }

    public static long compare(double d, Object object) {
        return FanFloat.compare(d, (Double)object);
    }

    public static long compare(double d, double d2) {
        if (Double.isNaN(d)) {
            return Double.isNaN(d2) ? 0L : -1L;
        }
        if (Double.isNaN(d2)) {
            return 1L;
        }
        if (d < d2) {
            return -1L;
        }
        return d == d2 ? 0L : 1L;
    }

    public static boolean isNaN(double d) {
        return Double.isNaN(d);
    }

    public static long hash(double d) {
        return FanFloat.bits(d);
    }

    public static long bits(double d) {
        return Double.doubleToLongBits(d);
    }

    public static long bits32(double d) {
        return (long)Float.floatToIntBits((float)d) & 0xFFFFFFFFL;
    }

    public static Type typeof(double d) {
        return Sys.FloatType;
    }

    public static double negate(double d) {
        return -d;
    }

    public static double increment(double d) {
        return d + 1.0;
    }

    public static double decrement(double d) {
        return d - 1.0;
    }

    public static double mult(double d, double d2) {
        return d * d2;
    }

    public static double multInt(double d, long l) {
        return d * (double)l;
    }

    public static BigDecimal multDecimal(double d, BigDecimal bigDecimal) {
        return BigDecimal.valueOf(d).multiply(bigDecimal);
    }

    public static double div(double d, double d2) {
        return d / d2;
    }

    public static double divInt(double d, long l) {
        return d / (double)l;
    }

    public static BigDecimal divDecimal(double d, BigDecimal bigDecimal) {
        return BigDecimal.valueOf(d).divide(bigDecimal);
    }

    public static double mod(double d, double d2) {
        return d % d2;
    }

    public static double modInt(double d, long l) {
        return d % (double)l;
    }

    public static BigDecimal modDecimal(double d, BigDecimal bigDecimal) {
        return BigDecimal.valueOf(d).remainder(bigDecimal);
    }

    public static double plus(double d, double d2) {
        return d + d2;
    }

    public static double plusInt(double d, long l) {
        return d + (double)l;
    }

    public static BigDecimal plusDecimal(double d, BigDecimal bigDecimal) {
        return BigDecimal.valueOf(d).add(bigDecimal);
    }

    public static double minus(double d, double d2) {
        return d - d2;
    }

    public static double minusInt(double d, long l) {
        return d - (double)l;
    }

    public static BigDecimal minusDecimal(double d, BigDecimal bigDecimal) {
        return BigDecimal.valueOf(d).subtract(bigDecimal);
    }

    public static double abs(double d) {
        if (d >= 0.0) {
            return d;
        }
        return -d;
    }

    public static double min(double d, double d2) {
        if (d <= d2) {
            return d;
        }
        return d2;
    }

    public static double max(double d, double d2) {
        if (d >= d2) {
            return d;
        }
        return d2;
    }

    public static double ceil(double d) {
        return Math.ceil(d);
    }

    public static double floor(double d) {
        return Math.floor(d);
    }

    public static double round(double d) {
        return Math.rint(d);
    }

    public static double exp(double d) {
        return Math.exp(d);
    }

    public static double log(double d) {
        return Math.log(d);
    }

    public static double log10(double d) {
        return Math.log10(d);
    }

    public static double pow(double d, double d2) {
        return Math.pow(d, d2);
    }

    public static double sqrt(double d) {
        return Math.sqrt(d);
    }

    public static double acos(double d) {
        return Math.acos(d);
    }

    public static double asin(double d) {
        return Math.asin(d);
    }

    public static double atan(double d) {
        return Math.atan(d);
    }

    public static double atan2(double d, double d2) {
        return Math.atan2(d, d2);
    }

    public static double cos(double d) {
        return Math.cos(d);
    }

    public static double cosh(double d) {
        return Math.cosh(d);
    }

    public static double sin(double d) {
        return Math.sin(d);
    }

    public static double sinh(double d) {
        return Math.sinh(d);
    }

    public static double tan(double d) {
        return Math.tan(d);
    }

    public static double tanh(double d) {
        return Math.tanh(d);
    }

    public static double toDegrees(double d) {
        return Math.toDegrees(d);
    }

    public static double toRadians(double d) {
        return Math.toRadians(d);
    }

    public static String toStr(double d) {
        if (Double.isNaN(d)) {
            return NaNStr;
        }
        if (d == Double.POSITIVE_INFINITY) {
            return PosInfStr;
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return NegInfStr;
        }
        return Double.toString(d);
    }

    public static void encode(double d, ObjEncoder objEncoder) {
        if (Double.isNaN(d)) {
            objEncoder.w("sys::Float(\"NaN\")");
        } else if (d == Double.POSITIVE_INFINITY) {
            objEncoder.w("sys::Float(\"INF\")");
        } else if (d == Double.NEGATIVE_INFINITY) {
            objEncoder.w("sys::Float(\"-INF\")");
        } else {
            objEncoder.w(Double.toString(d)).w("f");
        }
    }

    public static String toCode(double d) {
        if (Double.isNaN(d)) {
            return "Float.nan";
        }
        if (d == Double.POSITIVE_INFINITY) {
            return "Float.posInf";
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return "Float.negInf";
        }
        return Double.toString(d) + "f";
    }

    public static String toLocale(double d) {
        return FanFloat.toLocale(d, null);
    }

    public static String toLocale(double d, String string) {
        try {
            String string2;
            Locale locale = Locale.cur();
            DecimalFormatSymbols decimalFormatSymbols = locale.decimal();
            if (Double.isNaN(d)) {
                return decimalFormatSymbols.getNaN();
            }
            if (d == Double.POSITIVE_INFINITY) {
                return decimalFormatSymbols.getInfinity();
            }
            if (d == Double.NEGATIVE_INFINITY) {
                return decimalFormatSymbols.getMinusSign() + decimalFormatSymbols.getInfinity();
            }
            if (string == null) {
                string = Env.cur().locale(Sys.sysPod, "float", "#,###.0##");
            }
            if ((string2 = Double.toString(d)).indexOf(69) > 0) {
                string2 = new DecimalFormat("0.#########", decimalFormatSymbols).format(d);
            }
            NumPattern numPattern = NumPattern.parse(string);
            NumDigits numDigits = new NumDigits(string2);
            return FanNum.toLocale(numPattern, numDigits, decimalFormatSymbols);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return String.valueOf(d);
        }
    }
}

