/*
 * Decompiled with CFR 0.152.
 */
package fanx.fcode;

import fan.sys.ClassLoaderFile;
import fan.sys.List;
import fan.sys.LocalFile;
import fan.sys.Sys;
import fan.sys.UnknownPodErr;
import fan.sys.Uri;
import fan.sys.ZipEntryFile;
import fanx.fcode.FPod;
import fanx.util.Box;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public abstract class FStore {
    FPod fpod;

    public static FStore makeZip(File file) throws Exception {
        if (file == null) {
            throw new IllegalStateException();
        }
        return new ZipStore(new ZipFile(file));
    }

    public static FStore makeJarDist(ClassLoader classLoader, String string) {
        JarDistStore jarDistStore = new JarDistStore(classLoader);
        if (jarDistStore.hasPod(string)) {
            return jarDistStore;
        }
        throw UnknownPodErr.make(string);
    }

    public abstract List podFiles(Uri var1) throws IOException;

    public final Input read(String string) throws IOException {
        return this.read(string, false);
    }

    public abstract Input read(String var1, boolean var2) throws IOException;

    public abstract Box readToBox(String var1) throws IOException;

    public abstract void close() throws IOException;

    static class JarDistStore
    extends FStore {
        ClassLoader loader;

        JarDistStore(ClassLoader classLoader) {
            this.loader = classLoader;
        }

        public boolean hasPod(String string) {
            String string2 = "reflect/" + string + "/meta.props";
            InputStream inputStream = this.loader.getResourceAsStream(string2);
            if (inputStream == null) {
                return false;
            }
            try {
                inputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }

        public List podFiles(Uri uri) throws IOException {
            String string;
            String string2 = "res/" + this.fpod.podName + "/res-manifest.txt";
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.loader.getResourceAsStream(string2)));
            List list = new List(Sys.FileType);
            while ((string = bufferedReader.readLine()) != null) {
                if (string.length() == 0) continue;
                Uri uri2 = Uri.fromStr(uri.toString() + string);
                String string3 = "res/" + this.fpod.podName + string;
                ClassLoaderFile classLoaderFile = new ClassLoaderFile(this.loader, string3, uri2);
                list.add(classLoaderFile);
            }
            return list;
        }

        public Input read(String string, boolean bl) throws IOException {
            string = "reflect/" + this.fpod.podName + "/" + string;
            InputStream inputStream = this.loader.getResourceAsStream(string);
            if (inputStream == null) {
                if (bl) {
                    throw new IOException("Missing required file \"" + string + "\" in pod zip");
                }
                return null;
            }
            return new Input(this.fpod, inputStream);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Box readToBox(String string) throws IOException {
            string = "reflect/" + this.fpod.podName + "/" + string;
            InputStream inputStream = this.loader.getResourceAsStream(string);
            if (inputStream == null) {
                return null;
            }
            byte[] byArray = new byte[1024];
            Box box = new Box();
            try {
                int n;
                while ((n = inputStream.read(byArray, 0, 1024)) >= 0) {
                    box.append(byArray, n);
                }
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
            return box;
        }

        public void close() {
        }
    }

    static class ZipStore
    extends FStore {
        final ZipFile zipFile;

        ZipStore(ZipFile zipFile) {
            this.zipFile = zipFile;
        }

        public List podFiles(Uri uri) {
            List list = new List(Sys.FileType);
            Enumeration<? extends ZipEntry> enumeration = this.zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                String string = zipEntry.getName();
                if (string.endsWith(".fcode") || string.endsWith(".class") || string.endsWith(".def") && !string.contains("/")) continue;
                Uri uri2 = Uri.fromStr(uri + "/" + LocalFile.fileNameToUriName(zipEntry.getName()));
                list.add(new ZipEntryFile(this.zipFile, zipEntry, uri2));
            }
            return list;
        }

        public Input read(String string, boolean bl) throws IOException {
            ZipEntry zipEntry = this.zipFile.getEntry(string);
            if (zipEntry == null) {
                if (bl) {
                    throw new IOException("Missing required file \"" + string + "\" in pod zip");
                }
                return null;
            }
            return new Input(this.fpod, this.zipFile.getInputStream(zipEntry));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Box readToBox(String string) throws IOException {
            ZipEntry zipEntry = this.zipFile.getEntry(string);
            if (zipEntry == null) {
                return null;
            }
            int n = (int)zipEntry.getSize();
            byte[] byArray = new byte[n];
            InputStream inputStream = this.zipFile.getInputStream(zipEntry);
            try {
                for (int i = 0; i < n; i += inputStream.read(byArray, i, n - i)) {
                }
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
            return new Box(byArray);
        }

        public void close() throws IOException {
            this.zipFile.close();
        }
    }

    public static class Input
    extends DataInputStream {
        public final FPod fpod;

        Input(FPod fPod, InputStream inputStream) {
            super(inputStream);
            this.fpod = fPod;
        }

        public final int u1() throws IOException {
            return this.readUnsignedByte();
        }

        public final int u2() throws IOException {
            return this.readUnsignedShort();
        }

        public final int u4() throws IOException {
            return this.readInt();
        }

        public final long u8() throws IOException {
            return this.readLong();
        }

        public final double f8() throws IOException {
            return this.readDouble();
        }

        public final String utf() throws IOException {
            return this.readUTF();
        }

        public final String name() throws IOException {
            return this.fpod.name(this.u2());
        }
    }
}

