/*
 * Decompiled with CFR 0.152.
 */
package fanx.test;

import fan.sys.MemBuf;
import fan.sys.SysInStream;
import fan.sys.SysOutStream;
import fanx.test.Test;
import fanx.util.FileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class FileUtilTest
extends Test {
    public void run() throws Exception {
        this.verifyRead();
        this.verifyJavaOutputStream();
        this.verifyJavaInputStream();
    }

    void verifyRead() throws Exception {
        this.verifyRead("", "");
        this.verifyRead("x", "x");
        this.verifyRead("foo", "foo");
        this.verifyRead("foo bar", "foo bar");
        this.verifyRead("x\n", "x\n");
        this.verifyRead("x\n\n", "x\n\n");
        this.verifyRead("\nx", "\nx");
        this.verifyRead("\n\nx", "\n\nx");
        this.verifyRead("\nx\n", "\nx\n");
        this.verifyRead("\n\nx\n", "\n\nx\n");
        this.verifyRead("a\nb", "a\nb");
        this.verifyRead("foo\n", "foo\n");
        this.verifyRead("foo\n\n", "foo\n\n");
        this.verifyRead("\nfoo", "\nfoo");
        this.verifyRead("\n\nfoo", "\n\nfoo");
        this.verifyRead("\nfoo\n", "\nfoo\n");
        this.verifyRead("\n\nfoo\n", "\n\nfoo\n");
        this.verifyRead("foo\nbar", "foo\nbar");
        this.verifyRead("x\r", "x\n");
        this.verifyRead("x\r\r", "x\n\n");
        this.verifyRead("\rx", "\nx");
        this.verifyRead("\r\rx", "\n\nx");
        this.verifyRead("\rx\r", "\nx\n");
        this.verifyRead("\r\rx\r", "\n\nx\n");
        this.verifyRead("a\rb", "a\nb");
        this.verifyRead("foo\r", "foo\n");
        this.verifyRead("foo\r\r", "foo\n\n");
        this.verifyRead("\rfoo", "\nfoo");
        this.verifyRead("\r\rfoo", "\n\nfoo");
        this.verifyRead("\rfoo\r", "\nfoo\n");
        this.verifyRead("\r\rfoo\r", "\n\nfoo\n");
        this.verifyRead("foo\rbar", "foo\nbar");
        this.verifyRead("x\r\n", "x\n");
        this.verifyRead("x\r\n\r\n", "x\n\n");
        this.verifyRead("\r\nx", "\nx");
        this.verifyRead("\r\n\r\nx", "\n\nx");
        this.verifyRead("\r\nx\r\n", "\nx\n");
        this.verifyRead("\r\n\r\nx\r\n", "\n\nx\n");
        this.verifyRead("a\r\nb", "a\nb");
        this.verifyRead("foo\r\n", "foo\n");
        this.verifyRead("foo\r\n\r\n", "foo\n\n");
        this.verifyRead("\r\nfoo", "\nfoo");
        this.verifyRead("\r\n\r\nfoo", "\n\nfoo");
        this.verifyRead("\r\nfoo\r\n", "\nfoo\n");
        this.verifyRead("\r\n\r\nfoo\r\n", "\n\nfoo\n");
        this.verifyRead("foo\r\nbar", "foo\nbar");
        this.verifyRead("a\nb\rc\r\nd\r\re\nf", "a\nb\nc\nd\n\ne\nf");
        this.verifyRead("\u00f0", "\u00f0");
        this.verifyRead("\u0f00", "\u0f00");
        this.verifyRead("\u1234", "\u1234");
        this.verifyRead("x\u0080\u0700 \n \u7abc!", "x\u0080\u0700 \n \u7abc!");
        this.verifyRead("x\u0080\u0700 \r \u7abc!", "x\u0080\u0700 \n \u7abc!");
        this.verifyRead("x\u0080\u0700 \r\n \u7abc!", "x\u0080\u0700 \n \u7abc!");
    }

    void verifyRead(String string, String string2) throws Exception {
        File file = new File(FileUtilTest.temp(), "FileUtil-read.txt");
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF8");
        outputStreamWriter.write(string);
        outputStreamWriter.close();
        char[] cArray = FileUtil.read(file);
        this.verify(cArray.length == string2.length());
        this.verify(new String(cArray).equals(string2));
    }

    void verifyJavaOutputStream() throws Exception {
        MemBuf memBuf = new MemBuf(1024);
        OutputStream outputStream = SysOutStream.java(memBuf.out());
        outputStream.write(255);
        outputStream.write(new byte[]{97, 98, 99});
        outputStream.write(new byte[]{97, 98, 99}, 1, 1);
        outputStream.write(new byte[]{48, 49, 50, 51}, 2, 2);
        outputStream.close();
        this.verify(memBuf.size() == 7L);
        this.verify(memBuf.get(0L) == 255L);
        this.verify(memBuf.get(1L) == 97L);
        this.verify(memBuf.get(2L) == 98L);
        this.verify(memBuf.get(3L) == 99L);
        this.verify(memBuf.get(4L) == 98L);
        this.verify(memBuf.get(5L) == 50L);
        this.verify(memBuf.get(6L) == 51L);
    }

    void verifyJavaInputStream() throws Exception {
        MemBuf memBuf = new MemBuf(new byte[]{48, 49, 50, 51, 52, 53, 54});
        InputStream inputStream = SysInStream.java(memBuf.in());
        byte[] byArray = new byte[3];
        this.verify(inputStream.read() == 48);
        this.verify(inputStream.read(byArray) == 3);
        this.verify(byArray[0] == 49);
        this.verify(byArray[1] == 50);
        this.verify(byArray[2] == 51);
        this.verify(inputStream.read(byArray, 1, 1) == 1);
        this.verify(byArray[0] == 49);
        this.verify(byArray[1] == 52);
        this.verify(byArray[2] == 51);
        this.verify(inputStream.read(byArray) == 2);
        this.verify(byArray[0] == 53);
        this.verify(byArray[1] == 54);
        this.verify(byArray[2] == 51);
        this.verify(inputStream.read(byArray) == -1);
        this.verify(inputStream.read() == -1);
        this.verify(inputStream.read() == -1);
        inputStream.close();
    }
}

