// (c) Microsoft Corporation 2005-2007.

#light

namespace Microsoft.FSharp.Collections

open Microsoft.FSharp.Core
open Microsoft.FSharp.Core.LanguagePrimitives.IntrinsicOperators
open Microsoft.FSharp.Core.Operators
open Microsoft.FSharp.Collections
#if CLI_AT_MOST_1_1
open Microsoft.FSharp.Compatibility
#else
open System.Collections.Generic
#endif

[<CompilationRepresentation(CompilationRepresentationFlags.ModuleSuffix)>]
module Map = 


    (* We preallocate an option value to return as the result of tryfind *)
    type Map<'key,'a> = Microsoft.FSharp.Collections.Map<'key,'a>
    type ('key,'a) t = Microsoft.FSharp.Collections.Map<'key,'a>

    let empty<'key,'a> : Map<'key,'a> = Map.Empty ()
    let is_empty (m:Map<_,_>) = m.IsEmpty
    let add k v (m:Map<_,_>) = m.Add(k,v)
    let find k (m:Map<_,_>) = m.[k]
    let tryfind k (m:Map<_,_>) = m.TryFind(k)
    let remove k (m:Map<_,_>) = m.Remove(k)
    let mem k (m:Map<_,_>) = m.ContainsKey(k)
    let iter f (m:Map<_,_>) = m.Iterate(f)
    let first f (m:Map<_,_>) = m.First(f)
    let exists f (m:Map<_,_>) = m.Exists(f)
    let filter f (m:Map<_,_>) = m.Filter(f)
    let partition f (m:Map<_,_>) = m.Partition(f)
    let for_all f (m:Map<_,_>) = m.ForAll(f)
    let map f (m:Map<_,_>) = m.MapRange(f)
    let mapi f (m:Map<_,_>) = m.Map(f)
    let fold f (m:Map<_,_>) x = m.Fold f x
    
    let to_seq (m:Map<_,_>) = m |> Seq.map (fun kvp -> kvp.Key, kvp.Value)
    let find_index f (m : Map<_,_>) = m |> to_seq |> Seq.find_indexi f
    let tryfind_index f (m : Map<_,_>) = m |> to_seq |> Seq.tryfind_indexi f

    let of_list (l: ('key * 'a) list) = Map.FromList(l)
    let of_seq l = Map.Create(l)
    let of_array (l: ('key * 'a) array) = of_seq (Array.to_seq l)
    let to_list (m:Map<_,_>) = m.ToList()
    let to_array (m:Map<_,_>) = m.ToArray()
    let of_IEnumerable l = of_seq l



