/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.uaa.client;

import org.springframework.uaa.client.ProxyService;
import org.springframework.uaa.client.UaaDetectedProducts;
import org.springframework.uaa.client.UaaService;
import org.springframework.uaa.client.internal.BasicProxyService;
import org.springframework.uaa.client.internal.JdkUrlTransmissionServiceImpl;
import org.springframework.uaa.client.internal.TransmissionAwareUaaServiceImpl;
import org.springframework.uaa.client.internal.UaaDetectedProductsImpl;

public abstract class UaaServiceFactory {
    public static final ProxyService DEFAULT_PROXY_SERVICE = new BasicProxyService();
    private static UaaService _uaaService;
    private static UaaDetectedProducts _uaaDetectedProducts;
    private static ProxyService _proxyService;

    public static UaaService getUaaService() {
        return UaaServiceFactory.getUaaService(DEFAULT_PROXY_SERVICE);
    }

    public static synchronized UaaService getUaaService(ProxyService proxyService) {
        if (_proxyService == null) {
            _proxyService = proxyService;
        }
        if (_uaaService == null) {
            _uaaService = new TransmissionAwareUaaServiceImpl(new JdkUrlTransmissionServiceImpl(_proxyService));
        }
        return _uaaService;
    }

    public static synchronized UaaDetectedProducts getUaaDetectedProducts() {
        if (_uaaDetectedProducts == null) {
            _uaaDetectedProducts = new UaaDetectedProductsImpl();
        }
        return _uaaDetectedProducts;
    }

    public static synchronized ProxyService getProxyService() {
        if (_proxyService == null) {
            _proxyService = DEFAULT_PROXY_SERVICE;
        }
        return _proxyService;
    }
}

