/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.webflow.persistence;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.orm.hibernate3.SessionHolder;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.execution.FlowSession;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.persistence.HibernateFlowExecutionListener;

public class SessionAwareHibernateFlowExecutionListener
extends HibernateFlowExecutionListener {
    private static final Log LOG = LogFactory.getLog(SessionAwareHibernateFlowExecutionListener.class);
    private SessionFactory localSessionFactory;

    public SessionAwareHibernateFlowExecutionListener(SessionFactory sessionFactory, PlatformTransactionManager transactionManager) {
        super(sessionFactory, transactionManager);
        this.localSessionFactory = sessionFactory;
    }

    public void sessionStarting(RequestContext context, FlowSession session, MutableAttributeMap input) {
        if (!this.isSessionAlreadyBound()) {
            LOG.debug((Object)"sessionStarting: Binding Hibernate session to flow");
            super.sessionStarting(context, session, input);
        } else {
            LOG.debug((Object)"sessionStarting: Obtaining current Hibernate session");
            this.obtainCurrentSession(context);
        }
    }

    public void sessionEnding(RequestContext context, FlowSession session, String outcome, MutableAttributeMap output) {
        Session hibernateSession = this.getBoundHibernateSession(session);
        if (hibernateSession != null && session.isRoot()) {
            LOG.debug((Object)"sessionEnding: Commit transaction and unbinding Hibernate session");
            super.sessionEnding(context, session, outcome, output);
        }
    }

    public void resuming(RequestContext context) {
        if (!this.isSessionAlreadyBound()) {
            LOG.debug((Object)"resuming: Resumed flow, obtaining existing Hibernate session");
            super.resuming(context);
        } else {
            this.obtainCurrentSession(context);
        }
    }

    private boolean isSessionAlreadyBound() {
        return TransactionSynchronizationManager.hasResource((Object)this.localSessionFactory);
    }

    public void sessionEnded(RequestContext context, FlowSession session, String outcome, AttributeMap output) {
        if (this.isPersistenceContext(session.getDefinition()) && !this.isSessionAlreadyBound()) {
            super.sessionEnded(context, session, outcome, output);
        }
    }

    public void paused(RequestContext context) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"paused: Disconnecting Hibernate session");
        }
        super.paused(context);
    }

    private Session getBoundHibernateSession(FlowSession session) {
        return (Session)session.getScope().get("persistenceContext");
    }

    private boolean isPersistenceContext(FlowDefinition flow) {
        return flow.getAttributes().contains("persistenceContext");
    }

    private void obtainCurrentSession(RequestContext context) {
        MutableAttributeMap flowScope = context.getFlowScope();
        if (flowScope.get("persistenceContext") != null) {
            return;
        }
        SessionHolder sessionHolder = (SessionHolder)TransactionSynchronizationManager.getResource((Object)this.localSessionFactory);
        if (sessionHolder != null) {
            flowScope.put("persistenceContext", (Object)sessionHolder.getSession());
        }
    }
}

