/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.gradle.api.artifacts.verification.DependencyVerificationMode;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.api.internal.file.BasicFileResolver;
import org.gradle.internal.buildoption.AbstractBuildOption;
import org.gradle.internal.buildoption.BooleanBuildOption;
import org.gradle.internal.buildoption.BooleanCommandLineOptionConfiguration;
import org.gradle.internal.buildoption.BuildOption;
import org.gradle.internal.buildoption.BuildOptionSet;
import org.gradle.internal.buildoption.CommandLineOptionConfiguration;
import org.gradle.internal.buildoption.EnabledOnlyBooleanBuildOption;
import org.gradle.internal.buildoption.EnumBuildOption;
import org.gradle.internal.buildoption.IntegerBuildOption;
import org.gradle.internal.buildoption.ListBuildOption;
import org.gradle.internal.buildoption.Origin;
import org.gradle.internal.buildoption.StringBuildOption;
import org.gradle.internal.impldep.com.google.common.base.Splitter;
import org.gradle.internal.watch.vfs.WatchMode;

public class StartParameterBuildOptions
extends BuildOptionSet<StartParameterInternal> {
    private static List<BuildOption<StartParameterInternal>> options;

    @Override
    public List<? extends BuildOption<? super StartParameterInternal>> getAllOptions() {
        return options;
    }

    static {
        ArrayList<AbstractBuildOption> options = new ArrayList<AbstractBuildOption>();
        options.add(new ProjectCacheDirOption());
        options.add(new RerunTasksOption());
        options.add(new ProfileOption());
        options.add(new ContinueOption());
        options.add(new OfflineOption());
        options.add(new RefreshDependenciesOption());
        options.add(new DryRunOption());
        options.add(new ContinuousOption());
        options.add(new NoProjectDependenciesRebuildOption());
        options.add(new BuildFileOption());
        options.add(new SettingsFileOption());
        options.add(new InitScriptOption());
        options.add(new ExcludeTaskOption());
        options.add(new IncludeBuildOption());
        options.add(new ConfigureOnDemandOption());
        options.add(new BuildCacheOption());
        options.add(new BuildCacheDebugLoggingOption());
        options.add(new WatchFileSystemOption());
        options.add(new WatchFileSystemDebugLoggingOption());
        options.add(new VfsVerboseLoggingOption());
        options.add(new BuildScanOption());
        options.add(new DependencyLockingWriteOption());
        options.add(new DependencyVerificationWriteOption());
        options.add(new DependencyVerificationModeOption());
        options.add(new DependencyLockingUpdateOption());
        options.add(new RefreshKeysOption());
        options.add(new ExportKeysOption());
        options.add(new ConfigurationCacheProblemsOption());
        options.add(new ConfigurationCacheOption());
        options.add(new IsolatedProjectsOption());
        options.add(new ConfigurationCacheMaxProblemsOption());
        options.add(new ConfigurationCacheRecreateOption());
        options.add(new ConfigurationCacheQuietOption());
        StartParameterBuildOptions.options = Collections.unmodifiableList(options);
    }

    public static class ConfigurationCacheQuietOption
    extends BooleanBuildOption<StartParameterInternal> {
        public static final String PROPERTY_NAME = "org.gradle.unsafe.configuration-cache.quiet";

        public ConfigurationCacheQuietOption() {
            super(PROPERTY_NAME);
        }

        @Override
        public void applyTo(boolean value, StartParameterInternal settings, Origin origin) {
            settings.setConfigurationCacheQuiet(value);
        }
    }

    public static class ConfigurationCacheRecreateOption
    extends BooleanBuildOption<StartParameterInternal> {
        public static final String PROPERTY_NAME = "org.gradle.unsafe.configuration-cache.recreate-cache";

        public ConfigurationCacheRecreateOption() {
            super(PROPERTY_NAME);
        }

        @Override
        public void applyTo(boolean value, StartParameterInternal settings, Origin origin) {
            settings.setConfigurationCacheRecreateCache(value);
        }
    }

    public static class ConfigurationCacheMaxProblemsOption
    extends IntegerBuildOption<StartParameterInternal> {
        public static final String PROPERTY_NAME = "org.gradle.unsafe.configuration-cache.max-problems";

        public ConfigurationCacheMaxProblemsOption() {
            super(PROPERTY_NAME);
        }

        @Override
        public void applyTo(int value, StartParameterInternal settings, Origin origin) {
            settings.setConfigurationCacheMaxProblems(value);
        }
    }

    public static class ConfigurationCacheProblemsOption
    extends EnumBuildOption<Value, StartParameterInternal> {
        public static final String PROPERTY_NAME = "org.gradle.unsafe.configuration-cache-problems";
        public static final String LONG_OPTION = "configuration-cache-problems";

        public ConfigurationCacheProblemsOption() {
            super(LONG_OPTION, Value.class, (Enum[])Value.values(), PROPERTY_NAME, new CommandLineOptionConfiguration[]{CommandLineOptionConfiguration.create(LONG_OPTION, "Configures how the configuration cache handles problems (fail or warn). Defaults to fail.").incubating()});
        }

        @Override
        public void applyTo(Value value, StartParameterInternal settings, Origin origin) {
            settings.setConfigurationCacheProblems(value);
        }

        public static enum Value {
            FAIL,
            WARN;

        }
    }

    public static class IsolatedProjectsOption
    extends BooleanBuildOption<StartParameterInternal> {
        public static final String PROPERTY_NAME = "org.gradle.unsafe.isolated-projects";

        public IsolatedProjectsOption() {
            super(PROPERTY_NAME);
        }

        @Override
        public void applyTo(boolean value, StartParameterInternal settings, Origin origin) {
            settings.setIsolatedProjects(BuildOption.Value.value(value));
        }
    }

    public static class ConfigurationCacheOption
    extends BooleanBuildOption<StartParameterInternal> {
        public static final String PROPERTY_NAME = "org.gradle.unsafe.configuration-cache";
        public static final String LONG_OPTION = "configuration-cache";

        public ConfigurationCacheOption() {
            super(PROPERTY_NAME, BooleanCommandLineOptionConfiguration.create(LONG_OPTION, "Enables the configuration cache. Gradle will try to reuse the build configuration from previous builds.", "Disables the configuration cache.").incubating());
        }

        @Override
        public void applyTo(boolean value, StartParameterInternal settings, Origin origin) {
            settings.setConfigurationCache(BuildOption.Value.value(value));
        }
    }

    public static class ExportKeysOption
    extends EnabledOnlyBooleanBuildOption<StartParameterInternal> {
        private static final String LONG_OPTION = "export-keys";

        public ExportKeysOption() {
            super((String)null, CommandLineOptionConfiguration.create(LONG_OPTION, "Exports the public keys used for dependency verification."));
        }

        @Override
        public void applyTo(StartParameterInternal settings, Origin origin) {
            settings.setExportKeys(true);
        }
    }

    public static class RefreshKeysOption
    extends EnabledOnlyBooleanBuildOption<StartParameterInternal> {
        private static final String LONG_OPTION = "refresh-keys";

        public RefreshKeysOption() {
            super((String)null, CommandLineOptionConfiguration.create(LONG_OPTION, "Refresh the public keys used for dependency verification."));
        }

        @Override
        public void applyTo(StartParameterInternal settings, Origin origin) {
            settings.setRefreshKeys(true);
        }
    }

    public static class DependencyLockingUpdateOption
    extends ListBuildOption<StartParameterInternal> {
        public DependencyLockingUpdateOption() {
            super((String)null, CommandLineOptionConfiguration.create("update-locks", "Perform a partial update of the dependency lock, letting passed in module notations change version.").incubating());
        }

        @Override
        public void applyTo(List<String> modulesToUpdate, StartParameterInternal settings, Origin origin) {
            settings.setLockedDependenciesToUpdate(modulesToUpdate);
        }
    }

    public static class DependencyVerificationModeOption
    extends EnumBuildOption<DependencyVerificationMode, StartParameterInternal> {
        private static final String GRADLE_PROPERTY = "org.gradle.dependency.verification";
        private static final String LONG_OPTION = "dependency-verification";
        private static final String SHORT_OPTION = "F";

        public DependencyVerificationModeOption() {
            super(LONG_OPTION, DependencyVerificationMode.class, (Enum[])DependencyVerificationMode.values(), GRADLE_PROPERTY, new CommandLineOptionConfiguration[]{CommandLineOptionConfiguration.create(LONG_OPTION, SHORT_OPTION, "Configures the dependency verification mode. Values are 'strict', 'lenient' or 'off'.")});
        }

        @Override
        public void applyTo(DependencyVerificationMode value, StartParameterInternal settings, Origin origin) {
            settings.setDependencyVerificationMode(value);
        }
    }

    public static class DependencyVerificationWriteOption
    extends StringBuildOption<StartParameterInternal> {
        public static final String SHORT_OPTION = "M";
        public static final String LONG_OPTION = "write-verification-metadata";

        DependencyVerificationWriteOption() {
            super((String)null, CommandLineOptionConfiguration.create(LONG_OPTION, SHORT_OPTION, "Generates checksums for dependencies used in the project (comma-separated list)"));
        }

        @Override
        public void applyTo(String value, StartParameterInternal settings, Origin origin) {
            List<String> checksums = Splitter.on(",").omitEmptyStrings().trimResults().splitToList(value).stream().map(String::toLowerCase).collect(Collectors.toList());
            settings.setWriteDependencyVerifications(checksums);
        }
    }

    public static class DependencyLockingWriteOption
    extends EnabledOnlyBooleanBuildOption<StartParameterInternal> {
        public static final String LONG_OPTION = "write-locks";

        public DependencyLockingWriteOption() {
            super((String)null, CommandLineOptionConfiguration.create(LONG_OPTION, "Persists dependency resolution for locked configurations, ignoring existing locking information if it exists"));
        }

        @Override
        public void applyTo(StartParameterInternal settings, Origin origin) {
            settings.setWriteDependencyLocks(true);
        }
    }

    public static class BuildScanOption
    extends BooleanBuildOption<StartParameterInternal> {
        public static final String LONG_OPTION = "scan";

        public BuildScanOption() {
            super((String)null, BooleanCommandLineOptionConfiguration.create(LONG_OPTION, "Creates a build scan. Gradle will emit a warning if the build scan plugin has not been applied. (https://gradle.com/build-scans)", "Disables the creation of a build scan. For more information about build scans, please visit https://gradle.com/build-scans."));
        }

        @Override
        public void applyTo(boolean value, StartParameterInternal settings, Origin origin) {
            if (value) {
                settings.setBuildScan(true);
            } else {
                settings.setNoBuildScan(true);
            }
        }
    }

    public static class VfsVerboseLoggingOption
    extends BooleanBuildOption<StartParameterInternal> {
        public static final String GRADLE_PROPERTY = "org.gradle.vfs.verbose";

        public VfsVerboseLoggingOption() {
            super(GRADLE_PROPERTY);
        }

        @Override
        public void applyTo(boolean value, StartParameterInternal startParameter, Origin origin) {
            startParameter.setVfsVerboseLogging(value);
        }
    }

    public static class WatchFileSystemDebugLoggingOption
    extends BooleanBuildOption<StartParameterInternal> {
        public static final String GRADLE_PROPERTY = "org.gradle.vfs.watch.debug";

        public WatchFileSystemDebugLoggingOption() {
            super(GRADLE_PROPERTY);
        }

        @Override
        public void applyTo(boolean value, StartParameterInternal startParameter, Origin origin) {
            startParameter.setWatchFileSystemDebugLogging(value);
        }
    }

    public static class WatchFileSystemOption
    extends BooleanBuildOption<StartParameterInternal> {
        public static final String LONG_OPTION = "watch-fs";
        public static final String GRADLE_PROPERTY = "org.gradle.vfs.watch";

        public WatchFileSystemOption() {
            super(GRADLE_PROPERTY, BooleanCommandLineOptionConfiguration.create(LONG_OPTION, "Enables watching the file system for changes, allowing data about the file system to be re-used for the next build.", "Disables watching the file system."));
        }

        @Override
        public void applyTo(boolean value, StartParameterInternal startParameter, Origin origin) {
            startParameter.setWatchFileSystemMode(value ? WatchMode.ENABLED : WatchMode.DISABLED);
        }
    }

    public static class BuildCacheDebugLoggingOption
    extends BooleanBuildOption<StartParameterInternal> {
        public static final String GRADLE_PROPERTY = "org.gradle.caching.debug";

        public BuildCacheDebugLoggingOption() {
            super(GRADLE_PROPERTY);
        }

        @Override
        public void applyTo(boolean value, StartParameterInternal settings, Origin origin) {
            settings.setBuildCacheDebugLogging(value);
        }
    }

    public static class BuildCacheOption
    extends BooleanBuildOption<StartParameterInternal> {
        public static final String GRADLE_PROPERTY = "org.gradle.caching";

        public BuildCacheOption() {
            super(GRADLE_PROPERTY, BooleanCommandLineOptionConfiguration.create("build-cache", "Enables the Gradle build cache. Gradle will try to reuse outputs from previous builds.", "Disables the Gradle build cache."));
        }

        @Override
        public void applyTo(boolean value, StartParameterInternal settings, Origin origin) {
            settings.setBuildCacheEnabled(value);
        }
    }

    public static class ConfigureOnDemandOption
    extends BooleanBuildOption<StartParameterInternal> {
        public static final String GRADLE_PROPERTY = "org.gradle.configureondemand";

        public ConfigureOnDemandOption() {
            super(GRADLE_PROPERTY, BooleanCommandLineOptionConfiguration.create("configure-on-demand", "Configure necessary projects only. Gradle will attempt to reduce configuration time for large multi-project builds.", "Disables the use of configuration on demand.").incubating());
        }

        @Override
        public void applyTo(boolean value, StartParameterInternal settings, Origin origin) {
            settings.setConfigureOnDemand(value);
        }
    }

    public static class IncludeBuildOption
    extends ListBuildOption<StartParameterInternal> {
        public IncludeBuildOption() {
            super((String)null, CommandLineOptionConfiguration.create("include-build", "Include the specified build in the composite."));
        }

        @Override
        public void applyTo(List<String> values, StartParameterInternal settings, Origin origin) {
            BasicFileResolver resolver = new BasicFileResolver(settings.getCurrentDir());
            for (String includedBuild : values) {
                settings.includeBuild((File)resolver.transform(includedBuild));
            }
        }
    }

    public static class ExcludeTaskOption
    extends ListBuildOption<StartParameterInternal> {
        public ExcludeTaskOption() {
            super((String)null, CommandLineOptionConfiguration.create("exclude-task", "x", "Specify a task to be excluded from execution."));
        }

        @Override
        public void applyTo(List<String> values, StartParameterInternal settings, Origin origin) {
            settings.setExcludedTaskNames(values);
        }
    }

    public static class InitScriptOption
    extends ListBuildOption<StartParameterInternal> {
        public InitScriptOption() {
            super((String)null, CommandLineOptionConfiguration.create("init-script", "I", "Specify an initialization script."));
        }

        @Override
        public void applyTo(List<String> values, StartParameterInternal settings, Origin origin) {
            BasicFileResolver resolver = new BasicFileResolver(settings.getCurrentDir());
            for (String script : values) {
                settings.addInitScript((File)resolver.transform(script));
            }
        }
    }

    @Deprecated
    public static class SettingsFileOption
    extends StringBuildOption<StartParameterInternal> {
        public SettingsFileOption() {
            super((String)null, CommandLineOptionConfiguration.create("settings-file", "c", "Specify the settings file. [deprecated]"));
        }

        @Override
        public void applyTo(String value, StartParameterInternal settings, Origin origin) {
            BasicFileResolver resolver = new BasicFileResolver(settings.getCurrentDir());
            settings.setSettingsFile((File)resolver.transform(value));
        }
    }

    @Deprecated
    public static class BuildFileOption
    extends StringBuildOption<StartParameterInternal> {
        public BuildFileOption() {
            super((String)null, CommandLineOptionConfiguration.create("build-file", "b", "Specify the build file. [deprecated]"));
        }

        @Override
        public void applyTo(String value, StartParameterInternal settings, Origin origin) {
            BasicFileResolver resolver = new BasicFileResolver(settings.getCurrentDir());
            settings.setBuildFile((File)resolver.transform(value));
        }
    }

    public static class NoProjectDependenciesRebuildOption
    extends EnabledOnlyBooleanBuildOption<StartParameterInternal> {
        private static final String LONG_OPTION = "no-rebuild";
        private static final String SHORT_OPTION = "a";

        public NoProjectDependenciesRebuildOption() {
            super((String)null, CommandLineOptionConfiguration.create(LONG_OPTION, SHORT_OPTION, "Do not rebuild project dependencies."));
        }

        @Override
        public void applyTo(StartParameterInternal settings, Origin origin) {
            settings.setBuildProjectDependencies(false);
        }
    }

    public static class ContinuousOption
    extends EnabledOnlyBooleanBuildOption<StartParameterInternal> {
        public ContinuousOption() {
            super((String)null, CommandLineOptionConfiguration.create("continuous", "t", "Enables continuous build. Gradle does not exit and will re-execute tasks when task file inputs change."));
        }

        @Override
        public void applyTo(StartParameterInternal settings, Origin origin) {
            settings.setContinuous(true);
        }
    }

    public static class DryRunOption
    extends EnabledOnlyBooleanBuildOption<StartParameterInternal> {
        public DryRunOption() {
            super((String)null, CommandLineOptionConfiguration.create("dry-run", "m", "Run the builds with all task actions disabled."));
        }

        @Override
        public void applyTo(StartParameterInternal settings, Origin origin) {
            settings.setDryRun(true);
        }
    }

    public static class RefreshDependenciesOption
    extends EnabledOnlyBooleanBuildOption<StartParameterInternal> {
        public RefreshDependenciesOption() {
            super((String)null, CommandLineOptionConfiguration.create("refresh-dependencies", "Refresh the state of dependencies."));
        }

        @Override
        public void applyTo(StartParameterInternal settings, Origin origin) {
            settings.setRefreshDependencies(true);
        }
    }

    public static class OfflineOption
    extends EnabledOnlyBooleanBuildOption<StartParameterInternal> {
        public OfflineOption() {
            super((String)null, CommandLineOptionConfiguration.create("offline", "Execute the build without accessing network resources."));
        }

        @Override
        public void applyTo(StartParameterInternal settings, Origin origin) {
            settings.setOffline(true);
        }
    }

    public static class ContinueOption
    extends EnabledOnlyBooleanBuildOption<StartParameterInternal> {
        public static final String LONG_OPTION = "continue";

        public ContinueOption() {
            super((String)null, CommandLineOptionConfiguration.create(LONG_OPTION, "Continue task execution after a task failure."));
        }

        @Override
        public void applyTo(StartParameterInternal settings, Origin origin) {
            settings.setContinueOnFailure(true);
        }
    }

    public static class ProfileOption
    extends EnabledOnlyBooleanBuildOption<StartParameterInternal> {
        public ProfileOption() {
            super((String)null, CommandLineOptionConfiguration.create("profile", "Profile build execution time and generates a report in the <build_dir>/reports/profile directory."));
        }

        @Override
        public void applyTo(StartParameterInternal settings, Origin origin) {
            settings.setProfile(true);
        }
    }

    public static class RerunTasksOption
    extends EnabledOnlyBooleanBuildOption<StartParameterInternal> {
        public RerunTasksOption() {
            super((String)null, CommandLineOptionConfiguration.create("rerun-tasks", "Ignore previously cached task results."));
        }

        @Override
        public void applyTo(StartParameterInternal settings, Origin origin) {
            settings.setRerunTasks(true);
        }
    }

    public static class ProjectCacheDirOption
    extends StringBuildOption<StartParameterInternal> {
        public ProjectCacheDirOption() {
            super((String)null, CommandLineOptionConfiguration.create("project-cache-dir", "Specify the project-specific cache directory. Defaults to .gradle in the root project directory."));
        }

        @Override
        public void applyTo(String value, StartParameterInternal settings, Origin origin) {
            BasicFileResolver resolver = new BasicFileResolver(settings.getCurrentDir());
            settings.setProjectCacheDir((File)resolver.transform(value));
        }
    }
}

