/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.multiproject;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.daemon.common.IncrementalModuleEntry;
import org.jetbrains.kotlin.daemon.common.IncrementalModuleInfo;
import org.jetbrains.kotlin.incremental.multiproject.ModulesApiHistory;
import org.jetbrains.kotlin.incremental.multiproject.ModulesApiHistoryKt;
import org.jetbrains.kotlin.incremental.util.Either;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\b0\u00112\u0006\u0010\u0012\u001a\u00020\u0007H\u0014J\u001c\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\b0\u00112\u0006\u0010\u0014\u001a\u00020\u0007H\u0014J\"\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\b0\u00112\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\bH\u0016R6\u0010\u0005\u001a*\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\b0\u0006j\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/incremental/multiproject/ModulesApiHistoryJvm;", "Lorg/jetbrains/kotlin/incremental/multiproject/ModulesApiHistory;", "modulesInfo", "Lorg/jetbrains/kotlin/daemon/common/IncrementalModuleInfo;", "(Lorg/jetbrains/kotlin/daemon/common/IncrementalModuleInfo;)V", "dirToHistoryFileCache", "Ljava/util/HashMap;", "Ljava/io/File;", "", "Lkotlin/collections/HashMap;", "getModulesInfo", "()Lorg/jetbrains/kotlin/daemon/common/IncrementalModuleInfo;", "projectRootPath", "Ljava/nio/file/Path;", "getProjectRootPath", "()Ljava/nio/file/Path;", "getBuildHistoryFilesForJar", "Lorg/jetbrains/kotlin/incremental/util/Either;", "jar", "getBuildHistoryForDir", "file", "historyFilesForChangedFiles", "changedFiles", "incremental-compilation-impl"})
public class ModulesApiHistoryJvm
implements ModulesApiHistory {
    @NotNull
    private final Path projectRootPath;
    private final HashMap<File, Set<File>> dirToHistoryFileCache;
    @NotNull
    private final IncrementalModuleInfo modulesInfo;

    @NotNull
    protected final Path getProjectRootPath() {
        return this.projectRootPath;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Either<Set<File>> historyFilesForChangedFiles(@NotNull Set<? extends File> changedFiles) {
        Map map2;
        Object element$iv$iv;
        void $receiver$iv$iv;
        Object historyEither;
        Intrinsics.checkParameterIsNotNull(changedFiles, "changedFiles");
        HashSet result2 = new HashSet();
        ArrayList<File> jarFiles = new ArrayList<File>();
        ArrayList<File> classFiles = new ArrayList<File>();
        for (File file2 : changedFiles) {
            String extension = FilesKt.getExtension(file2);
            if (StringsKt.equals(extension, "class", true)) {
                classFiles.add(file2);
                continue;
            }
            if (!StringsKt.equals(extension, "jar", true)) continue;
            jarFiles.add(file2);
        }
        Object object = jarFiles.iterator();
        while (object.hasNext()) {
            File file3;
            File file4 = file3 = object.next();
            Intrinsics.checkExpressionValueIsNotNull(file4, "jar");
            Object object2 = historyEither = this.getBuildHistoryFilesForJar(file4);
            if (object2 instanceof Either.Success) {
                result2.addAll((Collection)((Either.Success)historyEither).getValue());
                continue;
            }
            if (!(object2 instanceof Either.Error)) continue;
            return historyEither;
        }
        Iterable $receiver$iv = classFiles;
        historyEither = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap();
        Iterator iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object object3;
            Map $receiver$iv$iv$iv = destination$iv$iv;
            element$iv$iv = iterator2.next();
            File it = (File)element$iv$iv;
            File key$iv$iv = it.getParentFile();
            Object value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                ArrayList answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object3 = answer$iv$iv$iv;
            } else {
                object3 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object3;
            list$iv$iv.add(element$iv$iv);
        }
        destination$iv$iv = map2 = destination$iv$iv;
        Iterator iterator3 = destination$iv$iv.entrySet().iterator();
        while (iterator3.hasNext()) {
            Either<Set<File>> historyEither2;
            element$iv$iv = object = iterator3.next();
            File dir = (File)element$iv$iv.getKey();
            element$iv$iv = object;
            List files2 = (List)element$iv$iv.getValue();
            File file5 = dir;
            Intrinsics.checkExpressionValueIsNotNull(file5, "dir");
            Either<Set<File>> either = historyEither2 = this.getBuildHistoryForDir(file5);
            if (either instanceof Either.Success) {
                result2.addAll((Collection)((Either.Success)historyEither2).getValue());
                continue;
            }
            if (!(either instanceof Either.Error)) continue;
            return historyEither2;
        }
        return new Either.Success(result2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    protected Either<Set<File>> getBuildHistoryForDir(@NotNull File file2) {
        Object object;
        Intrinsics.checkParameterIsNotNull(file2, "file");
        Map $receiver$iv = this.dirToHistoryFileCache;
        Object value$iv = $receiver$iv.get(file2);
        if (value$iv == null) {
            Set set;
            IncrementalModuleEntry module2 = this.modulesInfo.getDirToModule().get(file2);
            File parent2 = file2.getParentFile();
            if (module2 != null) {
                set = SetsKt.setOf(module2.getBuildHistoryFile());
            } else {
                if (parent2 == null || !ModulesApiHistoryKt.access$isParentOf(this.projectRootPath, parent2)) return new Either.Error("Unable to get build history for " + file2);
                Either<Set<File>> parentHistory = this.getBuildHistoryForDir(parent2);
                Either<Set<File>> either = parentHistory;
                if (either instanceof Either.Success) {
                    set = (Set)((Either.Success)parentHistory).getValue();
                } else {
                    if (!(either instanceof Either.Error)) throw new NoWhenBranchMatchedException();
                    return parentHistory;
                }
            }
            Set answer$iv = set;
            $receiver$iv.put(file2, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        Set history = (Set)object;
        return new Either.Success<Set>(history);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected Either<Set<File>> getBuildHistoryFilesForJar(@NotNull File jar) {
        Object it;
        Iterable classFiles;
        Iterable $receiver$iv2;
        Object item$iv$iv22;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(jar, "jar");
        File file2 = this.modulesInfo.getJarToClassListFile().get(jar);
        if (file2 == null) {
            return new Either.Error("Unknown jar: " + jar);
        }
        File classListFile = file2;
        if (!classListFile.isFile()) {
            return new Either.Error("Class list file does not exist " + classListFile);
        }
        try {
            void $receiver$iv$iv2;
            CharSequence charSequence = FilesKt.readText$default(classListFile, null, 1, null);
            String[] stringArray = new String[1];
            String string = File.pathSeparator;
            Intrinsics.checkExpressionValueIsNotNull(string, "File.pathSeparator");
            stringArray[0] = string;
            Iterable iterable = $receiver$iv = (Iterable)StringsKt.split$default(charSequence, stringArray, false, 0, 6, null);
            Collection entry = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
            for (Object item$iv$iv22 : $receiver$iv$iv2) {
                void p1;
                String string2 = (String)item$iv$iv22;
                Collection collection = entry;
                File file3 = new File((String)p1);
                collection.add(file3);
            }
            $receiver$iv = (List)entry;
        }
        catch (Throwable t) {
            return new Either.Error("Could not read class list for " + jar + " from " + classListFile + ": " + t);
        }
        Iterable iterable = $receiver$iv2 = (classFiles = $receiver$iv);
        Map destination$iv$iv2 = new LinkedHashMap();
        item$iv$iv22 = iterable.iterator();
        while (item$iv$iv22.hasNext()) {
            Object object;
            Map $receiver$iv$iv$iv = destination$iv$iv2;
            Object element$iv$iv = item$iv$iv22.next();
            it = (File)element$iv$iv;
            File key$iv$iv = ((File)it).getParentFile();
            Object value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                ArrayList answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map classFileDirs = destination$iv$iv2;
        HashSet result2 = new HashSet();
        item$iv$iv22 = classFileDirs;
        for (Map.Entry entry : item$iv$iv22.entrySet()) {
            Either<Set<File>> historyEither;
            it = entry;
            File dir = (File)it.getKey();
            it = entry;
            List files2 = (List)it.getValue();
            File file4 = dir;
            Intrinsics.checkExpressionValueIsNotNull(file4, "dir");
            Either<Set<File>> either = historyEither = this.getBuildHistoryForDir(file4);
            if (either instanceof Either.Success) {
                result2.addAll((Collection)((Either.Success)historyEither).getValue());
                continue;
            }
            if (!(either instanceof Either.Error)) continue;
            return historyEither;
        }
        return new Either.Success(result2);
    }

    @NotNull
    protected final IncrementalModuleInfo getModulesInfo() {
        return this.modulesInfo;
    }

    public ModulesApiHistoryJvm(@NotNull IncrementalModuleInfo modulesInfo) {
        Intrinsics.checkParameterIsNotNull(modulesInfo, "modulesInfo");
        this.modulesInfo = modulesInfo;
        Path path2 = Paths.get(this.modulesInfo.getProjectRoot().getAbsolutePath(), new String[0]);
        Intrinsics.checkExpressionValueIsNotNull(path2, "Paths.get(modulesInfo.projectRoot.absolutePath)");
        this.projectRootPath = path2;
        this.dirToHistoryFileCache = new HashMap();
    }
}

