/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.resolve.constants.ByteValue;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.IntValue;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstructor;
import org.jetbrains.kotlin.resolve.constants.LongValue;
import org.jetbrains.kotlin.resolve.constants.ShortValue;
import org.jetbrains.kotlin.resolve.constants.UByteValue;
import org.jetbrains.kotlin.resolve.constants.UIntValue;
import org.jetbrains.kotlin.resolve.constants.ULongValue;
import org.jetbrains.kotlin.resolve.constants.UShortValue;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0096\u0002J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u0016H\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/resolve/constants/IntegerValueTypeConstant;", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "", "value", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "parameters", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant$Parameters;", "(Ljava/lang/Number;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant$Parameters;)V", "getParameters", "()Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant$Parameters;", "typeConstructor", "Lorg/jetbrains/kotlin/resolve/constants/IntegerValueTypeConstructor;", "unknownIntegerType", "Lorg/jetbrains/kotlin/types/SimpleType;", "getUnknownIntegerType", "()Lorg/jetbrains/kotlin/types/SimpleType;", "equals", "", "other", "", "getType", "Lorg/jetbrains/kotlin/types/KotlinType;", "expectedType", "hashCode", "", "toConstantValue", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "toString", "", "descriptors"})
public final class IntegerValueTypeConstant
implements CompileTimeConstant<Number> {
    private final IntegerValueTypeConstructor typeConstructor;
    @NotNull
    private final SimpleType unknownIntegerType;
    private final Number value;
    @NotNull
    private final CompileTimeConstant.Parameters parameters;

    @Override
    @NotNull
    public ConstantValue<Number> toConstantValue(@NotNull KotlinType expectedType) {
        Intrinsics.checkParameterIsNotNull(expectedType, "expectedType");
        KotlinType type2 = this.getType(expectedType);
        return KotlinBuiltIns.isInt(type2) ? (ConstantValue)new IntValue(this.value.intValue()) : (KotlinBuiltIns.isByte(type2) ? (ConstantValue)new ByteValue(this.value.byteValue()) : (KotlinBuiltIns.isShort(type2) ? (ConstantValue)new ShortValue(this.value.shortValue()) : (KotlinBuiltIns.isLong(type2) ? (ConstantValue)new LongValue(this.value.longValue()) : (KotlinBuiltIns.isUInt(type2) ? (ConstantValue)new UIntValue(this.value.intValue()) : (KotlinBuiltIns.isUByte(type2) ? (ConstantValue)new UByteValue(this.value.byteValue()) : (KotlinBuiltIns.isUShort(type2) ? (ConstantValue)new UShortValue(this.value.shortValue()) : (KotlinBuiltIns.isULong(type2) ? (ConstantValue)new ULongValue(this.value.longValue()) : (ConstantValue)new LongValue(this.value.longValue()))))))));
    }

    @NotNull
    public final SimpleType getUnknownIntegerType() {
        return this.unknownIntegerType;
    }

    @NotNull
    public final KotlinType getType(@NotNull KotlinType expectedType) {
        Intrinsics.checkParameterIsNotNull(expectedType, "expectedType");
        KotlinType kotlinType = TypeUtils.getPrimitiveNumberType(this.typeConstructor, expectedType);
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "TypeUtils.getPrimitiveNu\u2026onstructor, expectedType)");
        return kotlinType;
    }

    @NotNull
    public String toString() {
        return this.typeConstructor.toString();
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof IntegerValueTypeConstant && Intrinsics.areEqual(this.value, ((IntegerValueTypeConstant)other).value);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    @NotNull
    public CompileTimeConstant.Parameters getParameters() {
        return this.parameters;
    }

    public IntegerValueTypeConstant(@NotNull Number value, @NotNull ModuleDescriptor module2, @NotNull CompileTimeConstant.Parameters parameters2) {
        Intrinsics.checkParameterIsNotNull(value, "value");
        Intrinsics.checkParameterIsNotNull(module2, "module");
        Intrinsics.checkParameterIsNotNull(parameters2, "parameters");
        this.value = value;
        this.parameters = parameters2;
        this.typeConstructor = new IntegerValueTypeConstructor(this.value.longValue(), module2, this.getParameters());
        Annotations annotations2 = Annotations.Companion.getEMPTY();
        TypeConstructor typeConstructor2 = this.typeConstructor;
        List list2 = CollectionsKt.emptyList();
        MemberScope memberScope2 = ErrorUtils.createErrorScope("Scope for number value type (" + this.typeConstructor + ')', true);
        Intrinsics.checkExpressionValueIsNotNull(memberScope2, "ErrorUtils.createErrorSc\u2026$typeConstructor)\", true)");
        this.unknownIntegerType = KotlinTypeFactory.simpleTypeWithNonTrivialMemberScope(annotations2, typeConstructor2, list2, false, memberScope2);
    }

    @Override
    public boolean isError() {
        return CompileTimeConstant.DefaultImpls.isError(this);
    }

    @Override
    @NotNull
    public Number getValue(@NotNull KotlinType expectedType) {
        Intrinsics.checkParameterIsNotNull(expectedType, "expectedType");
        return CompileTimeConstant.DefaultImpls.getValue(this, expectedType);
    }

    @Override
    public boolean getCanBeUsedInAnnotations() {
        return CompileTimeConstant.DefaultImpls.getCanBeUsedInAnnotations(this);
    }

    @Override
    public boolean getUsesVariableAsConstant() {
        return CompileTimeConstant.DefaultImpls.getUsesVariableAsConstant(this);
    }

    @Override
    public boolean getUsesNonConstValAsConstant() {
        return CompileTimeConstant.DefaultImpls.getUsesNonConstValAsConstant(this);
    }

    @Override
    public boolean isPure() {
        return CompileTimeConstant.DefaultImpls.isPure(this);
    }

    @Override
    public boolean isUnsignedNumberLiteral() {
        return CompileTimeConstant.DefaultImpls.isUnsignedNumberLiteral(this);
    }
}

