/*
 * Decompiled with CFR 0.152.
 */
package javax.bluetooth;

import java.util.Vector;
import javax.bluetooth.UUID;

public class DataElement {
    public static final int NULL = 0;
    public static final int U_INT_1 = 8;
    public static final int U_INT_2 = 9;
    public static final int U_INT_4 = 10;
    public static final int U_INT_8 = 11;
    public static final int U_INT_16 = 12;
    public static final int INT_1 = 16;
    public static final int INT_2 = 17;
    public static final int INT_4 = 18;
    public static final int INT_8 = 19;
    public static final int INT_16 = 20;
    public static final int URL = 64;
    public static final int UUID = 24;
    public static final int BOOL = 40;
    public static final int STRING = 32;
    public static final int DATSEQ = 48;
    public static final int DATALT = 56;
    private Object value;
    private int valueType;

    public DataElement(int valueType) {
        switch (valueType) {
            case 0: {
                this.value = null;
                break;
            }
            case 48: 
            case 56: {
                this.value = new Vector();
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.valueType = valueType;
    }

    public DataElement(boolean bool) {
        this.value = bool ? Boolean.TRUE : Boolean.FALSE;
        this.valueType = 40;
    }

    public DataElement(int valueType, long value) {
        switch (valueType) {
            case 8: {
                if (value >= 0L && value <= 255L) break;
                throw new IllegalArgumentException(value + " not U_INT_1");
            }
            case 9: {
                if (value >= 0L && value <= 65535L) break;
                throw new IllegalArgumentException(value + " not U_INT_2");
            }
            case 10: {
                if (value >= 0L && value <= 0xFFFFFFFFL) break;
                throw new IllegalArgumentException(value + " not U_INT_4");
            }
            case 16: {
                if (value >= -128L && value <= 127L) break;
                throw new IllegalArgumentException(value + " not INT_1");
            }
            case 17: {
                if (value >= -32768L && value <= 32767L) break;
                throw new IllegalArgumentException(value + " not INT_2");
            }
            case 18: {
                if (value >= Integer.MIN_VALUE && value <= Integer.MAX_VALUE) break;
                throw new IllegalArgumentException(value + " not INT_4");
            }
            case 19: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.value = new Long(value);
        this.valueType = valueType;
    }

    public DataElement(int valueType, Object value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        switch (valueType) {
            case 32: 
            case 64: {
                if (value instanceof String) break;
                throw new IllegalArgumentException();
            }
            case 24: {
                if (value instanceof UUID) break;
                throw new IllegalArgumentException();
            }
            case 11: {
                if (value instanceof byte[] && ((byte[])value).length == 8) break;
                throw new IllegalArgumentException();
            }
            case 12: 
            case 20: {
                if (value instanceof byte[] && ((byte[])value).length == 16) break;
                throw new IllegalArgumentException();
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.value = value;
        this.valueType = valueType;
    }

    public void addElement(DataElement elem) {
        if (elem == null) {
            throw new NullPointerException();
        }
        switch (this.valueType) {
            case 48: 
            case 56: {
                ((Vector)this.value).addElement(elem);
                break;
            }
            default: {
                throw new ClassCastException();
            }
        }
    }

    public void insertElementAt(DataElement elem, int index) {
        if (elem == null) {
            throw new NullPointerException();
        }
        switch (this.valueType) {
            case 48: 
            case 56: {
                ((Vector)this.value).insertElementAt(elem, index);
                break;
            }
            default: {
                throw new ClassCastException();
            }
        }
    }

    public int getSize() {
        switch (this.valueType) {
            case 48: 
            case 56: {
                return ((Vector)this.value).size();
            }
        }
        throw new ClassCastException();
    }

    public boolean removeElement(DataElement elem) {
        if (elem == null) {
            throw new NullPointerException();
        }
        switch (this.valueType) {
            case 48: 
            case 56: {
                return ((Vector)this.value).removeElement(elem);
            }
        }
        throw new ClassCastException();
    }

    public int getDataType() {
        return this.valueType;
    }

    public long getLong() {
        switch (this.valueType) {
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                return (Long)this.value;
            }
        }
        throw new ClassCastException();
    }

    public boolean getBoolean() {
        if (this.valueType == 40) {
            return (Boolean)this.value;
        }
        throw new ClassCastException();
    }

    public Object getValue() {
        return null;
    }
}

