/*****************************************************************************
 * Copyright (c) 2014-2020 OpenRCT2 developers
 *
 * For a complete list of all authors, please refer to contributors.md
 * Interested in contributing? Visit https://github.com/OpenRCT2/OpenRCT2
 *
 * OpenRCT2 is licensed under the GNU General Public License version 3.
 *****************************************************************************/

#pragma once

#include "../world/Scenery.h"
#include "Object.h"

#include <vector>

struct ObjectRepositoryItem;

enum class EntertainerCostume : uint8_t;

class SceneryGroupObject final : public Object
{
private:
    rct_scenery_group_entry _legacyType = {};
    std::vector<ObjectEntryDescriptor> _items;

public:
    explicit SceneryGroupObject(const rct_object_entry& entry)
        : Object(entry)
    {
    }

    void* GetLegacyData() override
    {
        return &_legacyType;
    }
    void ReadJson(IReadObjectContext* context, json_t& root) override;

    void ReadLegacy(IReadObjectContext* context, OpenRCT2::IStream* stream) override;
    void Load() override;
    void Unload() override;
    void UpdateEntryIndexes();

    void DrawPreview(rct_drawpixelinfo* dpi, int32_t width, int32_t height) const override;

    void SetRepositoryItem(ObjectRepositoryItem* item) const override;

private:
    static std::vector<ObjectEntryDescriptor> ReadItems(OpenRCT2::IStream* stream);
    static uint32_t ReadJsonEntertainerCostumes(json_t& jCostumes);
    static EntertainerCostume ParseEntertainerCostume(const std::string& s);
    static std::vector<ObjectEntryDescriptor> ReadJsonEntries(json_t& jEntries);
};
