/* PgSqlClient - ADO.NET Data Provider for PostgreSQL 7.4+
 * Copyright (c) 2003-2004 Carlos Guzman Alvarez
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

using System;
using System.Data;
using System.Text;

namespace PostgreSql.Data.PgSqlClient.DbSchema
{
	internal class PgCastsSchema : PgAbstractDbSchema
	{
		#region Constructors

		public PgCastsSchema() : base("Casts")
		{
		}

		#endregion

		#region Add Methods

		public override void AddTables()
		{
			AddTable("pg_cast");
		}

		public override void AddRestrictionColumns()
		{
		}

		public override void AddDataColumns()
		{
			AddDataColumn("pg_typesrc.typname"	, "SOURCE_TYPE");
			AddDataColumn("pg_typetgt.typname"	, "TARGET_TYPE");
			AddDataColumn("pg_namespace.nspname", "FUNCTION_SCHEMA");
			AddDataColumn("pg_proc.proname"		, "FUNCTION_NAME");
			AddDataColumn(getContextExpression("pg_cast.castcontext"), "CAST_CONTEXT");
		}

		public override void AddJoins()
		{
			AddJoin("left join", "pg_type as pg_typesrc", "pg_cast.castsource = pg_typesrc.oid");
			AddJoin("left join", "pg_type as pg_typetgt", "pg_cast.casttarget = pg_typetgt.oid");
			AddJoin("left join", "pg_proc"				, "pg_cast.castfunc = pg_proc.oid");			
			AddJoin("left join", "pg_namespace"			, "pg_proc.pronamespace = pg_namespace.oid");			
		}

		public override void AddOrderByColumns()
		{
			AddOrderBy("pg_proc.proname");
		}

		public override void AddWhereFilters()
		{			
		}

		#endregion

		#region Parse Methods

		public override object[] ParseRestrictions(object[] restrictions)
		{
			object[] parsed = restrictions;

			return parsed;
		}

		#endregion

		#region Private Methods

		private string getContextExpression(string fieldName)
		{
			StringBuilder expression = new StringBuilder();

			expression.AppendFormat(" case {0} ", fieldName);
			expression.Append(" when 'e' THEN 'EXPLICIT'");
			expression.Append(" when 'a' THEN 'ASSIGNMENT'");
			expression.Append(" when 'i' THEN 'EXPRESSIONS'");
			expression.Append(" END ");

			return expression.ToString();
		}

		#endregion
	}
}