/* PgSqlClient - ADO.NET Data Provider for PostgreSQL 7.4+
 * Copyright (c) 2003-2004 Carlos Guzman Alvarez
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

using System;
using System.Data;
using System.Collections;
using System.Globalization;

namespace PostgreSql.Data.NPgClient
{
	internal class PgTypeCollection : ArrayList
	{
		#region Properties

		public new PgType this[int oid]
		{
			get { return (PgType)base[IndexOf(oid)]; }
			set { base[IndexOf(oid)] = (PgType)value; }
		}

		public PgType this[string name] 
		{
			get { return (PgType)this[IndexOf(name)]; }
			set { this[IndexOf(name)] = (PgType)value; }
		}

		public PgType this[DbType systemType] 
		{
			get { return (PgType)this[IndexOf(systemType)]; }
			set { this[IndexOf(systemType)] = (PgType)value; }
		}

		#endregion

		#region Methods
	
		public bool Contains(int oid)
		{
			return(-1 != IndexOf(oid));
		}
		
		public int IndexOf(int oid)
		{
			int index = 0;
			foreach(PgType item in this)
			{
				if (item.Oid == oid)
				{
					return index;
				}
				index++;
			}
			return -1;
		}

		public int IndexOf(string name)
		{
			int index = 0;
			foreach(PgType item in this)
			{
				if (cultureAwareCompare(item.Name, name))
				{
					return index;
				}
				index++;
			}
			return -1;
		}

		public void RemoveAt(string typeName)
		{
			RemoveAt(IndexOf(typeName));
		}

		public PgType Add(PgType type)
		{
			base.Add(type);

			return type;
		}

		public PgType Add(int oid, string name, PgDataType dataType, int elementType, short formatCode, int size)
		{
			PgType type = new PgType(oid, name, dataType, elementType, formatCode, size);

			base.Add(type);

			return type;
		}
		
		private bool cultureAwareCompare(string strA, string strB)
		{
			return CultureInfo.CurrentCulture.CompareInfo.Compare(
				strA, 
				strB, 
				CompareOptions.IgnoreKanaType | CompareOptions.IgnoreWidth | 
				CompareOptions.IgnoreCase) == 0 ? true : false;
		}

		#endregion
	}
}
