/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.codeActions;

import apex.jorje.lsp.api.document.Document;
import apex.jorje.lsp.api.services.ApexCompilerService;
import apex.jorje.lsp.api.visitors.VisitorFactory;
import apex.jorje.lsp.api.workspace.ApexDocumentService;
import apex.jorje.lsp.impl.codeActions.BaseCodeActionsProvider;
import apex.jorje.lsp.impl.document.BadLocationException;
import apex.jorje.lsp.impl.telemetry.TelemetryData;
import apex.jorje.lsp.impl.utils.Locations;
import apex.jorje.lsp.impl.visitors.CodeActionScope;
import apex.jorje.lsp.impl.visitors.CodeActionVisitor;
import apex.jorje.semantic.compiler.CodeUnit;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class ApexCodeActionsProvider
extends BaseCodeActionsProvider {
    private static final String TELEMETRY_NAME = "ApexCodeActions";

    @Inject
    public ApexCodeActionsProvider(ApexCompilerService compilerService, ApexDocumentService documentService, VisitorFactory visitorFactory) {
        super(compilerService, documentService, visitorFactory);
    }

    @Override
    protected List<Either<Command, CodeAction>> getCodeActions(Document doc, Range range, TelemetryData telemetryData) throws BadLocationException {
        Stopwatch stopwatch = Stopwatch.createStarted();
        int startOffset = Locations.getOffset(doc, range.getStart());
        int endOffset = Locations.getOffset(doc, range.getEnd());
        CodeActionVisitor visitor = this.visitorFactory.createCodeActionVisitor();
        CodeActionScope scope = new CodeActionScope(startOffset, endOffset, doc);
        CodeUnit unit = this.compilerService.compile(doc);
        unit.getNode().traverse(visitor, scope);
        stopwatch.stop();
        this.setTelemetryData(scope, telemetryData, stopwatch);
        if (scope.getNode().isPresent()) {
            return scope.getCodeActions().stream().map(Either::forRight).collect(Collectors.toList());
        }
        return ImmutableList.of();
    }

    private void setTelemetryData(CodeActionScope scope, TelemetryData telemetryData, Stopwatch stopwatch) {
        if (!scope.getCodeActions().isEmpty()) {
            telemetryData.add("CodeActionName", TELEMETRY_NAME);
            telemetryData.addExecutionTime(stopwatch.elapsed(TimeUnit.MILLISECONDS));
        }
    }
}

