/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.design;

import net.sourceforge.pmd.lang.apex.ast.ASTFieldDeclarationStatements;
import net.sourceforge.pmd.lang.apex.ast.ASTMethod;
import net.sourceforge.pmd.lang.apex.ast.ASTUserClass;
import net.sourceforge.pmd.lang.apex.rule.design.ExcessiveNodeCountRule;
import net.sourceforge.pmd.properties.MultiValuePropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.util.NumericConstants;

public class ExcessivePublicCountRule
extends ExcessiveNodeCountRule {
    public ExcessivePublicCountRule() {
        super(ASTUserClass.class);
        this.setProperty((PropertyDescriptor)MINIMUM_DESCRIPTOR, 20.0);
        this.setProperty((MultiValuePropertyDescriptor)CODECLIMATE_CATEGORIES, new String[]{"Complexity"});
        this.setProperty((PropertyDescriptor)CODECLIMATE_REMEDIATION_MULTIPLIER, 150);
        this.setProperty((PropertyDescriptor)CODECLIMATE_BLOCK_HIGHLIGHTING, false);
    }

    @Override
    public Object visit(ASTMethod node, Object data) {
        if (node.getModifiers().isPublic() && !node.getImage().matches("<clinit>|<init>|clone")) {
            return NumericConstants.ONE;
        }
        return NumericConstants.ZERO;
    }

    @Override
    public Object visit(ASTFieldDeclarationStatements node, Object data) {
        if (node.getModifiers().isPublic() && !node.getModifiers().isStatic()) {
            return NumericConstants.ONE;
        }
        return NumericConstants.ZERO;
    }
}

