/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.codeLens;

import apex.jorje.lsp.api.codeLenses.CodeLensProvider;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.CodeLensParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeLensesProviderAggregator
implements CodeLensProvider {
    private static final Logger logger = LoggerFactory.getLogger(CodeLensesProviderAggregator.class);
    private final Set<CodeLensProvider> codeLensProviders;

    @Inject
    public CodeLensesProviderAggregator(Set<CodeLensProvider> codeLensProviders) {
        this.codeLensProviders = codeLensProviders;
    }

    @Override
    public List<? extends CodeLens> provideCodeLenses(CodeLensParams codeLensParams) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        LinkedList cmds = Lists.newLinkedList();
        this.codeLensProviders.forEach(codeLensProvider -> {
            try {
                cmds.addAll(codeLensProvider.provideCodeLenses(codeLensParams));
            }
            catch (Exception e) {
                logger.error(String.format("Encountered an error with code lens provider %s", codeLensProvider), (Throwable)e);
            }
        });
        stopwatch.stop();
        logger.info("CodeLens for {} took {} ms.", (Object)codeLensParams.getTextDocument().getUri(), (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        return cmds;
    }
}

