/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.services;

import apex.jorje.lsp.api.codeActions.CodeActionsProvider;
import apex.jorje.lsp.api.codeLenses.CodeLensProvider;
import apex.jorje.lsp.api.completions.CompletionStrategy;
import apex.jorje.lsp.api.definition.DefinitionStrategy;
import apex.jorje.lsp.api.document.Document;
import apex.jorje.lsp.api.document.DocumentLifecycleHandler;
import apex.jorje.lsp.api.hover.HoverProvider;
import apex.jorje.lsp.api.references.ReferenceStrategy;
import apex.jorje.lsp.api.rename.RenameProvider;
import apex.jorje.lsp.api.services.ApexCompilerService;
import apex.jorje.lsp.api.telemetry.TelemetryHandler;
import apex.jorje.lsp.api.visitors.VisitorFactory;
import apex.jorje.lsp.api.workspace.ApexDocumentService;
import apex.jorje.lsp.impl.completions.soql.SoqlCompletionStrategy;
import apex.jorje.lsp.impl.telemetry.TelemetryData;
import apex.jorje.lsp.impl.utils.SourceFiles;
import apex.jorje.lsp.impl.visitors.StandardDocumentSymbolVisitor;
import apex.jorje.semantic.compiler.CodeUnit;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.inject.Singleton;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.CodeLensParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.DocumentFormattingParams;
import org.eclipse.lsp4j.DocumentHighlight;
import org.eclipse.lsp4j.DocumentOnTypeFormattingParams;
import org.eclipse.lsp4j.DocumentRangeFormattingParams;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.ReferenceParams;
import org.eclipse.lsp4j.RenameParams;
import org.eclipse.lsp4j.SignatureHelp;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.CompletableFutures;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.TextDocumentService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class StandardTextDocumentService
implements TextDocumentService {
    private static final Logger logger = LoggerFactory.getLogger(StandardTextDocumentService.class);
    private final ApexDocumentService sourceService;
    private final ApexCompilerService compilerService;
    private final DocumentLifecycleHandler documentHandler;
    private final DefinitionStrategy definitionStrategy;
    private final ReferenceStrategy referenceStrategy;
    private final VisitorFactory visitorFactory;
    private final CompletionStrategy completionAggregator;
    private final CodeActionsProvider codeActionProvider;
    private final CodeLensProvider codeLensProvider;
    private final RenameProvider renameProvider;
    private final HoverProvider hoverProvider;
    private final SoqlCompletionStrategy soqlCompletionStrategy;
    private final TelemetryHandler telemetryHandler;

    @Inject
    public StandardTextDocumentService(ApexDocumentService sourceService, ApexCompilerService compilerService, DocumentLifecycleHandler documentHandler, CompletionStrategy completionAggregator, SoqlCompletionStrategy soqlCompletionStrategy, DefinitionStrategy definitionStrategy, ReferenceStrategy referenceStrategy, VisitorFactory visitorFactory, CodeActionsProvider codeActionProvider, CodeLensProvider codeLensProvider, RenameProvider renameProvider, HoverProvider hoverProvider, TelemetryHandler telemetryHandler) {
        this.sourceService = sourceService;
        this.compilerService = compilerService;
        this.documentHandler = documentHandler;
        this.completionAggregator = completionAggregator;
        this.definitionStrategy = definitionStrategy;
        this.referenceStrategy = referenceStrategy;
        this.visitorFactory = visitorFactory;
        this.codeActionProvider = codeActionProvider;
        this.codeLensProvider = codeLensProvider;
        this.renameProvider = renameProvider;
        this.hoverProvider = hoverProvider;
        this.soqlCompletionStrategy = soqlCompletionStrategy;
        this.telemetryHandler = telemetryHandler;
    }

    public CompletableFuture<Either<List<CompletionItem>, CompletionList>> completion(CompletionParams params) {
        logger.info("Completion requested for {} at {}", (Object)params.getTextDocument().getUri(), (Object)params.getPosition());
        return CompletableFutures.computeAsync(cancelChecker -> {
            Stopwatch stopwatch = Stopwatch.createStarted();
            TelemetryData telemetryData = new TelemetryData("Completion");
            try {
                if (SourceFiles.isSoql(params.getTextDocument().getUri())) {
                    Either either = Either.forRight((Object)new CompletionList(false, this.soqlCompletionStrategy.provideCompletions((TextDocumentPositionParams)params)));
                    return either;
                }
                Either either = Either.forRight((Object)new CompletionList(false, this.completionAggregator.provideCompletions((TextDocumentPositionParams)params)));
                return either;
            }
            catch (Exception e) {
                telemetryData.add(e);
            }
            finally {
                stopwatch.stop();
                telemetryData.addExecutionTime(stopwatch.elapsed(TimeUnit.MILLISECONDS));
                this.telemetryHandler.send(telemetryData);
            }
            return Either.forLeft(ImmutableList.of());
        });
    }

    @Nullable
    public CompletableFuture<CompletionItem> resolveCompletionItem(CompletionItem completionItem) {
        return null;
    }

    @Nullable
    public CompletableFuture<Hover> hover(TextDocumentPositionParams params) {
        logger.info("Hover requested for {} at {}", (Object)params.getTextDocument().getUri(), (Object)params.getPosition());
        return CompletableFutures.computeAsync(cancelChecker -> {
            Stopwatch stopwatch = Stopwatch.createStarted();
            TelemetryData telemetryData = new TelemetryData("Hover");
            try {
                Hover hover = this.hoverProvider.provideHover(params);
                return hover;
            }
            catch (Exception e) {
                telemetryData.add(e);
            }
            finally {
                stopwatch.stop();
                telemetryData.addExecutionTime(stopwatch.elapsed(TimeUnit.MILLISECONDS));
                this.telemetryHandler.send(telemetryData);
            }
            return new Hover();
        });
    }

    @Nullable
    public CompletableFuture<SignatureHelp> signatureHelp(TextDocumentPositionParams textDocumentPositionParams) {
        return null;
    }

    public CompletableFuture<List<? extends Location>> definition(TextDocumentPositionParams params) {
        logger.info("Definition requested for {} at {}", (Object)params.getTextDocument().getUri(), (Object)params.getPosition());
        return CompletableFutures.computeAsync(cancelChecker -> {
            Stopwatch stopwatch = Stopwatch.createStarted();
            TelemetryData telemetryData = new TelemetryData("Definition");
            try {
                List<? extends Location> list = this.definitionStrategy.provideDefinition(params);
                return list;
            }
            catch (Exception e) {
                telemetryData.add(e);
            }
            finally {
                stopwatch.stop();
                telemetryData.addExecutionTime(stopwatch.elapsed(TimeUnit.MILLISECONDS));
                this.telemetryHandler.send(telemetryData);
            }
            return ImmutableList.of();
        });
    }

    public CompletableFuture<List<? extends Location>> references(ReferenceParams referenceParams) {
        logger.info("References requested for {} at {}", (Object)referenceParams.getTextDocument().getUri(), (Object)referenceParams.getPosition());
        return CompletableFutures.computeAsync(cancelChecker -> {
            Stopwatch stopwatch = Stopwatch.createStarted();
            TelemetryData telemetryData = new TelemetryData("References");
            try {
                List<? extends Location> list = this.referenceStrategy.provideReferences((TextDocumentPositionParams)referenceParams);
                return list;
            }
            catch (Exception e) {
                telemetryData.add(e);
            }
            finally {
                stopwatch.stop();
                telemetryData.addExecutionTime(stopwatch.elapsed(TimeUnit.MILLISECONDS));
                this.telemetryHandler.send(telemetryData);
            }
            return ImmutableList.of();
        });
    }

    @Nullable
    public CompletableFuture<List<? extends DocumentHighlight>> documentHighlight(TextDocumentPositionParams textDocumentPositionParams) {
        return null;
    }

    public CompletableFuture<List<Either<SymbolInformation, DocumentSymbol>>> documentSymbol(DocumentSymbolParams params) {
        URI uri = URI.create(params.getTextDocument().getUri());
        Optional<Document> optDoc = this.sourceService.retrieve(uri);
        ArrayList symbols = new ArrayList();
        if (optDoc.isPresent()) {
            Document doc = optDoc.get();
            StandardDocumentSymbolVisitor visitor = this.generateDocumentSymbols(uri, doc);
            return CompletableFuture.supplyAsync(() -> {
                Stopwatch stopwatch = Stopwatch.createStarted();
                TelemetryData telemetryData = new TelemetryData("Definition");
                try {
                    List list = visitor.getSymbolInformation().stream().map(s -> Either.forLeft((Object)s)).collect(Collectors.toList());
                    return list;
                }
                catch (Exception e) {
                    telemetryData.add(e);
                }
                finally {
                    stopwatch.stop();
                    telemetryData.addExecutionTime(stopwatch.elapsed(TimeUnit.MILLISECONDS));
                    this.telemetryHandler.send(telemetryData);
                }
                return ImmutableList.of();
            });
        }
        return CompletableFuture.completedFuture(symbols.stream().map(s -> Either.forLeft((Object)s)).collect(Collectors.toList()));
    }

    @Nullable
    public CompletableFuture<List<Either<Command, CodeAction>>> codeAction(CodeActionParams codeActionParams) {
        logger.info("CodeActions requested for {} at {}", (Object)codeActionParams.getTextDocument().getUri(), (Object)codeActionParams.getRange());
        return CompletableFutures.computeAsync(cancelChecker -> {
            Stopwatch stopwatch = Stopwatch.createStarted();
            TelemetryData telemetryData = new TelemetryData("CodeAction");
            try {
                List<Either<Command, CodeAction>> list = this.codeActionProvider.provideCodeActions(codeActionParams, telemetryData);
                return list;
            }
            catch (Exception e) {
                telemetryData.add(e);
            }
            finally {
                stopwatch.stop();
                telemetryData.addExecutionTime(stopwatch.elapsed(TimeUnit.MILLISECONDS));
                this.telemetryHandler.send(telemetryData);
            }
            return ImmutableList.of();
        });
    }

    @Nullable
    public CompletableFuture<List<? extends CodeLens>> codeLens(CodeLensParams codeLensParams) {
        logger.info("CodeLens requested for {}", (Object)codeLensParams.getTextDocument().getUri());
        return CompletableFutures.computeAsync(cancelChecker -> {
            Stopwatch stopwatch = Stopwatch.createStarted();
            TelemetryData telemetryData = new TelemetryData("CodeLens");
            try {
                List<? extends CodeLens> list = this.codeLensProvider.provideCodeLenses(codeLensParams);
                return list;
            }
            catch (Exception e) {
                telemetryData.add(e);
            }
            finally {
                stopwatch.stop();
                telemetryData.addExecutionTime(stopwatch.elapsed(TimeUnit.MILLISECONDS));
                this.telemetryHandler.send(telemetryData);
            }
            return ImmutableList.of();
        });
    }

    @Nullable
    public CompletableFuture<CodeLens> resolveCodeLens(CodeLens codeLens) {
        return null;
    }

    @Nullable
    public CompletableFuture<List<? extends TextEdit>> formatting(DocumentFormattingParams documentFormattingParams) {
        return null;
    }

    @Nullable
    public CompletableFuture<List<? extends TextEdit>> rangeFormatting(DocumentRangeFormattingParams documentRangeFormattingParams) {
        return null;
    }

    @Nullable
    public CompletableFuture<List<? extends TextEdit>> onTypeFormatting(DocumentOnTypeFormattingParams documentOnTypeFormattingParams) {
        return null;
    }

    @Nullable
    public CompletableFuture<WorkspaceEdit> rename(RenameParams params) {
        logger.info("Rename requested for {} at {}", (Object)params.getTextDocument().getUri(), (Object)params.getPosition());
        return CompletableFutures.computeAsync(cancelChecker -> {
            Stopwatch stopwatch = Stopwatch.createStarted();
            TelemetryData telemetryData = new TelemetryData("Rename");
            try {
                WorkspaceEdit workspaceEdit = this.renameProvider.provideRename(params, telemetryData);
                return workspaceEdit;
            }
            catch (Exception e) {
                telemetryData.add(e);
            }
            finally {
                stopwatch.stop();
                telemetryData.addExecutionTime(stopwatch.elapsed(TimeUnit.MILLISECONDS));
                this.telemetryHandler.send(telemetryData);
            }
            return new WorkspaceEdit();
        });
    }

    public void didOpen(DidOpenTextDocumentParams params) {
        logger.debug("Document {} opened", (Object)params.getTextDocument().getUri());
        this.documentHandler.handleDidOpen(params);
    }

    public void didChange(DidChangeTextDocumentParams params) {
        logger.debug("Document {} changed", (Object)params.getTextDocument().getUri());
        this.documentHandler.handleDidChange(params);
    }

    public void didClose(DidCloseTextDocumentParams params) {
        logger.debug("Document {} closed", (Object)params.getTextDocument().getUri());
        this.documentHandler.handleDidClose(params);
    }

    public void didSave(DidSaveTextDocumentParams params) {
        logger.debug("Document {} saved", (Object)params.getTextDocument().getUri());
        this.documentHandler.handleDidSave(params);
    }

    @VisibleForTesting
    public StandardDocumentSymbolVisitor generateDocumentSymbols(URI uri, Document doc) {
        StandardDocumentSymbolVisitor visitor = this.visitorFactory.createDocumentSymbolVisitor(uri);
        CodeUnit codeUnit = this.compilerService.compile(doc);
        codeUnit.additionalValidate(visitor);
        return visitor;
    }
}

