/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.data.Location;
import apex.jorje.semantic.ast.TypeConversion;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.bcl.AsmMethod;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.signature.Signature;
import apex.jorje.semantic.symbol.member.method.signature.SignatureFactory;
import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.ScalarTypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MoreSets;
import java.util.List;
import java.util.Set;

class BuiltInMethodMapper {
    private static final Set<String> ID_METHOD_NAMES = MoreSets.toImmutableCaseInsensitiveSet((Set<String>)((Object)((ImmutableSet.Builder)ImmutableSet.builder().add("getSObjectType")).build()));
    private static final Set<TypeInfo> MAPPED_TYPES = ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add(TypeInfos.BLOB)).add(TypeInfos.BOOLEAN)).add(TypeInfos.CURRENCY)).add(TypeInfos.DATE)).add(TypeInfos.DATE_TIME)).add(TypeInfos.DECIMAL)).add(TypeInfos.DOUBLE)).add(TypeInfos.ID)).add(TypeInfos.INTEGER)).add(TypeInfos.LONG)).add(TypeInfos.STRING)).add(TypeInfos.TIME)).build();

    BuiltInMethodMapper() {
    }

    @VisibleForTesting
    Signature convertSignatureForEmit(MethodInfo method) {
        Signature signatureToEmit = method.getEmitSignature();
        ImmutableList.Builder parameters = ImmutableList.builder();
        if (this.convert(method)) {
            parameters.add(method.getDefiningType());
        }
        for (TypeInfo type : signatureToEmit.getParameterTypes()) {
            parameters.add(this.mapToGenericSObject(type));
        }
        ScalarTypeInfo returnType = this.isUseValueTypeMethod(method) ? TypeInfos.OBJECT : this.mapToGenericSObject(signatureToEmit.getReturnType());
        return SignatureFactory.create(signatureToEmit.getName(), (TypeInfo)returnType, (List<TypeInfo>)((Object)parameters.build()));
    }

    TypeInfo mapToGenericSObject(TypeInfo type) {
        return type.getBasicType() == BasicType.SOBJECT ? TypeInfos.SOBJECT : type;
    }

    boolean isUseValueTypeMethod(MethodInfo method) {
        return method.getDefiningType().getBasicType() == BasicType.ID && ID_METHOD_NAMES.contains(method.getName());
    }

    int convertInvocation(MethodInfo method) {
        return method.getModifiers().has(ModifierTypeInfos.STATIC) || this.convert(method) ? 184 : 182;
    }

    private boolean convert(MethodInfo method) {
        return !method.getModifiers().has(ModifierTypeInfos.STATIC) && MAPPED_TYPES.contains(method.getDefiningType());
    }

    private AsmMethod createAsmMethodForEmit(MethodInfo method) {
        return AsmMethod.builder().setDefiningTypeAsBytecodeMethodName(method.getDefiningType()).setFunction(method.getName()).setSignature(this.convertSignatureForEmit(method)).setOpcode(this.convertInvocation(method)).build();
    }

    public void emit(Location loc, Emitter emitter, MethodInfo method) {
        AsmMethod asmMethod = this.createAsmMethodForEmit(method);
        emitter.emit(loc, asmMethod);
        TypeConversion.emit(loc, emitter, method.getReturnType(), asmMethod.signature.getReturnType());
    }
}

