/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.errorprone;

import net.sourceforge.pmd.lang.apex.ast.ASTAnnotation;
import net.sourceforge.pmd.lang.apex.ast.ASTField;
import net.sourceforge.pmd.lang.apex.ast.ASTMethod;
import net.sourceforge.pmd.lang.apex.ast.ASTModifierNode;
import net.sourceforge.pmd.lang.apex.ast.ASTProperty;
import net.sourceforge.pmd.lang.apex.ast.ASTUserClass;
import net.sourceforge.pmd.lang.apex.ast.ASTUserEnum;
import net.sourceforge.pmd.lang.apex.ast.ASTUserInterface;
import net.sourceforge.pmd.lang.apex.ast.ApexNode;
import net.sourceforge.pmd.lang.apex.rule.AbstractApexRule;

public class AvoidNonExistentAnnotationsRule
extends AbstractApexRule {
    @Override
    public Object visit(ASTUserClass node, Object data) {
        this.checkForNonExistentAnnotation(node, node.getModifiers(), data);
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTUserInterface node, Object data) {
        this.checkForNonExistentAnnotation(node, node.getModifiers(), data);
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTUserEnum node, Object data) {
        this.checkForNonExistentAnnotation(node, node.getModifiers(), data);
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTMethod node, Object data) {
        return this.checkForNonExistentAnnotation(node, node.getModifiers(), data);
    }

    @Override
    public Object visit(ASTProperty node, Object data) {
        return this.checkForNonExistentAnnotation(node, node.getModifiers(), data);
    }

    @Override
    public Object visit(ASTField node, Object data) {
        return this.checkForNonExistentAnnotation(node, node.getModifiers(), data);
    }

    private Object checkForNonExistentAnnotation(ApexNode<?> node, ASTModifierNode modifierNode, Object data) {
        for (ASTAnnotation annotation : modifierNode.findChildrenOfType(ASTAnnotation.class)) {
            if (annotation.isResolved()) continue;
            this.addViolationWithMessage(data, node, "Use of non existent annotations will lead to broken Apex code which will not compile in the future.");
        }
        return data;
    }
}

