/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.bestpractices;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTArgumentList;
import net.sourceforge.pmd.lang.java.ast.ASTArguments;
import net.sourceforge.pmd.lang.java.ast.ASTConditionalAndExpression;
import net.sourceforge.pmd.lang.java.ast.ASTConditionalOrExpression;
import net.sourceforge.pmd.lang.java.ast.ASTEqualityExpression;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTImportDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTNullLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.lang.java.typeresolution.ClassTypeResolver;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;
import net.sourceforge.pmd.lang.symboltable.NameDeclaration;
import org.apache.commons.lang3.StringUtils;

public class LiteralsFirstInComparisonsRule
extends AbstractJavaRule {
    private static final String[] COMPARISON_OPS = new String[]{".equals", ".equalsIgnoreCase", ".compareTo", ".compareToIgnoreCase", ".contentEquals"};

    public LiteralsFirstInComparisonsRule() {
        this.addRuleChainVisit(ASTPrimaryExpression.class);
    }

    @Override
    public Object visit(ASTPrimaryExpression expression, Object data) {
        if (this.violatesLiteralsFirstInComparisonsRule(expression)) {
            this.addViolation(data, (Node)expression);
        }
        return data;
    }

    private boolean violatesLiteralsFirstInComparisonsRule(ASTPrimaryExpression expression) {
        return !this.hasStringLiteralFirst(expression) && this.isNullableComparisonWithStringLiteral(expression);
    }

    private boolean hasStringLiteralFirst(ASTPrimaryExpression expression) {
        ASTPrimaryPrefix primaryPrefix = (ASTPrimaryPrefix)expression.getFirstChildOfType(ASTPrimaryPrefix.class);
        ASTLiteral firstLiteral = (ASTLiteral)primaryPrefix.getFirstChildOfType(ASTLiteral.class);
        return firstLiteral != null && firstLiteral.isStringLiteral();
    }

    private boolean isNullableComparisonWithStringLiteral(ASTPrimaryExpression expression) {
        String opName = this.getOperationName(expression);
        ASTName opTarget = this.getOperationTarget(expression);
        ASTPrimarySuffix argsSuffix = this.getSuffixOfArguments(expression);
        return opName != null && argsSuffix != null && this.isStringLiteralComparison(opName, argsSuffix) && this.isNotWithinNullComparison(expression) && !this.isConstantString(opTarget);
    }

    private String getOperationName(ASTPrimaryExpression primaryExpression) {
        return this.isMethodsChain(primaryExpression) ? this.getOperationNameBySuffix(primaryExpression) : this.getOperationNameByPrefix(primaryExpression);
    }

    private boolean isMethodsChain(ASTPrimaryExpression primaryExpression) {
        return primaryExpression.getNumChildren() > 2;
    }

    private ASTName getOperationTarget(ASTPrimaryExpression primaryExpression) {
        return this.isMethodsChain(primaryExpression) ? this.getOperationTargetBySuffix(primaryExpression) : this.getOperationTargetByPrefix(primaryExpression);
    }

    private String getOperationNameBySuffix(ASTPrimaryExpression primaryExpression) {
        ASTPrimarySuffix opAsSuffix = this.getPrimarySuffixAtIndexFromEnd(primaryExpression, 1);
        if (opAsSuffix != null) {
            String opName = opAsSuffix.getImage();
            return "." + opName;
        }
        return null;
    }

    private ASTName getOperationTargetBySuffix(ASTPrimaryExpression primaryExpression) {
        ASTPrimarySuffix opAsSuffix = this.getPrimarySuffixAtIndexFromEnd(primaryExpression, 1);
        if (opAsSuffix != null) {
            return (ASTName)opAsSuffix.getFirstChildOfType(ASTName.class);
        }
        return null;
    }

    private String getOperationNameByPrefix(ASTPrimaryExpression primaryExpression) {
        ASTPrimaryPrefix opAsPrefix = (ASTPrimaryPrefix)primaryExpression.getFirstChildOfType(ASTPrimaryPrefix.class);
        if (opAsPrefix != null) {
            ASTName opName = (ASTName)opAsPrefix.getFirstChildOfType(ASTName.class);
            return opName != null ? opName.getImage() : null;
        }
        return null;
    }

    private ASTName getOperationTargetByPrefix(ASTPrimaryExpression primaryExpression) {
        ASTPrimaryPrefix opAsPrefix = (ASTPrimaryPrefix)primaryExpression.getFirstChildOfType(ASTPrimaryPrefix.class);
        if (opAsPrefix != null) {
            return (ASTName)opAsPrefix.getFirstChildOfType(ASTName.class);
        }
        return null;
    }

    private ASTPrimarySuffix getSuffixOfArguments(ASTPrimaryExpression primaryExpression) {
        return this.getPrimarySuffixAtIndexFromEnd(primaryExpression, 0);
    }

    private ASTPrimarySuffix getPrimarySuffixAtIndexFromEnd(ASTPrimaryExpression primaryExpression, int indexFromEnd) {
        int index = primaryExpression.getNumChildren() - 1 - indexFromEnd;
        if (index <= 0) {
            return null;
        }
        return (ASTPrimarySuffix)primaryExpression.getChild(index);
    }

    private boolean isStringLiteralComparison(String opName, ASTPrimarySuffix argsSuffix) {
        return this.isComparisonOperation(opName) && this.isSingleStringLiteralArgument(argsSuffix);
    }

    private boolean isComparisonOperation(String op) {
        for (String comparisonOp : COMPARISON_OPS) {
            if (!op.endsWith(comparisonOp)) continue;
            return true;
        }
        return false;
    }

    private boolean isSingleStringLiteralArgument(ASTPrimarySuffix primarySuffix) {
        return this.isSingleArgumentSuffix(primarySuffix) && this.isStringLiteralFirstArgumentOfSuffix(primarySuffix);
    }

    private boolean isSingleArgumentSuffix(ASTPrimarySuffix primarySuffix) {
        return primarySuffix.getArgumentCount() == 1;
    }

    private boolean isStringLiteralFirstArgumentOfSuffix(ASTPrimarySuffix primarySuffix) {
        ASTPrimaryPrefix argumentPrimaryPrefix = this.getArgumentPrimaryPrefix(primarySuffix);
        if (argumentPrimaryPrefix == null || !TypeTestUtil.isA(String.class, (TypeNode)argumentPrimaryPrefix)) {
            return false;
        }
        JavaNode firstLiteralArg = (JavaNode)argumentPrimaryPrefix.getFirstChildOfType(ASTLiteral.class);
        JavaNode firstNameArg = (JavaNode)argumentPrimaryPrefix.getFirstChildOfType(ASTName.class);
        return this.isStringLiteral(firstLiteralArg) || this.isConstantString(firstNameArg);
    }

    private ASTPrimaryPrefix getArgumentPrimaryPrefix(ASTPrimarySuffix primarySuffix) {
        ASTExpression expression = (ASTExpression)((ASTArgumentList)((ASTArguments)primarySuffix.getFirstChildOfType(ASTArguments.class)).getFirstChildOfType(ASTArgumentList.class)).getFirstChildOfType(ASTExpression.class);
        assert (expression != null) : "We checked before that we had exactly one argument, so this cannot fail";
        ASTPrimaryExpression primaryExpression = (ASTPrimaryExpression)expression.getFirstChildOfType(ASTPrimaryExpression.class);
        if (primaryExpression != null) {
            return (ASTPrimaryPrefix)primaryExpression.getChild(0);
        }
        return null;
    }

    private boolean isStringLiteral(JavaNode node) {
        if (node instanceof ASTLiteral) {
            ASTLiteral literal = (ASTLiteral)node;
            return literal.isStringLiteral();
        }
        return false;
    }

    private boolean isConstantString(JavaNode node) {
        if (node instanceof ASTName) {
            ASTName name = (ASTName)node;
            NameDeclaration resolved = name.getNameDeclaration();
            if (resolved instanceof VariableNameDeclaration && resolved.getNode() instanceof ASTVariableDeclaratorId) {
                ASTVariableDeclaratorId resolvedNode = (ASTVariableDeclaratorId)resolved.getNode();
                return resolvedNode.isFinal() && resolvedNode.isField() && ((ASTFieldDeclaration)resolvedNode.getFirstParentOfType(ASTFieldDeclaration.class)).isStatic();
            }
            if (resolved == null) {
                List imports = node.getRoot().findChildrenOfType(ASTImportDeclaration.class);
                Field field = this.tryResolve(name.getImage(), node.getRoot().getClassTypeResolver(), imports);
                if (field != null) {
                    return Modifier.isStatic(field.getModifiers()) && Modifier.isFinal(field.getModifiers());
                }
            }
        }
        return false;
    }

    private Field tryResolve(String fullPossibleClassName, ClassTypeResolver resolver, List<ASTImportDeclaration> imports) {
        String possibleClassName;
        int i;
        HashMap importedTypes = new HashMap();
        HashSet<String> onDemandImports = new HashSet<String>();
        for (ASTImportDeclaration importDecl : imports) {
            if (importDecl.getType() != null) {
                importedTypes.put(importDecl.getType().getSimpleName(), importDecl.getType());
                continue;
            }
            if (!importDecl.isImportOnDemand()) continue;
            onDemandImports.add(importDecl.getImportedName());
        }
        Object[] splitName = fullPossibleClassName.split("\\.");
        for (i = splitName.length; i > 0; --i) {
            possibleClassName = StringUtils.join((Object[])splitName, (String)".", (int)0, (int)i);
            if (!importedTypes.containsKey(possibleClassName)) continue;
            Object possibleFieldName = splitName[i];
            Class type = (Class)importedTypes.get(possibleClassName);
            try {
                return type.getDeclaredField((String)possibleFieldName);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
        }
        for (i = splitName.length; i > 0; --i) {
            possibleClassName = StringUtils.join((Object[])splitName, (String)".", (int)0, (int)i);
            for (String prefix : onDemandImports) {
                Class<?> type = resolver.loadClassOrNull(prefix + "." + possibleClassName);
                if (type == null) continue;
                Object possibleFieldName = splitName[i];
                try {
                    return type.getDeclaredField((String)possibleFieldName);
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                }
            }
        }
        return null;
    }

    private boolean isNotWithinNullComparison(ASTPrimaryExpression node) {
        return !this.isWithinNullComparison(node);
    }

    private boolean isWithinNullComparison(ASTPrimaryExpression node) {
        for (ASTExpression parentExpr : node.getParentsOfType(ASTExpression.class)) {
            if (!this.isNullComparison(parentExpr)) continue;
            return true;
        }
        return false;
    }

    private boolean isNullComparison(ASTExpression expression) {
        return this.isAndNotNullComparison(expression) || this.isOrNullComparison(expression);
    }

    private boolean isAndNotNullComparison(ASTExpression expression) {
        ASTConditionalAndExpression andExpression = (ASTConditionalAndExpression)expression.getFirstChildOfType(ASTConditionalAndExpression.class);
        return andExpression != null && this.hasEqualityExpressionWithNullLiteral(andExpression, "!=");
    }

    private boolean isOrNullComparison(ASTExpression expression) {
        ASTConditionalOrExpression orExpression = (ASTConditionalOrExpression)expression.getFirstChildOfType(ASTConditionalOrExpression.class);
        return orExpression != null && this.hasEqualityExpressionWithNullLiteral(orExpression, "==");
    }

    private boolean hasEqualityExpressionWithNullLiteral(JavaNode node, String equalityOp) {
        ASTEqualityExpression equalityExpression = (ASTEqualityExpression)node.getFirstDescendantOfType(ASTEqualityExpression.class);
        if (equalityExpression != null && equalityExpression.hasImageEqualTo(equalityOp)) {
            return equalityExpression.hasDescendantOfType(ASTNullLiteral.class);
        }
        return false;
    }
}

