/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.data.ast;

import apex.common.base.ObjectHash;
import apex.jorje.data.Identifier;
import apex.jorje.data.Identifiers;
import apex.jorje.data.ast.PrinterBlocks;
import apex.jorje.data.ast.TypeRef;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.MoreLists;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class TypeRefs {
    public static final TypeRef OBJECT = TypeRefs.newClassTypeRef(Identifiers.newIdentifiers("Object"), ImmutableList.of());
    private static final TypeRef.Visitor<Boolean> IS_ARRAY_REF = new TypeRef.Visitor<Boolean>(){

        @Override
        public Boolean visit(JavaTypeRef typeRef) {
            return false;
        }

        @Override
        public Boolean visit(ClassTypeRef typeRef) {
            return false;
        }

        @Override
        public Boolean visit(ArrayTypeRef typeRef) {
            return true;
        }
    };

    private TypeRefs() {
    }

    public static TypeRef newJavaTypeRef(List<Identifier> names) {
        return new JavaTypeRef(names);
    }

    public static TypeRef newClassTypeRef(List<Identifier> names) {
        return new ClassTypeRef(names, ImmutableList.of());
    }

    public static TypeRef newClassTypeRef(List<Identifier> names, List<TypeRef> argumentTypes) {
        return new ClassTypeRef(names, MoreLists.toEmptyList(argumentTypes));
    }

    public static TypeRef newArrayTypeRef(TypeRef type) {
        return new ArrayTypeRef(type);
    }

    public static boolean isArrayRef(TypeRef superRef) {
        return superRef.accept(IS_ARRAY_REF);
    }

    public static class ArrayTypeRef
    implements TypeRef {
        private final TypeRef heldType;

        private ArrayTypeRef(TypeRef heldType) {
            this.heldType = heldType;
        }

        public TypeRef getHeldType() {
            return this.heldType;
        }

        public int hashCode() {
            return Objects.hashCode(this.heldType);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ArrayTypeRef that = (ArrayTypeRef)o;
            return Objects.equals(this.heldType, that.heldType);
        }

        public String toString() {
            return this.heldType + "[]";
        }

        @Override
        public List<Identifier> getNames() {
            return this.heldType.getNames();
        }

        @Override
        public List<TypeRef> getTypeArguments() {
            return ImmutableList.of(this.heldType);
        }

        @Override
        public <T> T accept(TypeRef.Visitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static class ClassTypeRef
    implements TypeRef {
        private final List<Identifier> names;
        private final List<TypeRef> typeArguments;

        private ClassTypeRef(List<Identifier> names, List<TypeRef> typeArguments) {
            this.names = names;
            this.typeArguments = typeArguments;
        }

        public int hashCode() {
            return ObjectHash.hash(this.names, this.typeArguments);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClassTypeRef that = (ClassTypeRef)o;
            return Objects.equals(this.names, that.names) && Objects.equals(this.typeArguments, that.typeArguments);
        }

        public String toString() {
            String arguments = this.typeArguments.isEmpty() ? "" : this.typeArguments.stream().map(Object::toString).collect(Collectors.joining(", ", "<", ">"));
            return PrinterBlocks.get().printDotSeparated(this.names) + arguments;
        }

        @Override
        public List<Identifier> getNames() {
            return this.names;
        }

        @Override
        public List<TypeRef> getTypeArguments() {
            return this.typeArguments;
        }

        @Override
        public <T> T accept(TypeRef.Visitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static class JavaTypeRef
    implements TypeRef {
        private final List<Identifier> names;

        private JavaTypeRef(List<Identifier> names) {
            this.names = names;
        }

        public int hashCode() {
            return Objects.hashCode(this.names);
        }

        @Override
        public List<Identifier> getNames() {
            return this.names;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JavaTypeRef that = (JavaTypeRef)o;
            return Objects.equals(this.names, that.names);
        }

        public String toString() {
            return "java:" + PrinterBlocks.get().printDotSeparated(this.names);
        }

        @Override
        public List<TypeRef> getTypeArguments() {
            return ImmutableList.of();
        }

        @Override
        public <T> T accept(TypeRef.Visitor<T> visitor) {
            return visitor.visit(this);
        }
    }
}

