/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.completions;

import apex.jorje.lsp.api.completions.CompletionStrategy;
import apex.jorje.lsp.api.document.Document;
import apex.jorje.lsp.api.workspace.ApexDocumentService;
import apex.jorje.lsp.impl.completions.CompletionItemTransformer;
import apex.jorje.lsp.impl.document.BadLocationException;
import apex.jorje.lsp.impl.utils.MembersContextUtil;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MembersCompletionStrategy
implements CompletionStrategy {
    private static final Logger logger = LoggerFactory.getLogger(MembersCompletionStrategy.class);
    private final ApexDocumentService documentService;
    private final MembersContextUtil membersContextUtil;

    @Inject
    public MembersCompletionStrategy(ApexDocumentService documentService, MembersContextUtil membersContextUtil) {
        this.documentService = documentService;
        this.membersContextUtil = membersContextUtil;
    }

    @Override
    public List<CompletionItem> provideCompletions(TextDocumentPositionParams params) {
        String uri = params.getTextDocument().getUri();
        Optional<Document> optDoc = this.documentService.retrieve(URI.create(uri));
        ArrayList<CompletionItem> items = Lists.newArrayList();
        optDoc.ifPresent(doc -> {
            try {
                items.addAll(CompletionItemTransformer.dedup(this.membersContextUtil.getMemberCompletionItems((Document)doc, params.getPosition())));
            }
            catch (BadLocationException ble) {
                logger.error("Encountered a bad location while providing completion", (Throwable)ble);
            }
        });
        return items;
    }
}

