/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.index.node;

import apex.jorje.lsp.impl.index.ApexIndex;
import apex.jorje.lsp.impl.index.node.ApexClassInterfaceJunction;
import apex.jorje.lsp.impl.index.node.ApexField;
import apex.jorje.lsp.impl.index.node.ApexMethod;
import apex.jorje.lsp.impl.index.node.ApexMethodParameter;
import apex.jorje.lsp.impl.index.node.ApexResourceFile;
import apex.jorje.lsp.impl.index.node.ApexType;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.internal.core.nd.Nd;
import org.eclipse.jdt.internal.core.nd.NdNode;
import org.eclipse.jdt.internal.core.nd.db.IString;
import org.eclipse.jdt.internal.core.nd.field.FieldManyToOne;
import org.eclipse.jdt.internal.core.nd.field.FieldOneToMany;
import org.eclipse.jdt.internal.core.nd.field.FieldSearchKey;
import org.eclipse.jdt.internal.core.nd.field.StructDef;

public class ApexTypeId
extends NdNode {
    public static final StructDef<ApexTypeId> type = StructDef.create(ApexTypeId.class, (StructDef)NdNode.type);
    public static final FieldSearchKey<ApexIndex> APEX_NAME = FieldSearchKey.create(type, ApexIndex.TYPES_BY_APEX_NAME);
    public static final FieldSearchKey<ApexIndex> BYTECODE_NAME = FieldSearchKey.create(type, ApexIndex.TYPES_BY_BYTECODE_NAME);
    public static final FieldSearchKey<ApexIndex> APEX_NAMESPACE = FieldSearchKey.create(type, ApexIndex.NAMESPACES);
    static final FieldOneToMany<ApexType> TYPE = FieldOneToMany.create(type, ApexType.TYPE_ID);
    static final FieldOneToMany<ApexMethodParameter> USED_AS_METHOD_PARAMETER = FieldOneToMany.create(type, ApexMethodParameter.ARGUMENT_TYPE_ID);
    static final FieldOneToMany<ApexMethod> USED_AS_RETURN_TYPE = FieldOneToMany.create(type, ApexMethod.RETURN_TYPE);
    static final FieldOneToMany<ApexField> USED_AS_FIELD_TYPE = FieldOneToMany.create(type, ApexField.TYPE);
    static final FieldManyToOne<ApexTypeId> PARENT = FieldManyToOne.create(type, CHILDREN);
    static final FieldOneToMany<ApexClassInterfaceJunction> INTERFACES = FieldOneToMany.create(type, ApexClassInterfaceJunction.IMPLEMENTING_CLASS);
    static final FieldOneToMany<ApexTypeId> CHILDREN = FieldOneToMany.create(type, PARENT);
    static final FieldOneToMany<ApexClassInterfaceJunction> IMPLEMENTORS = FieldOneToMany.create(type, ApexClassInterfaceJunction.IMPLEMENTED_INTERFACE);
    static final FieldManyToOne<ApexTypeId> ENCLOSING_TYPE = FieldManyToOne.create(type, ENCLOSED_TYPES);
    static final FieldOneToMany<ApexTypeId> ENCLOSED_TYPES = FieldOneToMany.create(type, ENCLOSING_TYPE);

    public ApexTypeId(Nd nd, long address) {
        super(nd, address);
    }

    public ApexTypeId(Nd nd, String apexName, String bytecodeName) {
        super(nd);
        APEX_NAME.put(nd, this.address, apexName);
        BYTECODE_NAME.put(nd, this.address, bytecodeName);
    }

    public IString getApexName() {
        return APEX_NAME.get(this.getNd(), this.address);
    }

    public IString getBytecodeName() {
        return BYTECODE_NAME.get(this.getNd(), this.address);
    }

    public IString getApexNamespace() {
        return APEX_NAMESPACE.get(this.getNd(), this.address);
    }

    public void setApexNamespace(String apexNamespace) {
        APEX_NAMESPACE.put(this.getNd(), this.address, apexNamespace);
    }

    public ApexTypeId getParent() {
        return (ApexTypeId)PARENT.get(this.getNd(), this.address);
    }

    public void setParent(ApexTypeId parentId) {
        PARENT.put(this.getNd(), this.address, (NdNode)parentId);
    }

    public List<ApexTypeId> getInterfaces() {
        ArrayList<ApexTypeId> interfaces = new ArrayList<ApexTypeId>();
        List junctions = INTERFACES.asList(this.getNd(), this.address);
        for (ApexClassInterfaceJunction junction : junctions) {
            interfaces.add(junction.getImplementedInterface());
        }
        return interfaces;
    }

    public void addInterface(ApexResourceFile resourceFile, ApexTypeId interfaceId) {
        ApexClassInterfaceJunction junction = new ApexClassInterfaceJunction(this.getNd(), resourceFile, this, interfaceId);
    }

    public List<ApexTypeId> getChildren() {
        return CHILDREN.asList(this.getNd(), this.address);
    }

    public List<ApexTypeId> getImplementors() {
        ArrayList<ApexTypeId> implementors = new ArrayList<ApexTypeId>();
        List junctions = IMPLEMENTORS.asList(this.getNd(), this.address);
        for (ApexClassInterfaceJunction junction : junctions) {
            implementors.add(junction.getImplementingClass());
        }
        return implementors;
    }

    public ApexType getType() {
        List theType = TYPE.asList(this.getNd(), this.address);
        return theType.isEmpty() ? null : (ApexType)((Object)theType.get(0));
    }

    public final void setEnclosingType(ApexTypeId enclosingId) {
        ENCLOSING_TYPE.put(this.getNd(), this.address, (NdNode)enclosingId);
    }

    public ApexTypeId getEnclosingType() {
        return (ApexTypeId)ENCLOSING_TYPE.get(this.getNd(), this.address);
    }

    public List<ApexMethod> getUsedAsMethodReturnType() {
        return USED_AS_RETURN_TYPE.asList(this.getNd(), this.address);
    }

    public List<ApexMethodParameter> getUsedAsMethodParameter() {
        return USED_AS_METHOD_PARAMETER.asList(this.getNd(), this.address);
    }

    static {
        type.useStandardRefCounting().done();
    }
}

