/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.utils;

import apex.jorje.lsp.api.document.Document;
import apex.jorje.lsp.api.services.DocumentationService;
import apex.jorje.lsp.impl.completions.CompletionActivationFactory;
import apex.jorje.lsp.impl.completions.CompletionItemTransformer;
import apex.jorje.lsp.impl.completions.ValidationBasedCompletionActivationStrategy;
import apex.jorje.lsp.impl.document.BadLocationException;
import apex.jorje.semantic.ast.expression.ReferenceExpression;
import apex.jorje.semantic.ast.expression.VariableExpression;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.Position;

public class MembersContextUtil {
    private final CompletionActivationFactory factory;
    private final DocumentationService documentation;

    @Inject
    public MembersContextUtil(CompletionActivationFactory factory, DocumentationService documentation) {
        this.factory = factory;
        this.documentation = documentation;
    }

    public boolean isMemberContext(Document doc, Position position) throws BadLocationException {
        return this.getMemberReferenceExpression(doc, position).isPresent();
    }

    public final List<CompletionItem> getMemberCompletionItems(Document doc, Position position) throws BadLocationException {
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        this.getMemberReferenceExpression(doc, position).ifPresent(expr -> items.addAll(CompletionItemTransformer.transform(expr.getType(), expr.getDefiningType(), expr.getContext(), this.documentation)));
        return items;
    }

    private Optional<ReferenceExpression> getMemberReferenceExpression(Document doc, Position position) throws BadLocationException {
        ValidationBasedCompletionActivationStrategy strategy = this.factory.createValidationBasedStrategy(doc, position);
        strategy.analyze();
        return this.getMemberReferenceExpression(strategy.getExpression().isPresent() ? strategy.getExpression() : this.getTrickyAlternate(doc, position));
    }

    private Optional<VariableExpression> getTrickyAlternate(Document doc, Position position) throws BadLocationException {
        int lineOffset = doc.getLineOffset(position.getLine());
        int offset = lineOffset + position.getCharacter();
        ValidationBasedCompletionActivationStrategy trickyClassStrategy = this.factory.createValidationBasedStrategy(doc.insert(offset, "_;"), position);
        trickyClassStrategy.analyze();
        return trickyClassStrategy.getExpression();
    }

    private Optional<ReferenceExpression> getMemberReferenceExpression(Optional<VariableExpression> expr) {
        return expr.isPresent() && expr.get().getReferenceContext() instanceof ReferenceExpression ? Optional.of((ReferenceExpression)expr.get().getReferenceContext()) : Optional.empty();
    }
}

