/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.visitors;

import apex.jorje.data.Location;
import apex.jorje.data.Locations;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.compilation.UserClass;
import apex.jorje.semantic.ast.compilation.UserTrigger;
import apex.jorje.semantic.ast.visitor.AdditionalPassScope;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import com.google.common.collect.Maps;
import java.util.Map;

public class ExceptionBreakpointVisitor
extends AstVisitor<AdditionalPassScope> {
    private final Map<String, String> exceptions = Maps.newLinkedHashMap();

    private void addExceptionEntryIfPossible(AstNode node) {
        String typeref;
        Location loc = node.getLoc();
        if (Locations.isReal(loc) && (typeref = node.getDefiningType().getBytecodeName()) != null && typeref.toLowerCase().endsWith("exception")) {
            this.exceptions.put(typeref, node.getDefiningType().getCodeUnitDetails().getName());
        }
    }

    public Map<String, String> getUserDefinedExceptions() {
        return this.exceptions;
    }

    @Override
    public boolean visit(UserClass node, AdditionalPassScope scope) {
        return true;
    }

    @Override
    public void visitEnd(UserClass node, AdditionalPassScope scope) {
        this.addExceptionEntryIfPossible(node);
    }

    @Override
    public boolean visit(UserTrigger node, AdditionalPassScope scope) {
        return true;
    }
}

