/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.context;

import apex.common.collect.MoreIterables;
import apex.jorje.data.Locations;
import apex.jorje.semantic.ast.Emit;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.context.MethodStack;
import com.google.common.collect.Queues;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.objectweb.asm.Label;

public class TryCatchFinallyStack {
    private final Emitter emitter;
    private final Deque<TryCatchFinallyContext> quack;

    TryCatchFinallyStack(Emitter emitter) {
        this.emitter = emitter;
        this.quack = Queues.newArrayDeque();
    }

    public void emitFinallyJumps() {
        this.quack.stream().filter(tryCatchFinally -> ((TryCatchFinallyContext)tryCatchFinally).hasFinally).forEach(tryCatchFinally -> this.emitter.emitJump(Locations.NONE, 168, ((TryCatchFinallyContext)tryCatchFinally).finallyBlock.start));
    }

    public TryCatchFinallyContext push(Emit finallyEmit) {
        TryCatchFinallyContext tryCatchFinally = new TryCatchFinallyContext(finallyEmit);
        this.quack.push(tryCatchFinally);
        return tryCatchFinally;
    }

    void emitFinallyJumps(int tryStackSize) {
        int i = this.quack.size();
        for (TryCatchFinallyContext tryCatchFinally : this.quack) {
            if (i <= tryStackSize) break;
            if (tryCatchFinally.hasFinally) {
                this.emitter.emitJump(Locations.NONE, 168, tryCatchFinally.finallyBlock.start);
            }
            --i;
        }
    }

    public void startTryBlock() {
        TryCatchFinallyContext context = this.quack.peek();
        this.startBlock(context.tryBlock);
    }

    public void startCatchBlock() {
        this.startBlock(new Block());
    }

    private void startBlock(Block block) {
        TryCatchFinallyContext tryCatchFinally = this.quack.peek();
        assert (tryCatchFinally.currentBlocks.isEmpty());
        tryCatchFinally.currentBlocks.push(block);
        this.emitter.emit(block.start);
    }

    public Block endBlock() {
        TryCatchFinallyContext context = this.quack.peek();
        Block block = (Block)context.currentBlocks.pop();
        assert (context.currentBlocks.isEmpty());
        this.emitter.emit(block.end);
        if (context.hasFinally) {
            context.finallyBlocks.add(block);
            this.emitter.emitJump(Locations.NONE, 168, context.finallyBlock.start);
        }
        return block;
    }

    public void pop(Emit exceptionEmit) {
        TryCatchFinallyContext context = this.quack.pop();
        MethodStack.MethodContext method = this.emitter.getMethodStack().peek();
        if (!context.hasFinally) {
            return;
        }
        this.emitter.emitJump(Locations.NONE, 167, context.finallyBlock.end);
        this.emitter.emit(context.finallyBlock.start);
        method.getLocalVariables().clean();
        int returnIndex = method.getLocalVariables().add();
        int exceptionIndex = method.getLocalVariables().add();
        this.emitter.emitVar(Locations.NONE, 58, returnIndex);
        context.finallyEmit.emit(this.emitter);
        this.emitter.emitVar(Locations.NONE, 169, returnIndex);
        Label handlerStart = new Label();
        this.emitter.emit(handlerStart);
        exceptionEmit.emit(this.emitter);
        this.emitter.emitVar(Locations.NONE, 58, exceptionIndex);
        this.emitter.emitJump(Locations.NONE, 168, context.finallyBlock.start);
        this.emitter.emitVar(Locations.NONE, 25, exceptionIndex);
        this.emitter.emit(Locations.NONE, 191);
        for (Block block : context.finallyBlocks) {
            this.emitter.emitFinallyBlock(block.start, block.end, handlerStart);
        }
        this.emitter.emit(context.finallyBlock.end);
        this.emitter.emit(Locations.NONE, 0);
        method.getLocalVariables().clear(returnIndex);
        method.getLocalVariables().clear(exceptionIndex);
    }

    public int size() {
        return this.quack.size();
    }

    public boolean isEmpty() {
        return this.quack.isEmpty();
    }

    public TryCatchFinallyContext peek() {
        return this.quack.peek();
    }

    public boolean hasFinally() {
        return MoreIterables.ensureAny(this.quack, input -> ((TryCatchFinallyContext)input).hasFinally);
    }

    public void clear() {
        this.quack.clear();
    }

    public static class Block {
        private final Label start = new Label();
        private final Label end = new Label();

        Block() {
        }

        public Label getStart() {
            return this.start;
        }

        public Label getEnd() {
            return this.end;
        }
    }

    public static class TryCatchFinallyContext {
        private final Label exit;
        private final Label tryStartForCatch;
        private final Block tryBlock;
        private final boolean hasFinally;
        private final List<Block> finallyBlocks;
        private final Deque<Block> currentBlocks;
        private final Block finallyBlock;
        private final Emit finallyEmit;

        TryCatchFinallyContext(Emit finallyEmit) {
            this.finallyEmit = finallyEmit;
            this.hasFinally = finallyEmit != Emit.NOOP;
            this.finallyBlocks = new ArrayList<Block>();
            this.currentBlocks = Queues.newArrayDeque();
            this.exit = new Label();
            this.tryStartForCatch = new Label();
            this.tryBlock = new Block();
            this.finallyBlock = new Block();
        }

        public Label getExit() {
            return this.exit;
        }

        public Label getTryStartForCatch() {
            return this.tryStartForCatch;
        }

        public Block getTryBlock() {
            return this.tryBlock;
        }
    }
}

