/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.data.Locations;
import apex.jorje.data.ast.Expr;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.ArrayExpression;
import apex.jorje.semantic.ast.expression.LazyLabel;
import apex.jorje.semantic.ast.expression.ShortCircuitable;
import apex.jorje.semantic.ast.expression.SpecialAssignmentCalculator;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.bcl.ListEmitMethods;
import apex.jorje.semantic.bcl.SystemEmitMethods;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.common.CollectionTypeInfoUtil;
import apex.jorje.semantic.symbol.type.common.TypeInfoUtil;
import apex.jorje.semantic.symbol.type.naming.TypeEraser;
import apex.jorje.services.I18nSupport;
import java.util.Objects;
import org.objectweb.asm.Label;

public class ArrayLoadExpression
extends ArrayExpression
implements ShortCircuitable {
    private final LazyLabel shortCircuitLabel = new LazyLabel();

    public ArrayLoadExpression(AstNode definingNode, Expr.ArrayExpr expr) {
        super(definingNode, expr);
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope)) {
            this.getInnerExpression().traverse(visitor, scope);
            this.getIndex().traverse(visitor, scope);
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        this.getInnerExpression().validate(symbols, scope);
        this.getIndex().validate(symbols, scope);
        if (scope.getErrors().isInvalid(this.getInnerExpression(), this.getIndex())) {
            scope.getErrors().markInvalid(this);
            return;
        }
        if (!CollectionTypeInfoUtil.isList(this.getInnerExpression().getType())) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.list.type", this.getInnerExpression().getType()));
        } else {
            TypeInfo elementType = TypeInfoUtil.getRealType(symbols, this.getDefiningType(), CollectionTypeInfoUtil.getElementType(this.getInnerExpression().getType()));
            this.setType(elementType);
        }
        if (!Objects.equals(this.getIndex().getType(), TypeInfos.INTEGER)) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.list.index.type", TypeInfos.INTEGER, this.getIndex().getType()));
        }
    }

    @Override
    public void emit(Emitter emitter) {
        this.getInnerExpression().emit(emitter);
        this.getIndex().emit(emitter);
        if (SpecialAssignmentCalculator.get().calculate(this)) {
            emitter.emit(Locations.NONE, 92);
        }
        emitter.emit(Locations.NONE, 89);
        Label nonNull = new Label();
        emitter.emitJump(this.getLoc(), 199, nonNull);
        emitter.emit(this.getLoc(), SystemEmitMethods.THROW_LIST_INDEX_NULL);
        emitter.emit(nonNull);
        emitter.emit(this.getLoc(), ListEmitMethods.GET_BYTECODE);
        emitter.push(Locations.NONE, TypeEraser.eraseBytecodeName(this.getType()));
        emitter.emit(Locations.NONE, SystemEmitMethods.CONVERT);
        this.getShortCircuitLabel().emit(emitter);
    }

    @Override
    public LazyLabel getShortCircuitLabel() {
        return this.shortCircuitLabel;
    }
}

