/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.bcl.validators;

import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.expression.ExpressionUtil;
import apex.jorje.semantic.ast.expression.MethodCallExpression;
import apex.jorje.semantic.ast.expression.ReferenceContext;
import apex.jorje.semantic.ast.expression.VariableExpression;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.ast.visitor.ValueScope;
import apex.jorje.semantic.bcl.validators.BuiltInMethodValidator;
import apex.jorje.semantic.symbol.member.variable.SObjectFieldInfo;
import apex.jorje.semantic.symbol.member.variable.Variable;
import apex.jorje.semantic.symbol.member.variable.VariableVisitor;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.services.I18nSupport;
import com.google.common.collect.Iterables;
import java.util.Optional;

public class AddErrorValidator
implements BuiltInMethodValidator {
    private static final VariableVisitor<String, MethodCallExpression> GET_ERROR = new VariableVisitor.Default<String, MethodCallExpression>(){

        @Override
        public String _default(Variable info, MethodCallExpression expression) {
            return I18nSupport.getLabel("method.invalid.add.error.not.sobject.field");
        }

        @Override
        public String visit(SObjectFieldInfo info, MethodCallExpression expression) {
            boolean isDottedExpressionSoql = ExpressionUtil.isSoqlExpression(expression.getReferenceContext().getDottedExpression());
            if (isDottedExpressionSoql || info.getCategory() != SObjectFieldInfo.Category.REGULAR || !info.isColumnInfo()) {
                return I18nSupport.getLabel("method.invalid.add.error.not.sobject.scalar.field");
            }
            ReferenceContext reference = expression.getReferenceContext();
            if (reference.isSafeNav() && reference.getVariables().isEmpty()) {
                return I18nSupport.getLabel("safe.navigation.invalid.between.sobject.field.and.add.error");
            }
            return "";
        }
    };
    private static final AstVisitor<ValueScope<Optional<Variable>>> GET_VARIABLE = new AstVisitor<ValueScope<Optional<Variable>>>(){

        @Override
        public void visitEnd(VariableExpression node, ValueScope<Optional<Variable>> scope) {
            scope.setValue(Optional.of(node.getVariable()));
        }
    };
    private static final BuiltInMethodValidator INSTANCE = new AddErrorValidator();

    private AddErrorValidator() {
    }

    public static BuiltInMethodValidator get() {
        return INSTANCE;
    }

    private static Optional<Variable> getVariable(Expression expression) {
        return ValueScope.evaluate(expression, GET_VARIABLE, Optional.empty());
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope, MethodCallExpression expression) {
        Optional<Variable> lastVariable;
        Optional<Variable> optional = lastVariable = expression.getReferenceContext().getVariables().isEmpty() ? AddErrorValidator.getVariable(expression.getReferenceContext().getDottedExpression()) : Optional.of(Iterables.getLast(expression.getReferenceContext().getVariables()));
        if (lastVariable.isPresent()) {
            String message = lastVariable.get().accept(GET_ERROR, expression);
            if (!message.isEmpty()) {
                scope.getErrors().markInvalid((AstNode)expression, message);
            }
        } else {
            scope.getErrors().markInvalid((AstNode)expression, I18nSupport.getLabel("method.invalid.add.error.not.sobject.field"));
        }
    }
}

