/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.services.datetimes;

import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;

public final class DateTimeFormats {
    public static final DateTimeFormatter PRINT_DATE = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    public static final DateTimeFormatter PRINT_TIME = DateTimeFormatter.ofPattern("HH:mm:ss.SSS'z'");
    public static final DateTimeFormatter PRINT_DATE_TIME = DateTimeFormatter.ofPattern("yyyy-MM-dd't'HH:mm:ss.SSS'z'");
    private static final ZoneId GMT = ZoneId.of("GMT");
    private static final DateTimeFormatter DATE = new DateTimeFormatterBuilder().append(DateTimeFormatter.ofPattern("yyyy-MM-dd")).toFormatter();
    private static final DateTimeFormatter BASE_TIME = new DateTimeFormatterBuilder().append(DateTimeFormatter.ofPattern("HH:mm:ss")).appendOptional(new DateTimeFormatterBuilder().appendLiteral('.').appendFraction(ChronoField.MILLI_OF_SECOND, 3, 5, false).toFormatter()).toFormatter();
    private static final DateTimeFormatter TIME_NO_OFFSET = new DateTimeFormatterBuilder().parseCaseInsensitive().appendPattern("z").parseCaseSensitive().toFormatter();
    private static final DateTimeFormatter TIME_OFFSET = new DateTimeFormatterBuilder().append(DateTimeFormatter.ofPattern("Z")).toFormatter();
    private static final DateTimeFormatter TIME = new DateTimeFormatterBuilder().append(BASE_TIME).appendOptional(TIME_NO_OFFSET).appendOptional(TIME_OFFSET).toFormatter();
    private static final DateTimeFormatter DATE_TIME = new DateTimeFormatterBuilder().append(DATE).parseCaseInsensitive().appendLiteral('t').parseCaseSensitive().append(TIME).toFormatter();

    private DateTimeFormats() {
    }

    public static LocalDate fromDate(String literal) {
        return DATE.parse((CharSequence)literal, LocalDate::from);
    }

    public static OffsetTime fromTime(String literal) {
        TemporalAccessor accessor = TIME.parseBest(literal, OffsetTime::from, LocalTime::from);
        if (accessor instanceof OffsetTime) {
            return OffsetTime.from(accessor).withOffsetSameInstant(ZoneOffset.UTC);
        }
        if (accessor instanceof LocalTime) {
            return LocalTime.from(accessor).atOffset(ZoneOffset.UTC);
        }
        throw new DateTimeException("Can't parse " + literal + " as OffsetTime");
    }

    public static ZonedDateTime fromDateTime(String literal) {
        return DATE_TIME.parse((CharSequence)literal, ZonedDateTime::from).withZoneSameInstant(GMT);
    }
}

