/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.data;

import apex.jorje.data.Identifier;
import apex.jorje.data.Identifiers;
import apex.jorje.data.Location;
import apex.jorje.data.Locations;
import apex.jorje.data.TypeRefBuilder;
import apex.jorje.data.ast.CatchBlock;
import apex.jorje.data.ast.ElseBlock;
import apex.jorje.data.ast.Expr;
import apex.jorje.data.ast.FinallyBlock;
import apex.jorje.data.ast.ForInits;
import apex.jorje.data.ast.LiteralType;
import apex.jorje.data.ast.Modifier;
import apex.jorje.data.ast.Stmnt;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.data.soql.BindClause;
import apex.jorje.data.soql.ColonExpr;
import apex.jorje.data.soql.ElseExpr;
import apex.jorje.data.soql.Field;
import apex.jorje.data.soql.FieldIdentifier;
import apex.jorje.data.soql.GroupByClause;
import apex.jorje.data.soql.GroupByType;
import apex.jorje.data.soql.HavingClause;
import apex.jorje.data.soql.LimitClause;
import apex.jorje.data.soql.OffsetClause;
import apex.jorje.data.soql.OrderByClause;
import apex.jorje.data.soql.QueryLiteral;
import apex.jorje.data.soql.QueryOption;
import apex.jorje.data.soql.QueryUsingClause;
import apex.jorje.data.soql.TrackingType;
import apex.jorje.data.soql.UpdateStatsClause;
import apex.jorje.data.soql.UsingExpr;
import apex.jorje.data.soql.WhereClause;
import apex.jorje.data.soql.WithClause;
import apex.jorje.data.soql.WithIdentifierClause;
import apex.jorje.data.sosl.InClause;
import apex.jorje.data.sosl.ReturningClause;
import apex.jorje.data.sosl.ReturningSelectExpr;
import apex.jorje.data.sosl.SearchUsingClause;
import apex.jorje.data.sosl.SearchWithClause;
import apex.jorje.data.sosl.WithDataCategoryClause;
import apex.jorje.data.sosl.WithDivisionClause;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.MoreLists;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class JadtTester {
    public static final List<Modifier> FINAL_GLOBAL_MODIFIERS = Lists.newArrayList(Modifier._FinalModifier(Locations.NONE), Modifier._GlobalModifier(Locations.NONE));
    public static final Optional<FieldIdentifier> NO_FIELD_IDENTIFIER = Optional.empty();
    public static final Optional<Identifier> NO_IDENTIFIER = Optional.empty();
    public static final Optional<ElseExpr> NO_ELSE = Optional.empty();
    public static final Optional<WhereClause> NO_WHERE = Optional.empty();
    public static final Optional<HavingClause> NO_HAVING = Optional.empty();
    public static final Optional<WithClause> NO_WITH = Optional.empty();
    public static final List<WithIdentifierClause> NO_WITH_IDENTIFIERS = Collections.emptyList();
    public static final Optional<GroupByType> NO_GROUP_BY_TYPE = Optional.empty();
    public static final Optional<GroupByClause> NO_GROUP_BY = Optional.empty();
    public static final Optional<OrderByClause> NO_ORDER_BY = Optional.empty();
    public static final Optional<LimitClause> NO_LIMIT = Optional.empty();
    public static final Optional<OffsetClause> NO_OFFSET = Optional.empty();
    public static final Optional<BindClause> NO_BIND = Optional.empty();
    public static final Optional<TrackingType> NO_TRACKING_TYPE = Optional.empty();
    public static final Optional<UpdateStatsClause> NO_UPDATE_STATS = Optional.empty();
    public static final Optional<QueryOption> NO_QUERY_OPTION = Optional.empty();
    public static final Optional<InClause> NO_IN = Optional.empty();
    public static final Optional<ReturningClause> NO_RETURNING = Optional.empty();
    public static final Optional<WithDivisionClause> NO_WITH_DIVISION = Optional.empty();
    public static final Optional<WithDataCategoryClause> NO_WITH_DATA_CATEGORY = Optional.empty();
    public static final List<SearchWithClause> EMPTY_WITHS = Collections.emptyList();
    public static final Optional<SearchUsingClause> NO_SOSL_USING = Optional.empty();
    public static final Optional<QueryUsingClause> NO_SOQL_USING = Optional.empty();
    public static final Optional<ReturningSelectExpr> NO_RETURNING_SELECT_EXPR = Optional.empty();
    public static final Optional<Expr> NO_EXPR = Optional.empty();
    public static final List<Expr> EMPTY_EXPRS = Collections.emptyList();
    public static final Optional<ForInits> NO_INITS = Optional.empty();
    public static final Optional<Stmnt> NO_STMNT = Optional.empty();
    public static final List<Stmnt> EMPTY_STMNTS = Collections.emptyList();
    public static final List<Modifier> EMPTY_MODIFIERS = Collections.emptyList();
    public static final Optional<Modifier> NO_MODIFIER = Optional.empty();
    public static final Optional<TypeRef> NO_TYPE = Optional.empty();
    public static final Optional<ElseBlock> NO_ELSE_BLOCK = Optional.empty();
    public static final Optional<FinallyBlock> NO_FINALLY = Optional.empty();
    public static final List<CatchBlock> NO_CATCHES = Collections.emptyList();
    public static final Identifier FOO_ID = Identifiers.newIdentifier("Foo");
    public static final TypeRef FOO_CLASS_TYPE = TypeRefBuilder.type(FOO_ID.getValue());
    public static final Identifier BAR_ID = Identifiers.newIdentifier("Bar");
    public static final Stmnt EMPTY_BLOCK = Stmnt._BlockStmnt(Locations.NONE, ImmutableList.of());
    private static final Identifier INTEGER_IDENTIFIER = Identifiers.newIdentifier("Integer");
    public static final TypeRef INTEGER_TYPE = TypeRefBuilder.type(INTEGER_IDENTIFIER.getValue());

    private JadtTester() {
    }

    public static Location pos(int line, int column) {
        return Locations.loc(0, 0, line, column);
    }

    public static Expr.VariableExpr variableExpr(Optional<Expr> dottedExpr, Identifier ... identifiers) {
        return new Expr.VariableExpr(dottedExpr, false, MoreLists.asImmutableList(identifiers));
    }

    public static Expr.VariableExpr variableSafeExpr(Optional<Expr> dottedExpr, Identifier ... identifiers) {
        return new Expr.VariableExpr(dottedExpr, true, MoreLists.asImmutableList(identifiers));
    }

    public static Expr.VariableExpr variableExpr(Identifier ... identifiers) {
        return JadtTester.variableExpr(Optional.empty(), identifiers);
    }

    public static Expr.MethodCallExpr methodCallExpr(Optional<Expr> dottedExpr, List<Expr> parameters, Identifier ... identifiers) {
        return new Expr.MethodCallExpr(dottedExpr, false, MoreLists.asImmutableList(identifiers), parameters);
    }

    public static Expr.MethodCallExpr methodCallSafeExpr(Optional<Expr> dottedExpr, List<Expr> parameters, Identifier ... identifiers) {
        return new Expr.MethodCallExpr(dottedExpr, true, MoreLists.asImmutableList(identifiers), parameters);
    }

    public static Expr.MethodCallExpr methodCallExpr(List<Expr> parameters, Identifier ... identifiers) {
        return JadtTester.methodCallExpr(Optional.empty(), parameters, identifiers);
    }

    public static Identifier identifier(int start, String name) {
        return Identifiers.newIdentifier(Locations.index(start, name.length()), name);
    }

    public static Field field(int start, String s) {
        return JadtTester.field(start, s, NO_IDENTIFIER, NO_IDENTIFIER);
    }

    public static Field field(int start, String name, Optional<Identifier> function1, Optional<Identifier> function2) {
        return Field._Field(JadtTester.fieldIdentifier(start, name), function1, function2);
    }

    public static FieldIdentifier fieldIdentifier(int start, String s) {
        return FieldIdentifier._FieldIdentifier(NO_FIELD_IDENTIFIER, JadtTester.identifier(start, s));
    }

    public static Optional<FieldIdentifier> someFieldIdentifier(int start, String name) {
        return Optional.of(JadtTester.fieldIdentifier(start, name));
    }

    public static QueryLiteral queryString(int start, String value) {
        return QueryLiteral._QueryString(Locations.index(start, value.length() + 2), value);
    }

    public static Expr.LiteralExpr exprString(String literal) {
        return new Expr.LiteralExpr(Locations.NONE, LiteralType.STRING, literal);
    }

    public static Expr.LiteralExpr exprString(int start, String literal) {
        return new Expr.LiteralExpr(Locations.index(start, literal.length() + 2), LiteralType.STRING, literal);
    }

    public static Optional<QueryUsingClause> someUsingClause(int start, UsingExpr ... exprs) {
        return Optional.of(QueryUsingClause._QueryUsingClause(Locations.index(start, 5), MoreLists.asImmutableList(exprs)));
    }

    public static UsingExpr usingLookup(int start, Identifier field) {
        return UsingExpr._Using(JadtTester.identifier(start, "LOOKUP"), field);
    }

    public static UsingExpr usingScope(int start, Identifier field) {
        return UsingExpr._Using(JadtTester.identifier(start, "SCOPE"), field);
    }

    public static ColonExpr colonVariableExp(int start, String name) {
        return ColonExpr._ColonExpr(Locations.index(start, 1), JadtTester.variableExpr(Optional.empty(), JadtTester.identifier(start + 1, name)));
    }

    public static Expr.LiteralExpr integerLiteral(int start, int literal) {
        Preconditions.checkArgument(literal >= 0, "negative integers need to be wrapped by a prefix negative");
        return new Expr.LiteralExpr(Locations.index(start, Integer.toString(literal).length()), LiteralType.INTEGER, literal);
    }

    public static Expr.LiteralExpr longLiteral(int start, long literal) {
        Preconditions.checkArgument(literal >= 0L, "negative integers need to be wrapped by a prefix negative");
        return new Expr.LiteralExpr(Locations.index(start, Long.toString(literal).length() + 1), LiteralType.LONG, literal);
    }

    public static Expr.LiteralExpr nullLiteral(int start) {
        return new Expr.LiteralExpr(Locations.index(start, LiteralType.NULL.toString().length()), LiteralType.NULL, null);
    }

    public static Stmnt.BlockStmnt emptyBlock(Location location) {
        return new Stmnt.BlockStmnt(location, ImmutableList.of());
    }
}

