/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.Comment;
import net.sourceforge.pmd.lang.java.ast.JavadocElement;
import net.sourceforge.pmd.lang.java.ast.Token;
import net.sourceforge.pmd.lang.java.javadoc.JavadocTag;

public class FormalComment
extends Comment {
    private static final Pattern JAVADOC_TAG = Pattern.compile("@([A-Za-z0-9]+)");

    public FormalComment(Token t) {
        super(t);
        this.findJavadocs();
    }

    public String getXPathNodeName() {
        return "FormalComment";
    }

    private void findJavadocs() {
        ArrayList<JavadocElement> kids = new ArrayList<JavadocElement>();
        Matcher javadocTagMatcher = JAVADOC_TAG.matcher(this.getFilteredComment());
        while (javadocTagMatcher.find()) {
            JavadocTag tag = JavadocTag.tagFor(javadocTagMatcher.group(1));
            int tagStartIndex = javadocTagMatcher.start(1);
            if (tag == null) continue;
            kids.add(new JavadocElement(this.getBeginLine(), this.getBeginLine(), tagStartIndex, tagStartIndex + tag.label.length() + 1, tag));
        }
        this.children = kids.toArray(new Node[0]);
    }
}

