/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.data.ast;

import apex.jorje.data.Identifier;
import apex.jorje.data.ast.Expr;
import java.util.List;

public abstract class WhenCase {
    private WhenCase() {
    }

    public static final WhenCase _EnumCase(List<Identifier> identifiers) {
        return new EnumCase(identifiers);
    }

    public static final WhenCase _LiteralCase(Expr expr) {
        return new LiteralCase(expr);
    }

    public abstract <ResultType> ResultType match(MatchBlock<ResultType> var1);

    public abstract void _switch(SwitchBlock var1);

    public static final class LiteralCase
    extends WhenCase {
        public Expr expr;

        public LiteralCase(Expr expr) {
            this.expr = expr;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.expr == null ? 0 : this.expr.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LiteralCase other = (LiteralCase)obj;
            return !(this.expr == null ? other.expr != null : !this.expr.equals(other.expr));
        }

        public String toString() {
            return "LiteralCase(expr = " + this.expr + ")";
        }
    }

    public static final class EnumCase
    extends WhenCase {
        public List<Identifier> identifiers;

        public EnumCase(List<Identifier> identifiers) {
            this.identifiers = identifiers;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.identifiers == null ? 0 : this.identifiers.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EnumCase other = (EnumCase)obj;
            return !(this.identifiers == null ? other.identifiers != null : !this.identifiers.equals(other.identifiers));
        }

        public String toString() {
            return "EnumCase(identifiers = " + this.identifiers + ")";
        }
    }

    public static abstract class SwitchBlockWithDefault
    implements SwitchBlock {
        @Override
        public void _case(EnumCase x) {
            this._default(x);
        }

        @Override
        public void _case(LiteralCase x) {
            this._default(x);
        }

        protected abstract void _default(WhenCase var1);
    }

    public static interface SwitchBlock {
        public void _case(EnumCase var1);

        public void _case(LiteralCase var1);
    }

    public static abstract class MatchBlockWithDefault<ResultType>
    implements MatchBlock<ResultType> {
        @Override
        public ResultType _case(EnumCase x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(LiteralCase x) {
            return this._default(x);
        }

        protected abstract ResultType _default(WhenCase var1);
    }

    public static interface MatchBlock<ResultType> {
        public ResultType _case(EnumCase var1);

        public ResultType _case(LiteralCase var1);
    }
}

