/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.index.node;

import apex.jorje.data.Location;
import apex.jorje.lsp.impl.index.ApexIndex;
import apex.jorje.lsp.impl.index.node.ApexMethodParameter;
import apex.jorje.lsp.impl.index.node.ApexType;
import apex.jorje.lsp.impl.index.node.ApexTypeId;
import java.util.List;
import org.eclipse.jdt.internal.core.nd.Nd;
import org.eclipse.jdt.internal.core.nd.NdNode;
import org.eclipse.jdt.internal.core.nd.db.IString;
import org.eclipse.jdt.internal.core.nd.field.FieldByte;
import org.eclipse.jdt.internal.core.nd.field.FieldInt;
import org.eclipse.jdt.internal.core.nd.field.FieldManyToOne;
import org.eclipse.jdt.internal.core.nd.field.FieldOneToMany;
import org.eclipse.jdt.internal.core.nd.field.FieldSearchKey;
import org.eclipse.jdt.internal.core.nd.field.FieldString;
import org.eclipse.jdt.internal.core.nd.field.StructDef;

public class ApexMethod
extends NdNode {
    public static final StructDef<ApexMethod> type = StructDef.create(ApexMethod.class, (StructDef)NdNode.type);
    static final FieldManyToOne<ApexType> DEFINING_TYPE = FieldManyToOne.createOwner(type, ApexType.METHODS);
    static final FieldOneToMany<ApexMethodParameter> PARAMETERS = FieldOneToMany.create(type, ApexMethodParameter.OWNER);
    static final FieldManyToOne<ApexTypeId> RETURN_TYPE = FieldManyToOne.create(type, ApexTypeId.USED_AS_RETURN_TYPE);
    public static final FieldSearchKey<ApexIndex> METHOD_NAME = FieldSearchKey.create(type, ApexIndex.METHODS);
    public static final FieldSearchKey<ApexIndex> TEST_METHOD = FieldSearchKey.create(type, ApexIndex.TEST_METHODS);
    private static final FieldByte IS_CONSTRUCTOR = type.addByte();
    private static final FieldString MODIFIERS = type.addString();
    private static final FieldInt DEFINITION_START_INDEX = type.addInt();
    private static final FieldInt DEFINITION_END_INDEX = type.addInt();
    private static final FieldInt DEFINITION_LINE = type.addInt();
    private static final FieldInt DEFINITION_COLUMN = type.addInt();
    private ApexTypeId returnType;

    public ApexMethod(Nd nd, long address) {
        super(nd, address);
    }

    public ApexMethod(ApexType definingType, Location loc) {
        super(definingType.getNd());
        DEFINING_TYPE.put(this.getNd(), this.address, (NdNode)definingType);
        DEFINITION_START_INDEX.put(this.getNd(), this.address, loc.getStartIndex());
        DEFINITION_END_INDEX.put(this.getNd(), this.address, loc.getEndIndex());
        DEFINITION_LINE.put(this.getNd(), this.address, loc.getLine());
        DEFINITION_COLUMN.put(this.getNd(), this.address, loc.getColumn());
    }

    public IString getMethodName() {
        return METHOD_NAME.get(this.getNd(), this.address);
    }

    public void setMethodName(String methodName) {
        METHOD_NAME.put(this.getNd(), this.address, methodName);
    }

    public void setIsConstructor() {
        IS_CONSTRUCTOR.put(this.getNd(), this.address, (byte)1);
    }

    public boolean isConstructor() {
        return IS_CONSTRUCTOR.get(this.getNd(), this.address) > 0;
    }

    public IString getModifiers() {
        return MODIFIERS.get(this.getNd(), this.address);
    }

    public void setModifiers(String modifiers) {
        MODIFIERS.put(this.getNd(), this.address, modifiers);
    }

    public ApexTypeId getReturnType() {
        return (ApexTypeId)RETURN_TYPE.get(this.getNd(), this.address);
    }

    public void setReturnType(ApexTypeId returnType) {
        RETURN_TYPE.put(this.getNd(), this.address, (NdNode)returnType);
    }

    public List<ApexMethodParameter> getParameters() {
        return PARAMETERS.asList(this.getNd(), this.address);
    }

    public Location getLocation() {
        return new Location(){

            @Override
            public int getStartIndex() {
                return DEFINITION_START_INDEX.get(ApexMethod.this.getNd(), ApexMethod.this.address);
            }

            @Override
            public int getEndIndex() {
                return DEFINITION_END_INDEX.get(ApexMethod.this.getNd(), ApexMethod.this.address);
            }

            @Override
            public int getLine() {
                return DEFINITION_LINE.get(ApexMethod.this.getNd(), ApexMethod.this.address);
            }

            @Override
            public int getColumn() {
                return DEFINITION_COLUMN.get(ApexMethod.this.getNd(), ApexMethod.this.address);
            }
        };
    }

    public void setIsTest() {
        TEST_METHOD.put(this.getNd(), this.address, this.getMethodName().getString());
    }

    public ApexType getDefiningType() {
        return (ApexType)DEFINING_TYPE.get(this.getNd(), this.address);
    }

    static {
        type.done();
    }
}

