/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.visitors;

import apex.jorje.lsp.api.document.Document;
import apex.jorje.lsp.impl.utils.ExtractUtil;
import apex.jorje.lsp.impl.utils.IndexUtil;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.visitor.Scope;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.lsp4j.CodeAction;

public class CodeActionScope
extends Scope {
    Optional<AstNode> node;
    private int nodeStartOffset;
    private int nodeEndOffset;
    private int nodeColumn;
    private int nodeDeclarationLine;
    private final Document doc;
    private final String source;
    private final int startOffset;
    private final int endOffset;
    private final List<CodeAction> codeActions;

    public CodeActionScope(int startOffset, int endOffset, Document doc) {
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.doc = doc;
        this.source = doc.getSource();
        this.node = Optional.empty();
        this.nodeStartOffset = -1;
        this.nodeEndOffset = -1;
        this.codeActions = new ArrayList<CodeAction>();
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public int getNodeStartOffset() {
        return this.nodeStartOffset;
    }

    public int getNodeEndOffset() {
        return this.nodeEndOffset;
    }

    public int getNodeColumn() {
        return this.nodeColumn;
    }

    public int getNodeDeclarationLine() {
        return this.nodeDeclarationLine;
    }

    public Optional<AstNode> getNode() {
        return this.node;
    }

    public void setNode(AstNode node) {
        this.node = Optional.of(node);
        this.nodeStartOffset = node.getLoc().getStartIndex();
        this.nodeEndOffset = IndexUtil.computeEndOffset(this.source, node);
        this.nodeColumn = node.getLoc().getColumn();
        this.nodeDeclarationLine = ExtractUtil.getLineNumber(node);
    }

    public Document getDocument() {
        return this.doc;
    }

    public String getSource() {
        return this.source;
    }

    public List<CodeAction> getCodeActions() {
        return this.codeActions;
    }

    public void addCodeAction(Optional<CodeAction> codeAction) {
        codeAction.ifPresent(this.codeActions::add);
    }
}

